// API请求签名工具类
// @author tao.xie
// @verson1.0

// 签名生成的通用步骤如下：
// 第一步，设所有发送或者接收到的数据为集合M，将集合M内非空参数值的参数按照参数名ASCII码从小到大排序（字典序），使用URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串stringA。

// 特别注意以下重要规则：
// ◆ 参数名ASCII码从小到大排序（字典序）；
// ◆ 如果参数的值为空不参与签名；
// ◆ 参数名区分大小写；
// ◆ 需要请求参数是Bean结构数据时，bean结点仍以JSON串组装，且整个json串做为value参与签名

// 第二步，在stringA最后拼接上secret得到stringSignTemp字符串，并对stringSignTemp进行MD5或SHA1运算，再将得到的字符串所有字符转换为大写，得到sign值signValue

// 必要参数
// 以下必要字段参与签名，每个交易都需要添加，不在交易接口描述中再做说明
//
// OAUTH_APPID	应用实例名
// OAUTH_METHOD	签名方法，目前支持MD5，SHA1,后续会兼容、SHA256、HMAC
// OAUTH_TIMESTAMP	时间截，以后误差不超过5分钟
// OAUTH_NONCE	随机数，建议使用纳秒数做为随机数
// OAUTH_OPENID	非必填项，如登陆后则采用SESSIONID作为OPENID

// 说明:其中secret为固定的一个字符串拼接上当前月份的英文,md5后专成大写字符串,并截取前16位,不足16位补足F

// 配置签名参数
var SALT = 'yAqPxwSTwLTwahTZWsdEmZJS'
// 配置是否启用签名
var SIGN = true
// ////////////////////以上是是否开启签名的配置////////////////////////////////////

/**
 * 签名函数.将JSON格式的请求字符串按预定的签名方式签名,并返回签名后可直接用于API传输的请求报文
 *
 * @param {Object}
 *            obj JSON格式的请求字符串 token API放问token sessionid
 *            登录的话就传入sessionid.没有的话就传空
 */
function sign(obj, token, sessionid) {
  if (SIGN) {
    // 转换成JSON对象
    // console.log("原始json串:" + obj)
    // console.log("--------------------------------------")

    var jsonObj = JSON.parse(obj)

    // 根据签名规则置入签名参数
    jsonObj = generateSignObj(jsonObj, token, sessionid)
    // console.log(jsonObj)
    // console.log("--------------------------------------")

    // 临时数组,用于存放JSON对象的key
    var tmpArr = []

    for (var key in jsonObj) {
      // 值非空
      // if (jsonObj[key] != undefined && jsonObj[key] != null)
      tmpArr[tmpArr.length] = key
    }

    // 字典排序
    tmpArr.sort()

    var result = ''

    // 遍历 并且拼接待签名的字符串
    for (var i in tmpArr) {
      var key = tmpArr[i]
      var value = jsonObj[key]

      if (jsonObj[key] == undefined || jsonObj[key] == null) value = ''

      // console.log(value)

      // console.log("urlbefore:" + (value.toString()));
      // 为了配合待签名的字符串中value不带引号,故判断value是否是JSON对象
      value = encodeURIComponent(isJson(value) ? JSON.stringify(value) : value)

      // console.log("urlafter:" + value)
      // console.log("--------------------------------------")
      value = value.replace(/\!/g, '%21')
      value = value.replace(/\'/g, '%27')
      value = value.replace(/\(/g, '%28')
      value = value.replace(/\)/g, '%29')
      value = value.replace(/\*/g, '%2A')

      var rs = key + '=' + value
      result += rs
      if (i < tmpArr.length - 1) result += '&'
    }

    // 直接拼接用于签名的secret
    result += generateSignKey()

    // console.log("代签名:" + result)

    // 将待签名的字符串做MD5签名,并转换成大写

    result = md5(result).toLocaleUpperCase()

    // 将签名结果置入JSON对象中
    jsonObj['SIGN'] = result

    jsonObj = removeKeyFromResult(jsonObj)

    return JSON.stringify(jsonObj)
  } else {
    return obj
  }
}

/**
 * 移除不参与签名的参数
 */
function removeKeyFromResult(jsonObj) {
  delete jsonObj['OAUTH_APPID']
  delete jsonObj['OAUTH_OPENID']
  return jsonObj
}

/**
 * 置入待签名参数
 *
 * @param {Object}
 *            jsonObj
 */
function generateSignObj(jsonObj, token, sessionid) {
  jsonObj['OAUTH_APPID'] = token
  jsonObj['OAUTH_METHOD'] = 'MD5'
  jsonObj['OAUTH_TIMESTAMP'] = Date.parse(new Date()) / 1000
  jsonObj['OAUTH_NONCE'] = generateUUID()
  if (
    sessionid != undefined &&
    sessionid != null &&
    sessionid != 'null' &&
    sessionid != ''
  ) { jsonObj['OAUTH_OPENID'] = sessionid }
  return jsonObj
}

/**
 * 通过固定的算法算出参与签名的参数
 *
 * @returns {String}
 */
function generateSignKey() {
  var monthCons = [
    'January',
    'February',
    'March',
    'April',
    'May',
    'June',
    'July',
    'August',
    'September',
    'October',
    'November',
    'December'
  ]
  var myDate = new Date()
  var month = monthCons[myDate.getMonth()]

  var key = md5(SALT + month).toLocaleUpperCase()

  // 截取16位 不足的话补足F
  key += 'FFFFFFFFFFFFFFF'
  return key.substring(0, 16)
}

/**
 * 生成UUID唯一字符窜
 */
function generateUUID() {
  var s = []
  var hexDigits = '0123456789abcdef'
  for (var i = 0; i < 36; i++) {
    s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1)
  }
  s[14] = '4' // bits 12-15 of the time_hi_and_version field to 0010
  s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1) // bits 6-7 of the
  // clock_seq_hi_and_reserved
  // to 01
  s[8] = s[13] = s[18] = s[23] = '-'

  var uuid = s.join('')
  return uuid
}

/**
 * 判断传入的对象是否是JSON对象
 *
 * @param {Object}
 *            obj
 */
function isJson(obj) {
  var isjson =
    typeof obj === 'object' &&
    Object.prototype.toString.call(obj).toLowerCase() == '[object object]' &&
    !obj.length
  var isArray = obj && typeof obj === 'object' && Array == obj.constructor
  return isjson || isArray
}

!(function(n) {
  function t(n, t) {
    var r = (65535 & n) + (65535 & t),
      e = (n >> 16) + (t >> 16) + (r >> 16)
    return (e << 16) | (65535 & r)
  }
  function r(n, t) {
    return (n << t) | (n >>> (32 - t))
  }
  function e(n, e, o, u, c, f) {
    return t(r(t(t(e, n), t(u, f)), c), o)
  }
  function o(n, t, r, o, u, c, f) {
    return e((t & r) | (~t & o), n, t, u, c, f)
  }
  function u(n, t, r, o, u, c, f) {
    return e((t & o) | (r & ~o), n, t, u, c, f)
  }
  function c(n, t, r, o, u, c, f) {
    return e(t ^ r ^ o, n, t, u, c, f)
  }
  function f(n, t, r, o, u, c, f) {
    return e(r ^ (t | ~o), n, t, u, c, f)
  }
  function i(n, r) {
    ;(n[r >> 5] |= 128 << r % 32), (n[(((r + 64) >>> 9) << 4) + 14] = r)
    var e,
      i,
      a,
      h,
      d,
      l = 1732584193,
      g = -271733879,
      v = -1732584194,
      m = 271733878
    for (e = 0; e < n.length; e += 16) {
      (i = l),
      (a = g),
      (h = v),
      (d = m),
      (l = o(l, g, v, m, n[e], 7, -680876936)),
      (m = o(m, l, g, v, n[e + 1], 12, -389564586)),
      (v = o(v, m, l, g, n[e + 2], 17, 606105819)),
      (g = o(g, v, m, l, n[e + 3], 22, -1044525330)),
      (l = o(l, g, v, m, n[e + 4], 7, -176418897)),
      (m = o(m, l, g, v, n[e + 5], 12, 1200080426)),
      (v = o(v, m, l, g, n[e + 6], 17, -1473231341)),
      (g = o(g, v, m, l, n[e + 7], 22, -45705983)),
      (l = o(l, g, v, m, n[e + 8], 7, 1770035416)),
      (m = o(m, l, g, v, n[e + 9], 12, -1958414417)),
      (v = o(v, m, l, g, n[e + 10], 17, -42063)),
      (g = o(g, v, m, l, n[e + 11], 22, -1990404162)),
      (l = o(l, g, v, m, n[e + 12], 7, 1804603682)),
      (m = o(m, l, g, v, n[e + 13], 12, -40341101)),
      (v = o(v, m, l, g, n[e + 14], 17, -1502002290)),
      (g = o(g, v, m, l, n[e + 15], 22, 1236535329)),
      (l = u(l, g, v, m, n[e + 1], 5, -165796510)),
      (m = u(m, l, g, v, n[e + 6], 9, -1069501632)),
      (v = u(v, m, l, g, n[e + 11], 14, 643717713)),
      (g = u(g, v, m, l, n[e], 20, -373897302)),
      (l = u(l, g, v, m, n[e + 5], 5, -701558691)),
      (m = u(m, l, g, v, n[e + 10], 9, 38016083)),
      (v = u(v, m, l, g, n[e + 15], 14, -660478335)),
      (g = u(g, v, m, l, n[e + 4], 20, -405537848)),
      (l = u(l, g, v, m, n[e + 9], 5, 568446438)),
      (m = u(m, l, g, v, n[e + 14], 9, -1019803690)),
      (v = u(v, m, l, g, n[e + 3], 14, -187363961)),
      (g = u(g, v, m, l, n[e + 8], 20, 1163531501)),
      (l = u(l, g, v, m, n[e + 13], 5, -1444681467)),
      (m = u(m, l, g, v, n[e + 2], 9, -51403784)),
      (v = u(v, m, l, g, n[e + 7], 14, 1735328473)),
      (g = u(g, v, m, l, n[e + 12], 20, -1926607734)),
      (l = c(l, g, v, m, n[e + 5], 4, -378558)),
      (m = c(m, l, g, v, n[e + 8], 11, -2022574463)),
      (v = c(v, m, l, g, n[e + 11], 16, 1839030562)),
      (g = c(g, v, m, l, n[e + 14], 23, -35309556)),
      (l = c(l, g, v, m, n[e + 1], 4, -1530992060)),
      (m = c(m, l, g, v, n[e + 4], 11, 1272893353)),
      (v = c(v, m, l, g, n[e + 7], 16, -155497632)),
      (g = c(g, v, m, l, n[e + 10], 23, -1094730640)),
      (l = c(l, g, v, m, n[e + 13], 4, 681279174)),
      (m = c(m, l, g, v, n[e], 11, -358537222)),
      (v = c(v, m, l, g, n[e + 3], 16, -722521979)),
      (g = c(g, v, m, l, n[e + 6], 23, 76029189)),
      (l = c(l, g, v, m, n[e + 9], 4, -640364487)),
      (m = c(m, l, g, v, n[e + 12], 11, -421815835)),
      (v = c(v, m, l, g, n[e + 15], 16, 530742520)),
      (g = c(g, v, m, l, n[e + 2], 23, -995338651)),
      (l = f(l, g, v, m, n[e], 6, -198630844)),
      (m = f(m, l, g, v, n[e + 7], 10, 1126891415)),
      (v = f(v, m, l, g, n[e + 14], 15, -1416354905)),
      (g = f(g, v, m, l, n[e + 5], 21, -57434055)),
      (l = f(l, g, v, m, n[e + 12], 6, 1700485571)),
      (m = f(m, l, g, v, n[e + 3], 10, -1894986606)),
      (v = f(v, m, l, g, n[e + 10], 15, -1051523)),
      (g = f(g, v, m, l, n[e + 1], 21, -2054922799)),
      (l = f(l, g, v, m, n[e + 8], 6, 1873313359)),
      (m = f(m, l, g, v, n[e + 15], 10, -30611744)),
      (v = f(v, m, l, g, n[e + 6], 15, -1560198380)),
      (g = f(g, v, m, l, n[e + 13], 21, 1309151649)),
      (l = f(l, g, v, m, n[e + 4], 6, -145523070)),
      (m = f(m, l, g, v, n[e + 11], 10, -1120210379)),
      (v = f(v, m, l, g, n[e + 2], 15, 718787259)),
      (g = f(g, v, m, l, n[e + 9], 21, -343485551)),
      (l = t(l, i)),
      (g = t(g, a)),
      (v = t(v, h)),
      (m = t(m, d))
    }
    return [l, g, v, m]
  }
  function a(n) {
    var t,
      r = '',
      e = 32 * n.length
    for (t = 0; e > t; t += 8) { r += String.fromCharCode((n[t >> 5] >>> t % 32) & 255) }
    return r
  }
  function h(n) {
    var t,
      r = []
    for (r[(n.length >> 2) - 1] = void 0, t = 0; t < r.length; t += 1) r[t] = 0
    var e = 8 * n.length
    for (t = 0; e > t; t += 8) { r[t >> 5] |= (255 & n.charCodeAt(t / 8)) << t % 32 }
    return r
  }
  function d(n) {
    return a(i(h(n), 8 * n.length))
  }
  function l(n, t) {
    var r,
      e,
      o = h(n),
      u = [],
      c = []
    for (
      u[15] = c[15] = void 0, o.length > 16 && (o = i(o, 8 * n.length)), r = 0;
      r < 16;
      r += 1
    ) { (u[r] = 909522486 ^ o[r]), (c[r] = 1549556828 ^ o[r]) }
    return (e = i(u.concat(h(t)), 512 + 8 * t.length)), a(i(c.concat(e), 640))
  }
  function g(n) {
    var t,
      r,
      e = '0123456789abcdef',
      o = ''
    for (r = 0; r < n.length; r += 1) { (t = n.charCodeAt(r)), (o += e.charAt((t >>> 4) & 15) + e.charAt(15 & t)) }
    return o
  }
  function v(n) {
    return unescape(encodeURIComponent(n))
  }
  function m(n) {
    return d(v(n))
  }
  function p(n) {
    return g(m(n))
  }
  function s(n, t) {
    return l(v(n), v(t))
  }
  function C(n, t) {
    return g(s(n, t))
  }
  function A(n, t, r) {
    return t ? (r ? s(t, n) : C(t, n)) : r ? m(n) : p(n)
  }
  typeof define === 'function' && define.amd
    ? define(function() {
      return A
    })
    : typeof module === 'object' && module.exports
      ? (module.exports = A)
      : (n.md5 = A)
})(this)
