cordova.define("easysw-plugin-barcodescanner", function(require, exports, module) {

var exec = require('cordova/exec');

var barcodescanner = {

    /**
     * 扫描QRCode
     * @return 失败或取消扫描以failureCallback回调
     *          扫描成功以successCallback通知
     */
    scanQRCode:function(successCallback, failureCallback){
        exec(successCallback,failureCallback, 'BarcodeScanner', 'scanQRCode',[]);
    },


    /**
     * 生成qrcode的二维码图片
     * @ qrCode  将生成二维码的内容
     * @ width   二维码图片的大小
     * @return 图片按base64编号后回调
     */
    encodeQRCode:function(successCallback, failureCallback,qrCode,width){
        exec(successCallback,failureCallback, 'BarcodeScanner', 'encodeQRCode',[qrCode,width]);
    },

};

module.exports = barcodescanner
});