cordova.define("easysw-plugin-customerservice", function(require, exports, module) {

var exec = require('cordova/exec');

var customerservice = {

   /**
     * 设备用户信息
     * @uid  用户sid
     * @name 用户称呼
     * @mobile Phone 手机号码
     * head Image 头像
     */
    setUserInfo:function(successCallback, failureCallback,uid,name,mobilePhone,headImage){
        exec(successCallback, failureCallback, 'CustomerServicePlugin', 'setUserInfo',[uid,name,mobilePhone,headImage]);
    },


    /**
     * 退出
     */
    logout:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'CustomerServicePlugin', 'logout',[]);
    },

   /**
     * 打开客服咨询界面 （指定客服）
     * @title  标题 (string)
     * @groupId 客服分组 （-1表示没有分组）
     * @source 设置访客来源 (json格式{"title":"来源页标题","url":"来源url","data":"自定义数据"})
     */
    openServiceActivity:function(successCallback, failureCallback,title, groupId,source){
        exec(successCallback, failureCallback,'CustomerServicePlugin', 'openServiceActivity',[title,groupId,source]);
    },


    /**
     * 打开客服咨询界面 （先由客服机器人接待）
     * @title  标题 (string)
     * @groupId 客服分组 （-1表示没有分组）
     & @faqGroupId FAQ 客服机器人分组 （-1表示没有分组）
     * @source 设置访客来源 (json格式{"title":"来源页标题","url":"来源url","data":"自定义数据"})
     */
   openServiceActivityWithFAQ:function(successCallback, failureCallback,title,groupId,faqGroupId,source){
        exec(successCallback, failureCallback, 'CustomerServicePlugin', 'openServiceActivityWithFAQ',[title,groupId,faqGroupId,source]);
   },

    /**
     * 打开客服咨询界面 （汇报商品信息）
     * @title  标题 (string)
     * @groupId 客服分组 （-1表示没有分组）
     * @source 设置访客来源 (json格式{"title":"来源页标题","url":"来源url","data":"自定义数据"})
     & @product 产品信息（json格式 {"title":"产品标题","desc":"产品详情","note":"备注(价格，套餐)","picture":"图片url","url":"产品链接"}）
     */
   openServiceActivitySendProduct:function(successCallback, failureCallback,title,groupId,source,product){
        exec(successCallback, failureCallback, 'CustomerServicePlugin', 'openServiceActivitySendProduct',[title,groupId,source,product]);
   },

   /**
     * 获取未读客服消息数量
     */
   getUnreadCount:function(successCallback, failureCallback){
          exec(successCallback,failureCallback, 'CustomerServicePlugin', 'getUnreadCount',[]);
   }



};

module.exports = customerservice
});