cordova.define("easysw-plugin-location", function(require, exports, module) {

var exec = require('cordova/exec');

var location = {

    /**
     * 判断GPS开关是否打开
     * @return 是否打开 （boolean类型）
     */
    isGPSOpen:function(successCallback, failureCallback){
        exec(successCallback,failureCallback, 'LocationPlugin', 'isGPSOpen',[]);
    },


    /**
     * 打开GPS 设置界面
     */
    openGPSSetting:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'LocationPlugin', 'openGPSSetting',[]);
    },

    /**
     * 打开定位服务
     */
    startService:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'LocationPlugin', 'startService',[]);
    },

     /**
      * 打开定位服务
      */
    stopService:function(successCallback, failureCallback){
          exec(successCallback, failureCallback, 'LocationPlugin', 'stopService',[]);
    },

    /**
     * 获取当前定位
     * @return 定位坐标 （json 格式 {"latitude":"","longitude":"","pname":"省份","cname":"城市","aname":"城区","acode":"城市编码","poi":"创新中国产业园","add":"浙江省杭州市沈家路319号"}）
     */
    getCurrentPosition: function(successCallback, failureCallback)
    {
       exec(successCallback,failureCallback, 'LocationPlugin', 'getCurrentPosition',[]);
    },

    /**
    * 拉起高德地图.传入当前位置的经度和纬度,实现定位功能
    *
    *  @longitude 经度
    *  @latitude 纬度
    *
    */
   openGaoDeAppByCurrentPosition:function(successCallback, failureCallback,longitude,latitude){
        exec(successCallback,failureCallback, 'LocationPlugin', 'openGaoDeAppByCurrentPosition',[longitude,latitude]);
   },


};

module.exports = location
});