cordova.define("easysw-plugin-system", function(require, exports, module) {

var exec = require('cordova/exec');

var x_system = {

    /**
    * 获得设备信息
    * @return 设备信息(string类型) {"cid":"xxxx","imei":"","ver":""}
    */
    getDeviceInfo: function(successCallback, failureCallback)
    {
	    exec(successCallback, failureCallback, 'SystemPlugin', 'getDeviceInfo',[]);
    },

    /**
     * 获取系统版本号
     * @return  系统版本号(string类型)  E.g., "1.0" or "3.4b5".
     */
    getOSVersion:function(successCallback, failureCallback){
          exec(successCallback, failureCallback, 'SystemPlugin', 'getOSVersion',[]);
    },

    /**
     * 获取网络接入方式.
     * @return  网络接入方式（0:未知, 1:手机网络，2:无线WIFI）
     */
    getNetworkType:function(successCallback, failureCallback){
          exec(successCallback, failureCallback, 'SystemPlugin', 'getNetworkType',[]);
    },

    /**
     * 获取个推的PushCID
     * @return  pushcid (类型string)
     */
    getPushCID:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'getPushCID',[]);
    },

   /**
    *  清空缓存
    */
    cleanCache:function(successCallback, failureCallback){
         exec(successCallback, failureCallback, 'SystemPlugin', 'cleanCache',[]);
    },

    /**
     * 弹出照片选择器
     * maxSelect 最大选择数量
     * @return 照片的地址路径 （文件路径数据  ["file://xxx/xx.png","file://xxx/xxx.png"]）
     */
    photoPicker:function(successCallback, failureCallback, maxSelec, width, height){
        if(width&&height)
            exec(successCallback, failureCallback, 'SystemPlugin', 'doChoosePhoto',[maxSelec, width, height]);
        else
            exec(successCallback, failureCallback, 'SystemPlugin', 'doChoosePhoto',[maxSelec, 0,0]);
    },





   /**
     * 弹出省份与城市选择器
     * @return 省份与城市 （数据结构  {"pname":"省份","cname":"城市","aname":"城区","acode":"邮编"}）
     */
    addressPicker:function(successCallback, failureCallback, selectcode){
        exec(successCallback, failureCallback, 'SystemPlugin', 'doChooseCity',[selectcode]);
    },

   /**
     * 调高屏幕亮度
     */
   improveBrightness:function(successCallback, failureCallback){

        exec(successCallback, failureCallback, 'SystemPlugin', 'improveBrightness',[]);
   },

   /**
    * 恢复屏幕亮度
    */
   resetBrightness:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'resetBrightness',[]);
   },

   /**
    * 设置自动屏幕亮度
    */
   setAutoBrightness:function(successCallback, failureCallback, auto){
        exec(successCallback, failureCallback, 'SystemPlugin', 'setAutoBrightness',[auto]);
   },

   /**
     * 设置屏幕亮度
      @param brightness 亮度值 ，暗到全亮(0-255)
     */
   setWindowsBrightness:function(successCallback, failureCallback, brightness){
        exec(successCallback, failureCallback, 'SystemPlugin', 'setWindowsBrightness',[brightness]);
   },

  /**
    * 获取屏幕亮度值
    * return 亮度值 ，暗到全亮(0-255)
    */
   getWindowsBrightness:function(successCallback,failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'getWindowsBrightness',[]);
   },

   /**
     * 判断是否开启自动亮度
     * return 是否自动亮度 （boolean 类型）
     */
   isAutoBrightness:function(successCallback,failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'isAutoBrightness',[]);
   },

    /**
    * 注册Push监听事件
    * messageId： 需要监听的message事件id
    * callback:   push消息回调方法名称
    */
   registerPushListener:function(successCallback, failureCallback, messageId,callback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'registerPushListener',[messageId,callback]);
   },

   /**
    * 取消Push监听事件
    * messageId： 监听的message事件id
    */
   unRegisterPushListener:function(successCallback, failureCallback, messageId){
        exec(successCallback, failureCallback, 'SystemPlugin', 'unRegisterPushListener',[messageId]);
   },


    /**
     * 文件上传
     * req: {"bucket":"xb-image","endpoint":"oss-cn-qingdao.aliyuncs.com","ossFolder":"jhx/user/image/wrq_zj/",
     *          "files":[
     *              {"filePath":"/storage/emulated/0/Boohee/20170628nYafd3YTpW.png","ossPath":"jhx/user/image/wrq_zj/20170628nYafd3YTpW.png"}
     *          ]
     *        }
     * bucket: oss bucket
     * endpoint: oss 接入点
     * ossFolder: 文件上传oss的目录位置, 当指定ossPath时，ossFolder可为空,不能以'/'或'\'开头
     * filePath:  上传的文件路径.文件的绝对路径, 以/开头
     * ossPath:   上传文件的oss保存路径,不指定ossPath，则上传至ossFolder目录下,不能以'/'或'\'开头
     */
    uploadFiles:function(successCallback, failureCallback, req){

        exec(successCallback, failureCallback, 'SystemPlugin', 'uploadFiles',[req]);
    },

     /**
     * 选定视屏区域内拍照
     * width 拍照区域宽度
     * height 拍照区域高度
     * @return 照片的地址路径 （文件路径数据  ["file://xxx/xx.png","file://xxx/xxx.png"]）
     */
    takePhotoByArea:function(successCallback, failureCallback,  width,  height){
         exec(successCallback, failureCallback, 'SystemPlugin', 'takePhotoByArea',[width, height]);
    },


     /**
     * 图片列表显示
     * width req  图片显示地址列表
     *
     */
    viewImageList:function(successCallback, failureCallback,  req){
         exec(successCallback, failureCallback, 'SystemPlugin', 'viewImageList',[req]);
    },

    /**
     * 退出App
     */
    closeApp:function(successCallback, failureCallback){
         exec(successCallback, failureCallback, 'SystemPlugin', 'closeApp',[]);
    },

    /**
     * 打开浏览器
     */
    openBrowser:function(successCallback, failureCallback, url){
         exec(successCallback, failureCallback, 'SystemPlugin', 'openBrowser',[url]);
    },


    /**
     * 窗体打开浏览器
     */
    openWindowUrl:function(successCallback, failureCallback, url, wscale, hscale){
         exec(successCallback, failureCallback, 'SystemPlugin', 'openWindowUrl',[url, wscale, hscale]);
    },

    /**
     * 设置缓存
     * key   缓存的key
     * value 缓存的值
     */
    setCache:function(successCallback, failureCallback, key, value){
        exec(successCallback, failureCallback, 'SystemPlugin', 'setCache',[key, value]);
    },

    /**
     * 获取缓存
     * key 缓存的key
     */
    getCache:function(successCallback, failureCallback, key){
        exec(successCallback, failureCallback, 'SystemPlugin', 'getCache',[key]);
    },

    /**
     * 移除缓存
     * key 要移除的缓存的key
     */
    removeCache:function(successCallback, failureCallback, key){
        exec(successCallback, failureCallback, 'SystemPlugin', 'removeCache',[key]);
    },

    /**
     * 清除所有缓存
     */
    clearCache:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'clearCache',[]);
    },

    /**
    * 获取软件版本信息
    * @param 软件版本信息 {"version":"2.1.1","build":"100"}
    */
    getAppVersionInfo:function(successCallback, failureCallback){
         exec(successCallback, failureCallback, 'SystemPlugin', 'getAppVersionInfo',[]);
    },

    /**
    * 检测APP版本
    *
    */
    checkAppVersion:function(successCallback, failureCallback){
        exec(successCallback, failureCallback, 'SystemPlugin', 'checkAppVersion',[]);
    },

     /**
    * 设置消息总数
    *
    */
    syncUnreadMessageCount:function(successCallback, failureCallback, messageCount){
        exec(successCallback, failureCallback, 'SystemPlugin', 'syncUnreadMessageCount',[messageCount]);
    },
       /**
        * 打开线路详情地图
        * @param lineId 线路id(必填)
        * @param direction 线路方向，1上行2下行(必填)
        * @param unifiedId 站点id，默认选择的站点id(必填)
        */
       openBusLineMap:function(successCallback, failureCallback, lineId, direction, unifiedId) {
           exec(successCallback, failureCallback, 'SystemPlugin', "openBusLineMap", [lineId,direction,unifiedId])
       }
};

module.exports = x_system
});