cordova.define("easysw-plugin-thirdparty", function(require, exports, module) {

var exec = require('cordova/exec');

var thirdparty = {

    /**
     * 调起支付
     * @payment 支付方式. WXPAY 微信, ALIPAY 支付宝
     * @payInfo 支付信息
     * @return  失败或取消以failureCallback回调
     *          支付成功以successCallback通知  无参数
     */
    doPayment:function(successCallback, failureCallback, payment, payInfo){
        exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'doPayment',[payment,payInfo]);
    },



    /**
     * 获取设备支持的支付方式列表
     *
     * @return  失败或取消以failureCallback回调
     *          支付成功以successCallback通知 ,返回数据为JSON 数组格式
     *          ["WXPAY","ALIPAY"]
     */
    getPaymentSupportList:function(successCallback, failureCallback){
         exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'getPaymentSupportList',[]);
    },


    /**
     * 一键分享
     * @title   分享文章title
     * @content 文章内容
     * @picUrl  图片url
     * @url     文章url
     * @return   失败或取消以failureCallback回调
     *           支付成功以successCallback通知     无参数
     */
    doOnekeyShare:function(successCallback, failureCallback,title, content, picUrl, url){
        exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'doOnekeyShare',[title,content,picUrl,url]);
    },

    /**
     * 授权登录
     * @thirdPartyName 第三方名称 (QQ,Wechat,SinaWeibo)
     * @return   失败或取消以failureCallback回调
     *           支付成功以successCallback通知
     *    微信授权返回
     *      {
     *          "openid": "o6_bmjrPTlm6_2sgVt7hMZOPfL2M","nickname": "Band","sex": 1,"language": "zh_CN","city": "广州","province": "广东","country": "中国","province":[],
     *          "headimgurl":  "http://wx.qlogo.cn/mmopen/g3MonUZtNHkdmzicIlibx6iaFqAc56vxLSUfpb6n5WKSYVY0ChQKkiaJSgQ1dZuTOgvLLrhJbERQQ4eMsv84eavHiaiceqxibJxCfHe/0",
     *           "unionid": " o6_bmasdasdsad6_2sgVt7hMZOPfL"
     *       }
     */
    doAuthorizedLogin:function(successCallback, failureCallback,thirdPartyName){
        exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'doAuthorizedLogin',[thirdPartyName]);
    },

    /**
     * 记录业务数据
     * @eventId 业务事件ID
     * @eventInfo  业务消息 { "业务信息": "支付页面"}
     * @count  次数
     */
    doRecordEvent:function(successCallback, failureCallback, eventId,  eventInfo, count){
            exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'doRecordEvent',[eventId, eventInfo, count]);
    },

      /**
       * 显示公交线路信息
       * @param linename  公交线路名
       * @param direction   方向
       * @param longitude   经度
       * @param latitude   维度
       */
        doMapBusLineShow:function(successCallback, failureCallback, linename,  direction, longitude, latitude){
            exec(successCallback,failureCallback, 'ThirdPartyPlugin', 'doMapBusLineShow',[linename, direction, longitude,latitude ]);
        },

    /**
     * 获取新闻列表
     * channelId 频道id
     * num 获取的新闻数量
     * cutVideos 是否过滤掉视频类新闻 true过滤 false不过滤
     * example: channelid=657, num=2, 返回
     *  [{"algInfo":"|I_RCNT_HOT|cat-61","channelId":"657","hasVideo":true,"imgType":3,"infoId":"D2M4QRHL9001QRHM","infoType":"article","num":0,"producer":"recommendation","readStatus":0,"recId":"cbc7cffe79984e44b5b99ac5e0b2dd18","source":"融中财经","summary":"2008年，奥运会开完了，黄光裕“进去了”。在此后的9年中，黄光裕在狱中艰难维持着国美的大局。第一，目标制定后，执行起来不择手段。","thumbnails":[{"height":200,"url":"http://cms-bucket.nosdn.127.net/bb7388a6f6af4ae581a99122b69a263720171108074951.png?imageView&thumbnail=300y200","width":300},{"height":200,"url":"http://cms-bucket.nosdn.127.net/813ee5de25824fda8f3b7a514fe2b20a20171108075005.png?imageView&thumbnail=300y200","width":300},{"height":200,"url":"http://cms-bucket.nosdn.127.net/0033cbbddd2343919718ad620cfd5b9120171108074958.png?imageView&thumbnail=300y200","width":300}],"title":"黄光裕出狱前做了3件事，国美重出江湖","updateTime":"2017-11-08 07:58:37"},{"algInfo":"|I_RCNT_HOT|cat-95","channelId":"657","hasVideo":false,"imgType":1,"infoId":"VM1O8A3PS","infoType":"video","num":0,"producer":"recommendation","readStatus":0,"recId":"cbc7cffe79984e44b5b99ac5e0b2dd18","source":"老胡说体育","thumbnails":[{"height":0,"url":"http://vimg2.ws.126.net/image/snapshot/2017/11/P/T/VM1O8A3PT.jpg","width":0}],"title":"邱建良远征国外遇最不要脸对手和裁判 连断头台都出来了","updateTime":"2017-11-08 14:52:06","videos":[{"cover":"http://vimg2.ws.126.net/image/snapshot/2017/11/P/T/VM1O8A3PT.jpg","duration":193,"hdUrl":"http://flv.bn.netease.com/videolib3/1711/07/FjVvK4098/HD/FjVvK4098.flv","m3u8HdUrl":"http://flv.bn.netease.com/videolib3/1711/07/FjVvK4098/HD/movie_index.m3u8","m3u8SdUrl":"http://flv.bn.netease.com/videolib3/1711/07/FjVvK4098/SD/movie_index.m3u8","mp4HdUrl":"http://flv3.bn.netease.com/videolib3/1711/07/FjVvK4098/HD/FjVvK4098-mobile.mp4","mp4SdUrl":"http://flv3.bn.netease.com/videolib3/1711/07/FjVvK4098/SD/FjVvK4098-mobile.mp4","playsize":1,"sdUrl":"http://flv.bn.netease.com/videolib3/1711/07/FjVvK4098/SD/FjVvK4098.flv","shdUrl":"http://flv.bn.netease.com/videolib3/1711/07/FjVvK4098/SHD/FjVvK4098.flv"}]}]
     */
    getNewsList:function(successCallback, failureCallback, channelId, num, cutVideos) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'getNewsList',[channelId, num, cutVideos]);
    },

     /*
      * 打开新闻详情
      * newsinfo 新闻的实体类
      *
      *  {"algInfo":"|I_RCNT_HOT|cat-61","channelId":"657","hasVideo":true,"imgType":3,"infoId":"D2M4QRHL9001QRHM","infoType":"article","num":0,"producer":"recommendation","readStatus":0,"recId":"cbc7cffe79984e44b5b99ac5e0b2dd18","source":"融中财经","summary":"2008年，奥运会开完了，黄光裕“进去了”。在此后的9年中，黄光裕在狱中艰难维持着国美的大局。第一，目标制定后，执行起来不择手段。","thumbnails":[{"height":200,"url":"http://cms-bucket.nosdn.127.net/bb7388a6f6af4ae581a99122b69a263720171108074951.pngimageView&thumbnail=300y200","width":300},{"height":200,"url":"http://cms-bucket.nosdn.127.net/813ee5de25824fda8f3b7a514fe2b20a20171108075005.pngimageView&thumbnail=300y200","width":300},{"height":200,"url":"http://cms-bucket.nosdn.127.net/0033cbbddd2343919718ad620cfd5b9120171108074958.pngimageView&thumbnail=300y200","width":300}],"title":"黄光裕出狱前做了3件事，国美重出江湖","updateTime":"2017-11-08 07:58:37"}
      */
    openNewsDetail:function(successCallback, failureCallback, newsinfo) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'openNewsDetail',[newsinfo]);
    },

    /**
     * 获取广告信息
     * @param adChannelId  广告位ID
     * @return "{"adContent":"头条日报-热点资讯，头条新闻，每日精选","adDesc":"","adId":"c29352120a0bad4855edba08b9e8c6fd","adPic":"http://ubmcmm.baidustatic.com/media/v1/0f000PYkzFN4EpVv09XDZs.jpg","adTitle":"头条日报"}"
     */
    getAdInfo:function(successCallback, failureCallback, adChannelId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'getAdInfo', [adChannelId])
    },

    /**
     * 广告点击
     * @param adId 广告id
     */
    adClick:function(successCallback, failureCallback, adId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'adClick', [adId])
    },

    /**
     * 获取信用支付账户数据
     * @param phone 查询账户的手机号
     * @param externalId 用户id  (String)
     * @return "{"status":0用户未注册或未认证 1用户已认证,"user_name":"姓名","id_card":"身份证","valid_amount":"可用额度","credit_amount":"总额度","debt_amount":"待还款金额","customers_status":"用户状态01 启用  02禁用"}"
     */
    getArrayPayMessage:function(successCallback, failureCallback, phone, externalId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'getArrayPayMessage',[phone, externalId])
    },

    /**
      * 开通信用付实名认证
      * @param phone 开通手机号
      * @param externalId 用户id  (String)
      * @return {"user_name":"姓名","user_idcard":"身份证","idcard_image":"人脸照片的本地存储路径","bank_cardNo":"银行卡号","valid_amount":"可用额度"}
      */
    openArrayPayAuthentication:function(successCallback, failureCallback, phone, externalId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'openArrayPayAuthentication', [phone, externalId])
    },

    /**
     * 打开信用付账户管理界面
     * @param phone 账户手机号码
     * @param externalId 用户id  (String)
     * @param iconUrl 头像的在线地址
     */
    openArrayPayAccount:function(successCallback, failureCallback, phone, externalId, iconUrl) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'openArrayPayAccount', [phone, externalId, iconUrl])
    },

    /**
     * 云卡实名认证
     * @param phone 账户手机号码
     * @param externalId 用户id
     * @return {"user_name":"姓名","user_idcard":"身份证","idcard_image":"人脸照片的本地存储路径"}
     */
    openCardAuthentication:function(successCallback, failureCallback, phone, externalId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'openCardAuthentication', [phone, externalId])
    },

    /**
     * 唐山实体卡充值
     * @param userId
     */
    openCardRecharge:function(successCallback, failureCallback, userId, sessionId) {
        exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'openCardRecharge', [userId,sessionId])
    },

    /**
     * 获取设置了到站提醒的站点列表
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback 失败回调
     * @return [] 站点信息数组,如[{LINE_ID:'123',LINE_TYPE:1,'STATION_ID':'212121',STATION_SORT:12}]
     */
    getAttentionStationList: function(successCallback, failureCallback) {
      exec(
        successCallback,
        failureCallback,
        'ThirdPartyPlugin',
        'getAttentionStationList',
        []
      )
    },

    /**
     * 获取设置了下车提醒的车辆列表
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback 失败回调
     * @return [] 车辆信息数组，如[{LINE_ID:'124',LINE_TYPE:2,BUS_ID:'1234'}]
     */
    getAttentionBusList: function(successCallback, failureCallback) {
      exec(
        successCallback,
        failureCallback,
        'ThirdPartyPlugin',
        'getAttentionBusList',
        []
      )
    },

    /**
     * 获取锁定了的车辆列表
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback 失败回调
     * @return [] 车子ID数组，如[‘1234’]
     */
    getFocusedBusList: function(successCallback, failureCallback) {
      exec(
        successCallback,
        failureCallback,
        'ThirdPartyPlugin',
        'getFocusedBusList',
        []
      )
    },

    /**
     * 设置到站提醒，设置和取消设置都调用该插件
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback 失败回调
     * @param {Integer} lineID 线路ID
     * @param {Integer} lineType  线路方向
     * @param {String} stationId  站点ID
     * @param {Integer} stationSort 站点序号
     * @param {Boolean} attention 设置或者取消设置,true为设置，false为取消设置
     */
    setAttentionStation: function(
      successCallback,
      failureCallback,
      lineID,
      lineType,
      stationId,
      stationSort,
      attention
    ) {
      exec(
        successCallback,
        failureCallback,
        'ThirdPartyPlugin',
        'setAttentionStation',
        [lineID, lineType, stationId, stationSort, attention]
      )
    },

    /**
     * 车辆信息模态弹窗
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback  失败回调
     * @param {Integer} lineID 线路ID
     * @param {Integer} lineType 线路方向
     * @param {String} busID 车辆ID
     */
    showBusInfoMask: function(
      successCallback,
      failureCallback,
      lineID,
      lineType,
      busID
    ) {
      exec(
        successCallback,
        failureCallback,
        'ThirdPartyPlugin',
        'showBusInfoMask',
        [lineID, lineType, busID]
      )
    },

    /**
     * 锁定车辆
     * @param {Function} successCallback 成功回调
     * @param {Function} failureCallback  失败回调
     * @param {String} busID 车辆ID
     */
    focusBus: function(successCallback, failureCallback, busID) {
      exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'focusBus', [
        busID
      ])
    },

    /**
      * 唤起地图选择器打开地图APP进行导航
      * @param {Function} successCallback 成功回调
      * @param {Function} failureCallback  失败回调
      * @param {String} latitude 纬度
      * @param {String} longitude 经度
      * @param {String} address 地址
      */
    selectMap: function(successCallback, failureCallback, latitude, longitude, address) {
       exec(successCallback, failureCallback, 'ThirdPartyPlugin', 'selectMap', [
          latitude,
          longitude,
          address
       ])
    },
    /**
           * 打开唐山行SDK年检页面
           * @param {Function} successCallback 成功回调
           * @param {Function} failureCallback  失败回调
           * @param {Function} failureCallback  失败回调
           */
    openTSXModule: function(successCallback, failureCallback, moduleName) {
        exec(successCallback,
               failureCallback,
               'ThirdPartyPlugin',
               'openTSXModule',
               [moduleName]
               )
        }


};

module.exports = thirdparty
});