cordova.define("easysw-plugin-toast", function(require, exports, module) {

function Toast() {

}

Toast.prototype.optionsBuilder = function () {

  // defaults
  var message = null;
  var duration = "short";
  var position = "center";
  var addPixelsY = 0;

  return {
    withMessage: function(m) {
      message = m;
      return this;
    },

    withDuration: function(d) {
      duration = d;
      return this;
    },

    withPosition: function(p) {
      position = p;
      return this;
    },

    withAddPixelsY: function(y) {
      addPixelsY = y;
      return this;
    },

    build: function() {
      return {
        message: message,
        duration: duration,
        position: position,
        addPixelsY: addPixelsY
      }
    }
  }
};


    Toast.prototype.showWithOptions = function (options, successCallback, errorCallback) {
        cordova.exec(successCallback, errorCallback, "Toast", "show", [options]);
    };

    /**
    *   自行设置Toast配置参数
    */
    Toast.prototype.show = function (message, duration, position, successCallback, errorCallback) {
        this.showWithOptions(
            this.optionsBuilder()
                .withMessage(message)
                .withDuration(duration)
                .withPosition(position)
                .build(),
            successCallback, errorCallback);
    };

    /**
    *   显示时间：Short
    *   显示位置：Top
    */
    Toast.prototype.showShortTop = function (message, successCallback, errorCallback) {
        this.show(message, "short", "top", successCallback, errorCallback);
    };


    /**
    *   显示时间：Short
    *   显示位置：Center
    */
    Toast.prototype.showShortCenter = function (message, successCallback, errorCallback) {
        this.show(message, "short", "center", successCallback, errorCallback);
    };


    /**
    *   显示时间：Short
    *   显示位置：Bottom
    */
    Toast.prototype.showShortBottom = function (message, successCallback, errorCallback) {
      this.show(message, "short", "bottom", successCallback, errorCallback);
    };


    /**
    *   显示时间：Long
    *   显示位置：Top
    */
    Toast.prototype.showLongTop = function (message, successCallback, errorCallback) {
        this.show(message, "long", "top", successCallback, errorCallback);
    };


    /**
    *   显示时间：Long
    *   显示位置：Center
    */
    Toast.prototype.showLongCenter = function (message, successCallback, errorCallback) {
        this.show(message, "long", "center", successCallback, errorCallback);
    };

    /**
    *   显示时间：Long
    *   显示位置：Bottom
    */
    Toast.prototype.showLongBottom = function (message, successCallback, errorCallback) {
        this.show(message, "long", "bottom", successCallback, errorCallback);
    };

    /**
    *   隐藏toast
    */
    Toast.prototype.hide = function (successCallback, errorCallback) {
        cordova.exec(successCallback, errorCallback, "Toast", "hide", []);
    };

    Toast.install = function () {
        if (!window.plugins) {
            window.plugins = {};
        }
        x_toast = new Toast();
        return x_toast;
    };

    cordova.addConstructor(Toast.install);

});
