cordova.define("easysw-plugin-ui", function(require, exports, module) {

var exec = require('cordova/exec');

var ui = {


    /**
     * 显示对话框的函数
     * @ title  对话框Title
     * @ msg   对话框内容
     * @confirm 对话框 confirm文字
     * @cancel 对话框 cancel文字
     * @successCallback 返回 confirm返回值 0, cancel 返回值 1
     */
    showDialog:function(successCallback, failureCallback,title,msg, confirm, cancel){
        exec(successCallback,failureCallback, 'UiPlugin', 'showDialog',[title,msg, confirm, cancel]);
    },

    /**
     * 页面刷新结束
     */
     onFinishRefresh:function(successCallback, failureCallback){
         exec(successCallback,failureCallback, 'UiPlugin', 'onFinishRefresh',[]);
     },

      /**
       *  设置title
       *  @ title  页面显示的Title
       */
       setTitle:function(successCallback, failureCallback,title){
          exec(successCallback,failureCallback, 'UiPlugin', 'setTitle',[title]);
       },
        /*设置页面左边菜单
        "{\"menuid\":\"1\",\"menutext\":\"公交\",\"menuicon\":\"bus\"}";
        *  menuid     菜单id
        *  menutext   菜单显示文字
        *  menuicon   菜单显示icon
         *  设置title的左键Item
         *  @ menuitem  页面左键的内容
        */
        setLeftItem:function(successCallback, failureCallback, menuitem){
            exec(successCallback,failureCallback, 'UiPlugin', 'setLeftItem',[menuitem]);
        },

        /*"[{\"menuid\":1,\"menutext\":\"公交\",\"menuicon\":\"bus\"}, {\"menuid\":2,\"menutext\":\"密码\",\"menuicon\":\"pwd\"},{\"menuid\":3,\"menutext\":\"电话\",\"menuicon\":\"tel\"}]"
        *  menuid     菜单id
        *  menutext   菜单显示文字
        *  menuicon   菜单显示icon
        *
         *  设置title的右键菜单
         *  @ menuitem  页面右键的内容数组
        */
        setRightItem:function(successCallback, failureCallback, menuitems){
            exec(successCallback,failureCallback, 'UiPlugin', 'setRightItem',[menuitems]);
        },

        /*
         *
          *  移除title的右键菜单
         */
         removeAllRightItem:function(successCallback, failureCallback){
             exec(successCallback,failureCallback, 'UiPlugin', 'removeAllRightItem', []);
         },

        /*
        *labels的结构:"[{\"value\":\"bus\",\"label\":\"公交\"},{\"value\":\"bike\",\"label\":\"自行车\"}]"
        *
        *value 菜单值,选取后底层返回
        *label 菜单名称,用于展示
        *
        *弹出式菜单,默认底部添加取消选项. 当用户选择时返回value值,用户取消以usercancel的方式failureCallback返回
        *@labels菜单内容数组
        *@title 顶部的提示性文字
        */
        showActionSheet:function(successCallback, failureCallback,title,labels){
            exec(successCallback,failureCallback, 'UiPlugin', 'showActionSheet',[title,labels]);
        },

         /*
         *labels的结构:"[{\"value\":\"bus\",\"label\":\"公交\",\"selected\":1},{\"value\":\"bike\",\"label\":\"自行车\",\"selected\":0}]"
         *
         *value 选项值,选取后底层返回
         *label 选项名称,用于展示
         *selected 是否默认选中,为1时默认选中
         *
         *时间轮子选择器.当用户选择时返回value值,用户取消以usercancel的方式failureCallback返回
         *@labels菜单内容数组
         *
         */
        showDatePicker:function(successCallback, failureCallback,labels){
             exec(successCallback,failureCallback, 'UiPlugin', 'showDatePicker',[labels]);
        },


         /*
         *@startdate 起始时间 for example 1980-01-01
         *@enddate 结束 for example 2099-12-31
         *defaultdate 默认初始选中时间 for example 2012-02-02
         *
         *时间轮子选择器.支持yyyy-MM-dd和yyyy-MM格式,由传入的时间格式决定.当用户选择时返回value值,用户取消以usercancel的方式failureCallback返回
         *
         */
         showCustomDatePicker:function(successCallback, failureCallback, startdate, enddate, defaultdate){
                  exec(successCallback,failureCallback, 'UiPlugin', 'showCustomDatePicker',[startdate, enddate, defaultdate]);
         },

        /**
         * 设置下拉刷新开关
         * @ flag  true开启下拉刷新,false关闭下拉刷新
         */
        setRefreshFlag:function(successCallback, failureCallback, flag){
                   exec(successCallback,failureCallback, 'UiPlugin', 'setRefreshFlag',[flag]);
         },

        /**
         * 重新加载url
         *
         */
        reload:function(successCallback, failureCallback){
                   exec(successCallback,failureCallback, 'UiPlugin', 'reload',[]);
         },


        /**
        * 弹出自定义列表选取框. 带自定义的标题 描述 和列表选择数组. 参考支付宝选择支付方式的弹出框
        * 当选择某一选项时,以successCallback形式返回并带上oid. 当点击取消按钮时,以failureCallback形式返回
        * 控件列表显示区域的高度取6条选项的高度.
        *
        * 以下是业务参数描述:
        * @ title  显示的标题(必填)
        * @ desc  显示的描述(非必填)
        * @ options 选项列表(必填) "[{\"oid\":\"bus\",\"oname\":\"公交\",\"oimgurl\":\"1.png\",\"selected\":1},
        *                     {\"oid\":\"bike\",\"oname\":\"自行车\",\"oimgurl\":\"2.png\",\"selected\":0}]"
        *           其中oid是选项的id,oname是单条选项显示的名称,oimgurl是单条选项显示的图标, selected是单条选项是否默认选中
        * @showCancel 是否显示底部取消按钮，true显示，false隐藏
        */
        showOptionPicker:function(successCallback, failureCallback,title,desc,options){
            exec(successCallback,failureCallback, 'UiPlugin', 'showOptionPicker',[title,desc,options]);
        },

        /**
         * 设置标题栏是否可见
         * @param show   true设置可见，false隐藏不可见
         */
        setTitleBarVisible:function(successCallback, failureCallback,show) {
            exec(successCallback, failureCallback, 'UiPlugin', 'setTitleBarVisible', [show]);
        }




};

module.exports = ui
});