// 网页版的支付方式
var WAP_PAYMENT_LIST = ['UNIONPAY_WAP', 'JINHUA_CHENGTAI', 'ZHENJIANG_ABC']

// 支付方式对应的名称列表
var PAYMENT_CONFIG_LIST = {
  ALIPAY: {
    TYPE: 'ALIPAY',
    NAME: '支付宝', // 展示的支付名称
    ICON_URL: './static/image/payment/ali.png', // 本地图片路径
    NATIVE_ICON: 'pay_ali', // 底层的图片名称
    CONSUME_TYPE: 5 // 云卡账单中的类型
  },
  WXPAY: {
    TYPE: 'WXPAY',
    NAME: '微信',
    ICON_URL: './static/image/payment/wx.png',
    NATIVE_ICON: 'pay_wx',
    CONSUME_TYPE: 4
  },
  WXJSPAY: {
    TYPE: 'WXJSPAY',
    NAME: '微信',
    ICON_URL: './static/image/payment/wx.png',
    NATIVE_ICON: 'pay_wx',
    CONSUME_TYPE: 6
  },
  STAFF_CARD: {
    TYPE: 'STAFF_CARD',
    NAME: '员工卡',
    ICON_URL: './static/image/payment/pay_staffcard.png',
    NATIVE_ICON: 'pay_staffcard',
    CONSUME_TYPE: NaN
  },
  POINTS: {
    TYPE: 'POINTS',
    NAME: '试豆支付',
    ICON_URL: './static/image/payment/beanpay.png',
    NATIVE_ICON: 'pay_bean',
    CONSUME_TYPE: NaN
  },
  UNIONPAY_WAP: {
    TYPE: 'UNIONPAY_WAP',
    NAME: '银联支付', // 丽州添加的银联支付WAP版
    ICON_URL: './static/image/payment/union.png',
    NATIVE_ICON: 'pay_union',
    CONSUME_TYPE: 60
  },
  JINHUA_CHENGTAI: {
    TYPE: 'JINHUA_CHENGTAI',
    NAME: '丰收e支付', // 金华行添加的成泰银行WAP版
    ICON_URL: './static/image/payment/chengtai.png',
    NATIVE_ICON: 'pay_chengtai',
    CONSUME_TYPE: 61
  },
  ZHENJIANG_ABC: {
    TYPE: 'ZHENJIANG_ABC',
    NAME: '农行电子账户支付', // 金华行添加的成泰银行WAP版
    ICON_URL: './static/image/payment/abc_electric.png',
    NATIVE_ICON: 'pay_abc_electric',
    CONSUME_TYPE: 62
  }
}

var ORDER_TYPE_MAP = {
  NORMAL: 1, // 普通订单
  TRY_LUCK: 4, // 试手气订单
  TRIAL_DAILY: 5 // 每日试订单
}

var STYPE_MAP = {
  ONLINE: 0, // 线上普通商品
  OFFLINE: 4, // 线下自提商品
  BRT: 3, // 电子票
  RECHARGE: 6 // 云卡充值
}

// 支付中转页
var pay_mid_page = 'xbapp://open/shop-app/PayMidPage.html?_knbw=true'
// 银联支付成功回调地址在线页面
var online_paysuccess_page = 'http://wx.xiaobu.hk/static/onlinepaysuccess.html'

/**
 * 获取支付方式列表的方法
 * @param {Number} otype 订单类型
 * @param {Number} stype 商品类型
 */
var getWapPaymentList = function (otype, stype) {
  // if (!otype && !stype) {
  //   return WAP_PAYMENT_LIST
  // }
  if (otype === ORDER_TYPE_MAP.NORMAL) {
    if (stype === STYPE_MAP.BRT || stype === STYPE_MAP.RECHARGE) {
      return WAP_PAYMENT_LIST
    }
  }
  return []
}

/**
 * 获取支付方式列表，返回整个支付类型的数据
 * @param {Number} otype 订单类型
 * @param {Number} stype 商品类型
 * @param {Function} successCallback 成功回调
 * @param {Function} failureCallback 失败回调
 */
var getAllSupportPaymentList = function (
  otype,
  stype,
  successCallback,
  failureCallback
) {
  callPlugins(
    'x_thirdparty',
    new Date().getTime(),
    function () {
      if (window.prodInApp) {
        x_thirdparty.getPaymentSupportList(
          function (msg) {
            successCallback(parsePaymentList(msg, otype, stype))
          },
          function (msg) {
            consoleError(
              'x_thirdparty.getPaymentSupportList',
              '获取支付方式失败'
            )
            failureCallback(msg)
          }
        )
      } else {
        successCallback(parsePaymentList('["ALIPAY","WXPAY"]', otype, stype))
      }
    },
    function () {
      consoleError('x_thirdparty.getPaymentSupportList', '插件调用失败')
      failureCallback()
    }
  )
}

function parsePaymentList(msg, otype, stype) {
  var nativePayList = JSON.parse(msg)
  var wapPayList = getWapPaymentList(otype, stype)
  nativePayList = wapPayList.concat(nativePayList)
  var paymentList = []
  // 获取支付配置
  for (var i = 0; i < nativePayList.length; i++) {
    var payType = nativePayList[i]
    if (window.CLOSE_WXPAY && payType === 'WXPAY') {
    }
    var payment = PAYMENT_CONFIG_LIST[nativePayList[i]]
    paymentList.push(payment)
  }
  return paymentList
}

/**
 * 获取WAP版支付回调地址
 * @param {String} payment 支付方式
 * @param {Number} otype 订单类型
 * @param {Number} stype 商品类型
 * @param {String} fromUrl 来源地址
 */
var getWapPayCallbackUrl = function (payment, otype, stype, fromUrl) {
  var pageUrl = null
  switch (payment) {
    case 'ZHENJIANG_ABC':
      break
    case 'JINHUA_CHENGTAI':
      if (!fromUrl) {
        // 如果传入的url是空的则取当前的url作为地址
        // url = "file:///android_asset/www/city-app/recharge.html?_rv=false&_tv=true&_abs=true&_bbv=true&_im=true";
        var thispageurl = Window.Location.getHref()
        fromUrl = thispageurl.split('www/')[1].split('.html')[0]
        fromUrl += '.html'
      }
      pageUrl = 'xbapp://goback/' + fromUrl
      break
    case 'UNIONPAY_WAP':
      // 'stype'x'orderType'
      var type = stype + 'x' + otype
      pageUrl = online_paysuccess_page + '?stype=' + type
      break
  }
  return pageUrl
}

/**
 * 执行支付操作
 * @param {String} payment 支付方式
 * @param {String} payInfo 支付信息，成泰和银联是表单，农行是跳转地址
 * @param {Function} successCallback 成功回调
 * @param {Function} failureCallback 失败回调
 */
var doPaymentByType = function (
  payment,
  payInfo,
  successCallback,
  failureCallback
) {
  switch (payment) {
    case 'ALIPAY':
    case 'WXPAY':
      // 通过插件拉起支付的sdk
      callPlugins(
        'x_thirdparty',
        new Date().getTime(),
        function () {
          if (window.prodInApp) {
            x_thirdparty.doPayment(
              successCallback,
              function (msg) {
                consoleError('x_thirdparty.doPayment', '支付失败')
                failureCallback(msg)
              },
              payment,
              payInfo
            )
          } else {
            successCallback()
          }
        },
        function () {
          consoleError('x_thirdparty.doPayment', '插件调用失败')
          failureCallback()
        }
      )
      break
    case 'UNIONPAY_WAP':
    case 'JINHUA_CHENGTAI':
      // 跳转到支付中转页，请求支付表单
      localStorage.setItem('PAYJUMPFORM', payInfo)
      location.assign(pay_mid_page)
      break
    case 'ZHENJIANG_ABC':
      // 直接跳转到对应的银行支付页
      location.assign(payInfo)
      break
    default:
      // 员工卡需要成功回调
      successCallback()
      break
  }
}

function callPlugins(packageName, time, successCallback, failureCallback) {
  if (window[packageName] || !window.prodInApp) {
    successCallback()
  } else {
    if (new Date().getTime() - time > 5000) {
      failureCallback()
    } else {
      setTimeout(function () {
        callPlugins(packageName, time, successCallback, failureCallback)
      }, 50)
    }
  }
}

function consoleError(key, msg) {
  console.error('~~~' + key + '===>>> ' + msg)
}

// 标注着提供给外部调用的js方法
// export { getAllSupportPaymentList, getWapPayCallbackUrl, doPaymentByType }
