a/*
 * Licensed to Xtooltech Co.,LTD 2020
 *
 * http://www.xtooltech.com/
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
window.cordova={};
window.cordova.plugins={};
(async function() {
    await CefSharp.BindObjectAsync("systemPlugin");
    //systemPlugin.execute(function(){},"MathAdd","");
    //alert('ok');
    let exports={};
    init(exports);
    //window.cordova={};
    //window.cordova.plugins={};
    window.cordova.plugins.DiagnosticApplicationPlugin=exports;
    //alert(window.cordova.plugins);
    //document.dispatchEvent(new Event('deviceready'));
    var to=setTimeout(function(){document.dispatchEvent(new Event('deviceready'));clearTimeout(to);},2000);
})();

function init(exports) {
    
    var globalEventHandlers=[];//{name:string,callback:function}
    /**
        success callback wraps event framework.
        @args json string which is a javascript event object.
    */
    function successWrapper(args){
        //alert(args);
        if(globalEventHandlers && globalEventHandlers.length>0){
            var event=JSON.parse(args);
            for(var i=0;i<globalEventHandlers.length;i++){
                try{
                    if(globalEventHandlers[i]!=null && globalEventHandlers[i].callback!=null){
                        globalEventHandlers[i].callback(event);
                    }
                }catch (e){
                    alert(e);// production environment remove this.
                }
            }
        }
    }
    function errorWrapper(args){

        alert("error:"+args);
    }
    /**
        callback placeholder,do nothing.
    */
    function successStub(){}
    function errorStub(){}
    /**
        add a global callback.
    */
    exports.addEventHandler = function(name,eventHandler){
        if(eventHandler && name && name!=""){

            if(globalEventHandlers==null || globalEventHandlers.length==0){//first time.
                //globalEventHandler=eventHandler;
                systemPlugin.execute(successWrapper, 'registerGlobalCallback', "[DiagnisisUI]");//just call once.
            }//else{//change.
            //globalEventHandler=eventHandler;
            //}
            var exists=false;
            for(var i=0;i<globalEventHandlers.length;i++){
                if(globalEventHandlers[i].name==name){
                    globalEventHandlers[i].callback=eventHandler;
                    exists=true;
                    break;
                }
            }
            if(!exists){
                globalEventHandlers.push({name:name,callback:eventHandler});
            }

            return true;
        }
        return false;
    };
    /**
     *  remove a global callback.
     */
    exports.removeEventHandler = function(name){

        if(globalEventHandlers!=null && globalEventHandlers.length>0){
            for(var i=0;i<globalEventHandlers.length;i++){
                if(globalEventHandlers[i].name==name){
                    globalEventHandlers[i].callback=null;
                    break;
                }
            }
        }
    };
    exports.mathAdd = function (success) {//a test method.
        systemPlugin.execute(success, 'mathAdd', "");
    };

    //enter main ui package.
    exports.enterMainApplication = function () {
        systemPlugin.execute(successStub,  'enterMainApplication', "[]");
    };
    /**
        check & install all of local diagnosis package.
        @return progress will received in global event handler.
    */
    exports.installLocalPackage = function () {
        systemPlugin.execute(successStub,  'installLocalPackage', "[]");
    };
    exports.prepareLocalUIPackage = function () {

        systemPlugin.execute(successStub,  'prepareLocalUIPackage', "[]");
    };
    /*
        uninstall diagnosis package which has been installed.
        @packageId id of package which identify a package.
        @return notification will be sent as a event which processed by global event handler.
    */
    exports.uninstallPackage = function (packageId) {

        systemPlugin.execute(successStub,  'uninstallPackage',JSON.stringify( [packageId]));
    };
    /*
        install diagnosis packages which have been downloaded.
        @param files a collection of package file.
        @return notification will be sent as a event which processed by global event handler.
    */
    exports.installPackages = function (files) {

        systemPlugin.execute(successStub,  'installPackages', JSON.stringify([files]));
    };
    /*
        download and install diagnosis packages which are newest.
        @return notification will be sent as a event which processed by global event handler.
     */
    exports.downloadAndInstallAllPackages = function () {
        systemPlugin.execute(successStub,  'downloadAndInstallAllPackages', "[]");
    };
    /*
        download and install diagnosis packages which are newest.
        @return notification will be sent as a event which processed by global event handler.
     */
    exports.downloadAndInstallPackage = function (id) {
        systemPlugin.execute(successStub,  'downloadAndInstallPackage', JSON.stringify([id]));
    };
    exports.downloadCancel = function (id, callback) {
        systemPlugin.execute(successStub,  'downloadCancel', JSON.stringify([id]));
    };
    /**
        check if local ui package is exists.
        @param callback callback accepts one string parameter,ui package path or empty.
        @note if callback passed empty parameter,should call downloadAndInstallUI,otherwise
                call enterMainApplication to enter application leave current page.
    */
    exports.checkUIPackage = function (callback) {

        systemPlugin.execute(callback,  'checkUIPackage', "[]");
    };
    /**
        download remote ui package and install it associates to device model.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.downloadAndInstallUI = function () {

        systemPlugin.execute(successStub,  'downloadAndInstallUI', "[]");
    };
    /**
        check the device or app whether has been activated.
        @param callback get result immediately by call this method.
    */
    exports.checkActivated = function (callback) {

        systemPlugin.execute(callback,  'checkActivated', "[]");
    };
    /**
        login cloud platform.
        @return notifications will be sent as events which processed by global event handler.
    */

    exports.login = function (obj) {
        var loginInfo = null
        if(obj){
            loginInfo = [obj]
        }else{
            loginInfo = []
        }
        systemPlugin.execute(successStub,  'login', JSON.stringify(loginInfo));
    };
    /**
        check remote diagnosis packages.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.checkDiagnosticPackage = function () {

        systemPlugin.execute(successStub,  'checkDiagnosticPackage', "[]");
    };
    /**
        login cloud platform.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.getApplicationProfile = function (callback) {
        systemPlugin.execute(callback,  'getApplicationProfile', "[]");
    };
    /**
        set application profile(user profile only).
        @return notifications will be sent by callback,1:success,0:failed.
    */
    exports.setApplicationProfile = function (callback, profile) {
        systemPlugin.execute(callback,  'setApplicationProfile', JSON.stringify([profile]));
    };

    exports.getLocalPackages = function () {
        systemPlugin.execute(successStub,  'getLocalPackages', "[]");
    };
    /**
       run diagnostic application.
       @return notifications will be sent as events which processed by global event handler.
    */
    exports.runDiagnosticPackage = function (appid) {
        systemPlugin.execute(successStub,  'runDiagnosticPackage', JSON.stringify([appid]));
    };
    /**
     back in current running diagnostic application.
    @return notifications will be sent as events which processed by global event handler.
    */
    exports.diagnosticBack = function () {
        systemPlugin.execute(successStub,  'diagnosticBack', "[]");
    };
    exports.diagnosticSelect = function (obj) { //{key,int[] params}
        systemPlugin.execute(successStub,  'diagnosticSelect', JSON.stringify([obj]));
    };
    exports.diagnosticInput = function (obj) { //{key,string[] params}
        systemPlugin.execute(successStub,  'diagnosticInput', JSON.stringify([obj]));
    };
    exports.diagnosticSelectList = function (obj) { //{int key,int selectedCount,int[] items}
        systemPlugin.execute(successStub,  'diagnosticSelectList', JSON.stringify([obj]));
    };
    exports.forceStop = function () {
        systemPlugin.execute(successStub,  'forceStop', "[]");
    };
    exports.downloadAndInstallApp = function (url) {
        systemPlugin.execute(successStub,  'downloadAndInstallApp', JSON.stringify([url]));
    };
    exports.getBoundBluetooth = function (callback) {
        systemPlugin.execute(callback,  'getBoundBluetooth', "[]");
    };
    exports.getBoundBluetoothAsyn = function () {
        systemPlugin.execute(successStub,  'getBoundBluetoothAsyn', "[]");
    }; //sendData
    exports.sendData = function (data) {
        systemPlugin.execute(successStub,  'sendData', JSON.stringify([data]));
    };
	exports.commonPost = function (data) {
        systemPlugin.execute(successStub,  'commonPost', JSON.stringify([data]));
	};
	exports.commonPostSync = function (callback,data) {
	    systemPlugin.execute(callback,  'commonPost', JSON.stringify([data]));
    };
    exports.getEcuDataLocalBackups = function (data) {
	    systemPlugin.execute(successStub,'getEcuDataLocalBackups', JSON.stringify([data]));
	};
	exports.UpdataEcuDataLocalFile = function (data) {
	    systemPlugin.execute(successStub, 'UpdataEcuDataLocalFile', JSON.stringify([data]));
	};
	exports.delEcuDataLocalBackups = function (callback,data) {
	    systemPlugin.execute(callback,'delEcuDataLocalBackups', JSON.stringify([data]));
	};
    exports.getDiagReports = function (cond, pageIndex, pageSize) {
        systemPlugin.execute(successStub,  'getDiagReports', JSON.stringify([cond, pageIndex, pageSize]));
    };
    exports.getDiagReportDetail = function (reportId) {
        systemPlugin.execute(successStub,  'getDiagReportDetail', JSON.stringify([reportId]));
    };
    exports.removeDiagReport = function (callback, reportId) {
        systemPlugin.execute(callback,  'removeDiagReport', JSON.stringify([reportId]));
    };
    exports.getDiagPath = function () {
        systemPlugin.execute(successStub,  'getDiagPath', "[]");
    };
    exports.openWifiSystem = function () {
        systemPlugin.execute(successStub,  'openWifiSystem', "[]");
    };
    exports.connectWifi = function (ssid, pwd) {
        systemPlugin.execute(successStub,  'connectWifi', JSON.stringify([ssid, pwd]));
    };
    exports.closeWifiSystem = function () {
        systemPlugin.execute(successStub,  'closeWifiSystem', "[]");
    };
    exports.setWifiState = function (enable) {
        systemPlugin.execute(successStub,  'setWifiState', JSON.stringify([(enable ? "1" : "0")]));
    };
    exports.openMediaSystem = function () {
        systemPlugin.execute(successStub,  'openMediaSystem', "[]");
    };
    exports.closeMediaSystem = function () {
        systemPlugin.execute(successStub,  'closeMediaSystem', "[]");
    };
    exports.openAlbum = function () {
        systemPlugin.execute(successStub,  'openAlbum', "[]");
    };
    exports.capturePhoto = function () {
        systemPlugin.execute(successStub,  'capturePhoto', "[]");
    };
    exports.startScanVin = function () {
        systemPlugin.execute(successStub,  'startScanVin', "[]");
    };
    exports.stopScanVin = function (callback) {
        systemPlugin.execute(callback,  'stopScanVin', "[]");
    };
    exports.scanBarcode = function (width, height) {
        systemPlugin.execute(successStub,  'scanBarcode', JSON.stringify([width, height]));
    };
    exports.launchMainActivity = function (callback, packageName) {
        systemPlugin.execute(callback,  'launchMainActivity', JSON.stringify([packageName]));
    };
    exports.getUserMaintainStorages = function (callback, repositories) {
        systemPlugin.execute(callback,  'getUserMaintainStorages', JSON.stringify(repositories));
    };
    exports.addStorageNode = function (path, isFile) {
        systemPlugin.execute(successStub,  'addStorageNode', JSON.stringify([path, isFile]));
    };
    exports.removeStorageNode = function (callback, path) {
        systemPlugin.execute(callback,  'removeStorageNode', JSON.stringify([path]));
    };
    exports.copyStorageNode = function (pathFrom, pathTo) {
        systemPlugin.execute(successStub,  'copyStorageNode', JSON.stringify([pathFrom, pathTo]));
    };
    exports.listStorageNodes = function (path, showHidden) {
        systemPlugin.execute(successStub,  'listStorageNodes', JSON.stringify([path, showHidden]));
    };
    exports.startDataStreamRecord = function () {
        systemPlugin.execute(successStub,  'startDataStreamRecord', "[]");
    };
    exports.stopDataStreamRecord = function () {
        systemPlugin.execute(successStub,  'stopDataStreamRecord', "[]");
    };
    exports.startDataStreamPlay = function (path) {
        systemPlugin.execute(successStub,  'startDataStreamPlay', JSON.stringify([path]));
    };
    exports.stopDataStreamPlay = function () {
        systemPlugin.execute(successStub,  'stopDataStreamPlay', "[]");
    };
    exports.pauseDataStreamPlay = function () {
        systemPlugin.execute(successStub,  'pauseDataStreamPlay', "[]");
    };
    exports.resumeDataStreamPlay = function () {
        systemPlugin.execute(successStub,  'resumeDataStreamPlay', "[]");
    };
    exports.findVehicleByVin = function (callback, vin) {
        systemPlugin.execute(callback,  'findVehicleByVin', JSON.stringify([vin]));
    };

    // runDiagnosticLinkPackageEX
    exports.runDiagnosticLinkPackageEX = function (appid,chilredid,mode, params) {
        var ps = [appid,chilredid,mode];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                ps.push(params[i]);
            }
        }
        systemPlugin.execute(successStub,  'runDiagnosticLinkPackageEX', JSON.stringify(ps));
    };

    exports.runDiagnosticPackageEx = function (appid, mode, params) {
        var ps = [appid, mode];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                ps.push(params[i]);
            }
        }
        systemPlugin.execute(successStub,  'runDiagnosticPackageEx', JSON.stringify(ps));
    };
    exports.printPdf = function (path, pages) {
        systemPlugin.execute(successStub,  'printPdf', JSON.stringify([path, pages]));
    };
    exports.sendEmail = function (subject, to, content, attachFiles) {
        var ps = [subject, to, content];
        if (attachFiles) {
            for (var i = 0; i < attachFiles.length; i++) {
                ps.push(attachFiles[i]);
            }
        }
        systemPlugin.execute(successStub,  'sendEmail', JSON.stringify(ps));
    };
    exports.download = function (urls) {
        systemPlugin.execute(successStub,  'download', JSON.stringify(urls));
    };
    exports.uploadVin = function (vininfo) {
        systemPlugin.execute(successStub,  'uploadVin', JSON.stringify([vininfo]));
    };
    exports.openUrl = function (callback, uri, mimeType) {
        systemPlugin.execute(callback,  'openUrl', JSON.stringify([uri, mimeType]));
    };
    exports.updateDiagReport = function (data) {
        systemPlugin.execute(successStub,  'updateDiagReport', JSON.stringify([data]));
    };
    exports.getMaintainDoc = function () {
        systemPlugin.execute(successStub,  'getMaintainDoc', "[]");
    };
    exports.restAPI = function (url, method, postData) {
        systemPlugin.execute(successStub,  'restAPI', JSON.stringify([url, method, postData]));
    };
    exports.openSystemSettings = function (callback, name) {
        systemPlugin.execute(callback,  'openSystemSettings', JSON.stringify([name]));
    };
    exports.installMasterApp = function (remoteUrl, nextTime) {
        systemPlugin.execute(successStub,  'installMasterApp', JSON.stringify([remoteUrl, nextTime]));
    };
    exports.startSelfTest = function () {
        systemPlugin.execute(successStub,  'startSelfTest', "[]");
    };
    exports.getTryoutTimes = function () {
        systemPlugin.execute(successStub,  'getTryoutTimes', "[]");
    };
    exports.installEmbededVinDatabase = function(){
        systemPlugin.execute(successStub,'installEmbededVinDatabase',"[]");
    };
    exports.diagnosticBackEx = function (ptType) {
        systemPlugin.execute(successStub,  'diagnosticBackEx', JSON.stringify([ptType]));
    };
    exports.diagnosticSelectEx = function (obj) { //{int pt,int key,int[] params}
        systemPlugin.execute(successStub,  'diagnosticSelectEx', JSON.stringify([obj]));
    };
    exports.diagnosticInputEx = function (obj) { //{int pt,int key,string[] params}
        systemPlugin.execute(successStub,  'diagnosticInputEx', JSON.stringify([obj]));
    };
    exports.diagnosticSelectListEx = function (obj) { //{int pt,int key,int selectedCount,int[] items}
        systemPlugin.execute(successStub,  'diagnosticSelectListEx', JSON.stringify([obj]));
    };
    exports.listEcuDataFile = function (obj) {
        systemPlugin.execute(successStub, 'listEcuDataFile', JSON.stringify([obj]));
    };
    exports.scoreEcuDataFile = function (obj) {
        systemPlugin.execute(successStub,'scoreEcuDataFile', JSON.stringify([obj]));
    };
    exports.downloadEcuDataFile = function (obj) {
        systemPlugin.execute(successStub,'downloadEcuDataFile', JSON.stringify([obj]));
    };
    exports.enterUpgradeListView = function () {
        systemPlugin.execute(successStub,'enterUpgradeListView', "[]");
    };
    exports.exitUpgradeListView = function () {
        systemPlugin.execute(successStub,'exitUpgradeListView', "[]");
    };
    exports.enterEcuFileListView = function () {
        systemPlugin.execute(successStub, 'enterEcuFileListView', "[]");
    };
    exports.exitEcuFileListView = function () {
        systemPlugin.execute(successStub, 'exitEcuFileListView', "[]");
    };
    exports.getVoltage = function () {
        systemPlugin.execute(successStub,'getVoltage', "[]");
    };
    exports.getTtys = function () {
        systemPlugin.execute(successStub,'getTtys', "[]");
    };
    exports.vciFwUpgrade = function () {
        systemPlugin.execute(successStub,'vciFwUpgrade', "[]");
    };
    exports.getVCIInfo = function () {
        systemPlugin.execute(successStub,'getVCIInfo', "[]");
    };
    exports.getAdasActivationStatus = function () {
        systemPlugin.execute(successStub,'getAdasActivationStatus', "[]");
    };
    exports.activateAdas = function (obj) {
        systemPlugin.execute(successStub, 'activateAdas', JSON.stringify([obj]));
    };
    exports.getExpertLoginType = function (obj) {
        systemPlugin.execute(successStub,'getExpertLoginType', JSON.stringify([obj]));
    };
    exports.isActivateThird = function (callback) {
        systemPlugin.execute(callback, 'isActivateThird', JSON.stringify([]));
    };
    exports.activateThird = function (obj) {
        systemPlugin.execute(successStub,'activateThird', JSON.stringify([obj]));
    };
    exports.clearActive = function (callback) {
        systemPlugin.execute(callback,'clearActive', "[]");
    };
    exports.flowMonitoring = function (obj) {
        systemPlugin.execute(successStub,'flowMonitoring', JSON.stringify([obj]));
    };
    exports.stopSelfTest = function () {
        systemPlugin.execute(successStub,'stopSelfTest', "[]");
    };
    exports.getApplist = function (callback) {
        systemPlugin.execute(callback,'getApplist', "[]");
    };
    exports.openEndoscopeAndImageBox = function () {
        systemPlugin.execute(successStub, 'openEndoscopeAndImageBox', "[]");
    };
    exports.ocrCarNumber = function (callback, profile) { // 车牌号
        systemPlugin.execute(successStub,'ocrCarNumber', "[]");
    };
    exports.bindSerialNo = function (str) {
        systemPlugin.execute(successStub,'bindSerialNo', JSON.stringify([str]));
    };
    exports.channelProtocol = function () { // 获取网络连接方式判断
        systemPlugin.execute(successStub,  'channelProtocol', "[]");
    };
    exports.saveAutoScanReport = function (obj) { // 新诊断报告保存
        systemPlugin.execute(successStub,  'saveAutoScanReport', JSON.stringify([obj]));
    };

    exports.vciConnect = function (obj) { // 获取网络连接方式判断
        systemPlugin.execute(successStub,  'vciConnect', "[]");
    };
    // 获取网卡列表 异步监听 
    // 1code： GET_NETWORK_LIST ，data： 为{"name":"网卡1","IP":"127.0.0.3"}的list  
    // 2.用户做出选择后 你需要调用setApplicationProfile 来保存配置信息
    // 3.读取配置信息，来获取上一次的选择（就是userprofile 里面的networkip字段）
    exports.getNetworkList  = function () {
        systemPlugin.execute(successStub,'getNetworkList', '[]');
    };
    // app 通知 系统升级
    exports.showSystemUpgrade  = function () {
        systemPlugin.execute(successStub,'showSystemUpgrade', '[]');
    };

    // newReport 新诊断报告更新数据
    exports.updateDiagReportEx  = function (obj) {
        systemPlugin.execute(successStub,'updateDiagReportEx', JSON.stringify([obj]));
    };
    
    // 结束诊断包运行, 目前只在PC端上使用
    exports.endDiagnosis = function (callback) {
        systemPlugin.execute(callback,  'endDiagnosis', '[]');
    };

    // 
    exports.goDataStreamPlay  = function (index) {
        systemPlugin.execute(successStub,'goDataStreamPlay', JSON.stringify([index]));
    };
    
    exports.startDataStreamExport  = function (str) {
        systemPlugin.execute(successStub,'startDataStreamExport', JSON.stringify([str]));
    };

    exports.stopDataStreamExport  = function () {
        systemPlugin.execute(successStub,'stopDataStreamExport', '[]');
    };

    exports.feedback = function () { // 反馈网络连接判断
        systemPlugin.execute(successStub,'feedback', "[]");
    };

    exports.appendBPICUrl = function (obj) { // 接线图地址
        systemPlugin.execute(successStub,'appendBPICUrl', JSON.stringify([obj]));
    };

    exports.outLogin = function () { //五菱退出登录
        systemPlugin.execute(successStub,  'outLogin', "[]");
    };

    exports.runDiagnosticPackageTP = function (appid, vin, mode, vehicleInfo, vehSysId) {
        var ps = [appid, vin, mode, vehicleInfo, vehSysId];
        systemPlugin.execute(successStub,  'runDiagnosticPackageTP', JSON.stringify(ps));
    };
    
    exports.sendDiagReportToGQFT = function (str) {
        systemPlugin.execute(successStub,'sendDiagReportToGQFT', JSON.stringify([str]));
    };

    exports.link = function (obj) { // 通知App VCI 连接确认 目前传 Bluetooth：1
        systemPlugin.execute(successStub,'link', JSON.stringify([obj]));
    };

    exports.generateReport = function (obj) {
        // 告知APP诊断报告生成的初始数据
        systemPlugin.execute(successStub,'generateReport', JSON.stringify([obj]));
    };

    exports.dataReturn = function (obj) { // Can 数据采集文件列表 历史记录
        systemPlugin.execute(successStub,'dataReturn', JSON.stringify([obj]));
    };
    exports.DataCollection = function (obj) { // Can 数据采集 确认采集
        systemPlugin.execute(successStub,'DataCollection', JSON.stringify([obj]));
    };
    exports.dataReturn = function (obj) { // Can 数据采集文件列表 历史记录
        systemPlugin.execute(successStub,'dataReturn', JSON.stringify([obj]));
    };
    exports.DataStop = function (obj) { // Can 卡数据收集 停止
        systemPlugin.execute(successStub,'DataStop', JSON.stringify([obj]));
    };
    exports.checkUpdateVersionInfo = function (obj) { //检查APP是否有版本更新
        systemPlugin.execute(successStub,'checkUpdateVersionInfo', JSON.stringify([obj]));
    };
    exports.DynamicAnalysis = function (obj) { // 新能源 动态分析
        systemPlugin.execute(successStub,'DynamicAnalysis', JSON.stringify([obj]));
    };
    exports.RepairList = function (obj) { //打开维修资料
        systemPlugin.execute(successStub,'RepairList', JSON.stringify([obj]));
    };
    exports.RepairChildTable = function (obj) { //维修资料二级列表
        systemPlugin.execute(successStub,'RepairChildTable', JSON.stringify([obj]));
    };
    exports.RepairDownload  = function (obj) { // 下载或打开PDF
        systemPlugin.execute(successStub,'RepairDownload', JSON.stringify([obj]));
    };
    exports.loginDownload  = function (obj) { // 高级账号登录
        systemPlugin.execute(successStub,'loginDownload', JSON.stringify([obj]));
    };
    exports.quitApp  = function () {// 退出APP
        systemPlugin.execute(successStub,'quitApp', JSON.stringify([]));
    };
    exports.runDiagnosticLinkPackageE2 = function (appid,chilredid,mode,vehicle, params) { // link包新增vehicle字段传给app
        var arr = [appid,chilredid,mode, vehicle];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                arr.push(params[i]);
            }
        }
        systemPlugin.execute(successStub,  'runDiagnosticLinkPackageE2', JSON.stringify(arr));
    };
    exports.getCarouselImgs = function() {
        systemPlugin.execute(successStub,  'getCarouselImgs', JSON.stringify([]));
    }
    exports.stopDataCollection = function () { // 通知App VCI 连接确认 目前传 Bluetooth：1
        systemPlugin.execute(successStub,'StopDataCollection', '[]');
    };

    // 选择本地图片文件 同步
    exports.selectLocalFile = function (callback) {
        systemPlugin.execute(callback, 'selectLocalFile', JSON.stringify([]));
    };

    // 反馈功能 同步
    exports.feedbackUserProblem = function (callback, obj) {
        systemPlugin.execute(callback, 'feedbackUserProblem', JSON.stringify([obj]));
    };

    // 消息中心列表 同步
    exports.getReceiverMessageListPaged = function (callback, obj) {
        systemPlugin.execute(callback, 'getReceiverMessageListPaged', JSON.stringify([obj]));
    };

    // 消息详情 同步
    exports.readMessage = function (callback, obj) {
        systemPlugin.execute(callback, 'readMessage', JSON.stringify([obj]));
    };
    

    // 消息详情 同步
    exports.notReceiveMessage = function (callback) {
        systemPlugin.execute(callback, 'notReceiveMessage', JSON.stringify([]));
    };

    exports.receiveMessage = function (callback, obj) {
        systemPlugin.execute(callback, 'receiveMessage', JSON.stringify([obj]));
    };


    // 获取消息中心未读信息数量 同步
    exports.getNotReadMessage = function (callback) {
        systemPlugin.execute(callback, 'getNotReadMessage', JSON.stringify([]));
    };

    exports.changePwd = function (callback,obj) {
        systemPlugin.execute(callback, 'changePwd', JSON.stringify([obj]));
    };
    


    

    /***************************************************大众vw新架构**********************************************/ 
    
    // 获取基本信息 同步
    exports.getBaseConfigDic = function (callback) {
      systemPlugin.execute(callback, 'getBaseConfigDic', JSON.stringify([]));
    };
    // 元素触发事件 异步
    exports.diagnosticInput = function (obj) {
        systemPlugin.execute(successStub,  'diagnosticInput', JSON.stringify(obj));
    };

    // vw临时运行诊断程序 异步
    exports.runDiagnosticPackageEx_Temp = function (obj) {
        systemPlugin.execute(successStub,  'runDiagnosticPackageEx_Temp', JSON.stringify(obj));
    };
    
    // 重启app
    exports.restartApp  = function () {
        systemPlugin.execute(successStub, 'restartApp', '[]');
    };


}
