
// ---入口文件原生写法： 为兼容支持安卓5.0，不支持ES6新特性---
;(function(){
  // 动态加载cordova
  function loadCordova(url) {
    return new Promise(function(resolve, reject){
      // 检查是否已经加载了cordova.js, 为减少querySelector性能损耗，可免检
      // if (document.querySelector(`script[src="${url}"]`)) {
      //     console.warn("Cordova.js is already loaded.");
      //     resolve(true);
      //     return;
      // }
      var script = document.createElement("script");
      script.type = "text/javascript";
      script.src = url;

      script.onload = function() {
          resolve(true);
      };
      script.onerror = function() {
          reject(new Error("Failed to load script " + url));
      };

      document.getElementsByTagName("head")[0].appendChild(script);
  });
  }

  // 动态引入pc端loading
  function startLoading(type) {
    if(navigator.userAgent.indexOf("Windows") === -1) return;
    var loadingDom = document.createElement("div");
    // 0: PC端加载动画, 1: ECUFlash加载动画
    var loadingList = ['<div class="jiazai_div"><i></i><i></i><i></i><i></i><i></i></div>', '<div class="ecu_div"><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i><i></i></div>']
    var praviteDom = !type ? loadingList[0] : loadingList[1];
    loadingDom.id = "loading_bg";
    loadingDom.className = "loading_bg";
    loadingDom.innerHTML = praviteDom
    document.body.appendChild(loadingDom);
  }

  function setRemUnit () {
    var docEl = document.documentElement
    var rem = 102.4;
    docEl.style.fontSize = rem + "px"
  }

  window.startLoading = startLoading;
  window.loadCordova = loadCordova;
  window.setRemUnit = setRemUnit;

})();