cordova.define("com.diagnosis.DiagnosticApplicationPlugin", function (require, exports, module) {
    var exec = require('cordova/exec');

    var globalEventHandlers = []; //{name:string,callback:function}
    /**
        success callback wraps event framework.
        @args json string which is a javascript event object.
    */
    function successWrapper(args) {
        if (globalEventHandlers && globalEventHandlers.length > 0) {
            var event;
            if(typeof(args) !== 'object') {
                event = JSON.parse(args);
            }
            for (var i = 0; i < globalEventHandlers.length; i++) {
                try {
                    if (globalEventHandlers[i] != null && globalEventHandlers[i].callback != null) {
                        globalEventHandlers[i].callback(event);
                    }
                } catch (e) {
                    console.log(e)
                    // alert(e); // production environment remove this.
                }
            }
        }
    }

    function errorWrapper(args) {
        // alert("error:" + args);
    }
    /**
        callback placeholder,do nothing.
    */
    function successStub() { }

    function errorStub() { }
    /**
        add a global callback.
    */
    exports.addEventHandler = function (name, eventHandler) {

        if (eventHandler && name && name != "") {

            if (globalEventHandlers == null || globalEventHandlers.length == 0) { //first time.
                //globalEventHandler=eventHandler;
                exec(successWrapper, errorWrapper, 'DiagnosticApplicationPlugin', 'initJavascriptContext', []); //just call once.
            } //else{//change.
            //globalEventHandler=eventHandler;
            //}
            var exists = false;
            for (var i = 0; i < globalEventHandlers.length; i++) {
                if (globalEventHandlers[i].name == name) {
                    globalEventHandlers[i].callback = eventHandler;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                globalEventHandlers.push({
                    name: name,
                    callback: eventHandler
                });
            }

            return true;
        }
        return false;
    };
    /**
     *  remove a global callback.
     */
    exports.removeEventHandler = function (name) {

        if (globalEventHandlers != null && globalEventHandlers.length > 0) {
            for (var i = 0; i < globalEventHandlers.length; i++) {
                if (globalEventHandlers[i].name == name) {
                    globalEventHandlers[i].callback = null;
                    break;
                }
            }
        }
    };
    exports.coolMethod = function (arg0, success, error) { //a test method.

        exec(success, error, 'DiagnosticApplicationPlugin', 'coolMethod', [arg0]);
    };
    //enter main ui package.
    exports.enterMainApplication = function () {

        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'enterMainApplication', []);
    };
    /**
        check & install all of local diagnosis package.
        @return progress will received in global event handler.
    */
    exports.installLocalPackage = function () {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'installLocalPackage', []);
    };
    exports.prepareLocalUIPackage = function () {

        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'prepareLocalUIPackage', []);
    };
    /*
        uninstall diagnosis package which has been installed.
        @packageId id of package which identify a package.
        @return notification will be sent as a event which processed by global event handler.
    */
    exports.uninstallPackage = function (packageId) {

        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'uninstallPackage', [packageId]);
    };
    /*
        install diagnosis packages which have been downloaded.
        @param files a collection of package file.
        @return notification will be sent as a event which processed by global event handler.
    */
    exports.installPackages = function (files) {

        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'installPackages', files);
    };
    /*
        download and install diagnosis packages which are newest.
        @return notification will be sent as a event which processed by global event handler.
     */
    exports.downloadAndInstallAllPackages = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadAndInstallAllPackages', []);
    };
    /*
        download and install diagnosis packages which are newest.
        @return notification will be sent as a event which processed by global event handler.
     */
    exports.downloadAndInstallPackage = function (id) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadAndInstallPackage', [id]);
    };
    exports.downloadCancel = function (id, callback) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadCancel', [id]);
    };
    /**
        check if local ui package is exists.
        @param callback callback accepts one string parameter,ui package path or empty.
        @note if callback passed empty parameter,should call downloadAndInstallUI,otherwise
                call enterMainApplication to enter application leave current page.
    */
    exports.checkUIPackage = function (callback) {

        exec(callback, callback, 'DiagnosticApplicationPlugin', 'checkUIPackage', []);
    };
    /**
        download remote ui package and install it associates to device model.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.downloadAndInstallUI = function () {

        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadAndInstallUI', []);
    };
    /**
        check the device or app whether has been activated.
        @param callback get result immediately by call this method.
    */
    exports.checkActivated = function (callback) {

        exec(callback, callback, 'DiagnosticApplicationPlugin', 'checkActivated', []);
    };
    /**
        login cloud platform.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.login = function (obj) {
        //五菱的登录方法需要添加参数，原
        var loginInfo = null
        if(obj){
            loginInfo = [obj]
        }else{
            loginInfo = []
        }
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'login', loginInfo);
    };
    /**
        check remote diagnosis packages.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.checkDiagnosticPackage = function (packageId) {

        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'checkDiagnosticPackage', [packageId]);
    };
    /**
        login cloud platform.
        @return notifications will be sent as events which processed by global event handler.
    */
    exports.getApplicationProfile = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getApplicationProfile', []);
    };
    /**
        set application profile(user profile only).
        @return notifications will be sent by callback,1:success,0:failed.
    */
    exports.setApplicationProfile = function (callback, profile) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'setApplicationProfile', [profile]);
    };

    exports.getLocalPackages = function () {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'getLocalPackages', []);
    };
    /**
       run diagnostic application.
       @return notifications will be sent as events which processed by global event handler.
    */
    exports.runDiagnosticPackage = function (appid) {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'runDiagnosticPackage', [appid]);
    };
    /**
    back in current running diagnostic application.
    @return notifications will be sent as events which processed by global event handler.
    */
    exports.diagnosticBack = function () {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticBack', []);
    };
    exports.diagnosticSelect = function (obj) { //{key,int[] params}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticSelect', [obj]);
    };
    exports.diagnosticInput = function (obj) { //{key,string[] params}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticInput', [obj]);
    };
    exports.diagnosticSelectList = function (obj) { //{int key,int selectedCount,int[] items}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticSelectList', [obj]);
    };
    exports.forceStop = function () {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'forceStop', []);
    };
    exports.downloadAndInstallApp = function (url) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadAndInstallApp', [url]);
    };
    exports.getBoundBluetooth = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getBoundBluetooth', []);
    };
    exports.getBoundBluetoothAsyn = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getBoundBluetoothAsyn', []);
    }; //sendData
    exports.sendData = function (data) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'sendData', [data]);
    };
    exports.commonPost = function (data) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'commonPost', [data]);
    };
    exports.commonPostSync = function (callback, data) {
        exec(callback, errorStub, 'DiagnosticApplicationPlugin', 'commonPost', [data]);
    };
    exports.getEcuDataLocalBackups = function (data) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getEcuDataLocalBackups', [data]);
    };
    exports.UpdataEcuDataLocalFile = function (data) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'UpdataEcuDataLocalFile', [data]);
    };
    exports.delEcuDataLocalBackups = function (callback, data) {
        exec(callback, errorStub, 'DiagnosticApplicationPlugin', 'delEcuDataLocalBackups', [data]);
    };

    exports.getReportsStatisticalInfo = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getReportsStatisticalInfo', []);
    };
    exports.uploadDiagReports = function (callback, reportId) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'uploadDiagReports', [reportId]);
    };
    
    exports.getDiagReports = function (cond, pageIndex, pageSize) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getDiagReports', [cond, pageIndex, pageSize]);
    };
    exports.getDiagReportDetail = function (reportId) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getDiagReportDetail', [reportId]);
    };
    exports.removeDiagReport = function (callback, reportId) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'removeDiagReport', [reportId]);
    };
    exports.getDiagPath = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getDiagPath', []);
    };
    exports.openWifiSystem = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openWifiSystem', []);
    };
    exports.connectWifi = function (ssid, pwd) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'connectWifi', [ssid, pwd]);
    };
    exports.closeWifiSystem = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'closeWifiSystem', []);
    };
    exports.setWifiState = function (enable) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'setWifiState', [(enable ? "1" : "0")]);
    };
    exports.openMediaSystem = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openMediaSystem', []);
    };
    exports.closeMediaSystem = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'closeMediaSystem', []);
    };
    exports.openAlbum = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openAlbum', []);
    };
    exports.capturePhoto = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'capturePhoto', []);
    };
    exports.startScanVin = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startScanVin', []);
    };
    exports.stopScanVin = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'stopScanVin', []);
    };
    exports.scanBarcode = function (width, height) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'scanBarcode', [width, height]);
    };
    exports.launchMainActivity = function (callback, packageName) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'launchMainActivity', [packageName]);
    };
    exports.getUserMaintainStorages = function (callback, repositories) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getUserMaintainStorages', repositories);
    };
    exports.addStorageNode = function (path, isFile) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'addStorageNode', [path, isFile]);
    };
    exports.removeStorageNode = function (callback, path) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'removeStorageNode', [path]);
    };
    exports.copyStorageNode = function (pathFrom, pathTo) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'copyStorageNode', [pathFrom, pathTo]);
    };
    exports.listStorageNodes = function (path, showHidden) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'listStorageNodes', [path, showHidden]);
    };
    exports.startDataStreamRecord = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startDataStreamRecord', []);
    };
    exports.stopDataStreamRecord = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopDataStreamRecord', []);
    };
    exports.startDataStreamPlay = function (path) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startDataStreamPlay', [path]);
    };
    exports.stopDataStreamPlay = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopDataStreamPlay', []);
    };
    exports.pauseDataStreamPlay = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'pauseDataStreamPlay', []);
    };
    exports.resumeDataStreamPlay = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'resumeDataStreamPlay', []);
    };
    exports.findVehicleByVin = function (callback, vin) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'findVehicleByVin', [vin]);
    };

    // runDiagnosticLinkPackageEX
    exports.runDiagnosticLinkPackageEX = function (appid, chilredid, mode, params) {
        var ps = [appid, chilredid, mode];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                ps.push(params[i]);
            }
        }
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'runDiagnosticLinkPackageEX', ps);
    };

    exports.runDiagnosticPackageEx = function (appid, mode, params) {
        var ps = [appid, mode];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                ps.push(params[i]);
            }
        }
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'runDiagnosticPackageEx', ps);
    };
    exports.printPdf = function (path, pages, printImg) {
        if (printImg == null) {
            printImg = true
        }
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'printPdf', [path, pages, printImg]);
    };
    exports.sendEmail = function (subject, to, content, attachFiles) {
        var ps = [subject, to, content];
        if (attachFiles) {
            for (var i = 0; i < attachFiles.length; i++) {
                ps.push(attachFiles[i]);
            }
        }
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'sendEmail', ps);
    };
    exports.download = function (urls) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'download', urls);
    };
    exports.uploadVin = function (vininfo) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'uploadVin', [JSON.stringify(vininfo)]);
    };
    exports.openUrl = function (callback, uri, mimeType) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'openUrl', [uri, mimeType]);
    };
    exports.updateDiagReport = function (data) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'updateDiagReport', [JSON.stringify(data)]);
    };
    exports.getMaintainDoc = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getMaintainDoc', []);
    };
    exports.restAPI = function (url, method, postData) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'restAPI', [url, method, postData]);
    };
    exports.openSystemSettings = function (callback, name) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'openSystemSettings', [name]);
    };
    exports.installMasterApp = function (remoteUrl, nextTime) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'installMasterApp', [remoteUrl, nextTime]);
    };
    exports.startSelfTest = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startSelfTest', []);
    };
    exports.getTryoutTimes = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getTryoutTimes', []);
    };
    exports.installEmbededVinDatabase = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'installEmbededVinDatabase', []);
    };
    exports.diagnosticBackEx = function (ptType) {
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticBackEx', [ptType]);
    };
    exports.diagnosticSelectEx = function (obj) { //{int pt,int key,int[] params}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticSelectEx', [obj]);
    };
    exports.diagnosticInputEx = function (obj) { //{int pt,int key,string[] params}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticInputEx', [obj]);
    };
    exports.diagnosticSelectListEx = function (obj) { //{int pt,int key,int selectedCount,int[] items}
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'diagnosticSelectListEx', [obj]);
    };
    exports.listEcuDataFile = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'listEcuDataFile', [obj]);
    };
    exports.scoreEcuDataFile = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'scoreEcuDataFile', [obj]);
    };
    exports.downloadEcuDataFile = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'downloadEcuDataFile', [obj]);
    };
    exports.enterUpgradeListView = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'enterUpgradeListView', []);
    };
    exports.exitUpgradeListView = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'exitUpgradeListView', []);
    };
    exports.enterEcuFileListView = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'enterEcuFileListView', []);
    };
    exports.exitEcuFileListView = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'exitEcuFileListView', []);
    };
    exports.getVoltage = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getVoltage', []);
    };
    exports.getTtys = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getTtys', []);
    };
    exports.vciFwUpgrade = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'vciFwUpgrade', []);
    };
    exports.getVCIInfo = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getVCIInfo', []);
    };
    exports.getAdasActivationStatus = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getAdasActivationStatus', []);
    };
    exports.activateAdas = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'activateAdas', [obj]);
    };
    exports.getExpertLoginType = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getExpertLoginType', [obj]);
    };
 
    exports.isActivateThird = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'isActivateThird', []);
    };

    exports.activateThird = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'activateThird', [obj]);
    };

    exports.clearActive = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'clearActive', []);
    };

    exports.flowMonitoring = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'flowMonitoring', [obj]);
    };


    exports.stopSelfTest = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopSelfTest', []);
    };
    exports.getApplist = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getApplist', []);
    };
    exports.openEndoscopeAndImageBox = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openEndoscopeAndImageBox', []);
    };
    exports.ocrCarNumber = function (callback, profile) { // 车牌号
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'ocrCarNumber', []);
    };
    exports.bindSerialNo = function (str) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'bindSerialNo', [str]);
    };
    exports.getAreaAllowInfo = function (callback) {    //ECUFlash获取区域限制  flash
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getAreaAllowInfo', []);
    };
    exports.quitApp = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'quitApp', []);
    };
    exports.finishApp = function () { // 退出app
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'finishApp', []);
    };
    exports.isExternalStorageManager = function (callback) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'isExternalStorageManager', []);
    };
    exports.channelProtocol = function () { // 获取网络连接方式判断
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'channelProtocol', []);
    };

    exports.feedback = function (callback) {    //网络连接判断
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'feedback', []);
    };
    exports.appendBPICUrl = function (obj) { // 接线图地址
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'appendBPICUrl', [obj]);
    };
    exports.outLogin = function () {
        //五菱退出登录
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'outLogin', []);
    };
    exports.DataCollection = function (obj) { // can 卡数据收集 下一步
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'DataCollection', [obj]);
    };
    exports.DataStop = function (obj) { // can 卡数据收集 停止
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'DataStop', [obj]);
    };
    exports.dataReturn = function (obj) { // can 卡数据收集 历史
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'dataReturn', [obj]);
    };
    exports.link = function (obj) { // 串口/VCI 连接
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'link', [obj]);
    }
    exports.generateReport = function (callback, obj) {
         // 告知APP诊断报告生成的初始数据
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'generateReport', [obj]);
    };
    exports.DynamicAnalysis = function (obj) { // 动态分析 id 1开始 0结束
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'DynamicAnalysis', [obj]);
    };
    exports.updateDiagReportEx = function (obj) { // newReport 新诊断报告更新数据
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'updateDiagReportEx', [obj]);
    };
    exports.genTDSP10Cert = function (obj) { // 生成临时证书
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'genTDSP10Cert', []);
    };
    exports.importTDSP7bCert = function (obj) { // TDS860 验证证书的有效性
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'importTDSP7bCert', []);
    };
    exports.startDataStreamExport = function (str) {// 数据流CSV导出
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startDataStreamExport', [str]);
    };
    exports.stopDataStreamExport = function () {  //结束数据流CSV导出
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopDataStreamExport', []);
    };
    exports.listmaintainGuid = function (obj) { // WULING维修资料
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'listmaintainGuid', [obj]);
    };
    exports.checkUpdateVersionInfo = function () {  //检查APP是否有版本更新
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'checkUpdateVersionInfo', []);
    };
    exports.appDebug = function (obj) { //APP调试使用
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'appDebug', [obj]);
    };
    exports.RepairList = function () { //打开维修资料
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'RepairList', []);
    };
    exports.RepairChildTable = function (obj) { //维修资料二级列表
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'RepairChildTable', [obj]);
    };
    exports.RepairDownload  = function (obj) { // 下载或打开PDF
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'RepairDownload', [obj]);
    };
    exports.loginDownload  = function (obj) { // 高级账号登录
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'loginDownload', [obj]);
    };
    exports.listmaintainGuid = function (obj) { // WULING维修资料
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'listmaintainGuid', [obj]);
    };
    exports.ConfigurationTable = function (obj) { // APP 拉取后台EV 诊断列表
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'ConfigurationTable', []);
    };
    exports.ErrorCode = function (obj) { // APP 拉取后台EV 诊断列表
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'ErrorCode', [obj]);
    };
    exports.shareFileToWechat  = function (filePath) { // 调用系统文件分享
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'shareFileToWechat', [filePath]);
    };
    exports.selectFeedBackImg  = function (obj) { // 反馈入口图片上传
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'selectFeedBackImg', [obj]);
    };
    exports.commitFeedBackInfo  = function (obj) { // 反馈信息统一上传
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'commitFeedBackInfo', [obj]);
    };
	exports.runDiagnosticLinkPackageE2  = function (appid, chilredid, mode, vehicle, params) { // 新增电池包检测通知APP 新增 vehicle 字段
        var arr = [appid, chilredid, mode, vehicle];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                arr.push(params[i]);
            }
        }
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'runDiagnosticLinkPackageE2', arr);
    };
    exports.WifiList  = function () { // E2 Pro wifi list
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'WifiList', []);
    };
    //将诊路径传给APP, APP会在数据流里面显示
    exports.addMenuPath = function (obj) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'addMenuPath', [obj]);
    };
    exports.getCSVDataList = function () {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getCSVDataList', []);
    };
    exports.enterCsvPage = function (filePath) {
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'enterCsvPage', [filePath]);
    };
    exports.deleteCsvFilePaths = function (callback, obj) {
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'deleteCsvFilePaths', [obj]); 
    };
    exports.startUrlDownload = function () { // 跃武那边做隐藏文件下载
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startUrlDownload', []);
    };
    exports.runDiagnosticPackageTP = function (appid, vin, mode, vehicleInfo, vehSysId) {
        var ps = [appid, vin, mode, vehicleInfo, vehSysId];
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'runDiagnosticPackageTP', ps);
    };
    exports.getAutoScanReportDetail = function () { // 主动触发诊断报告生成
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getAutoScanReportDetail', []);
    };
    exports.saveAutoScanReport = function (obj) { // 新诊断报告保存
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'saveAutoScanReport', [obj]);
    };
    exports.topologyFaultCode = function (obj) { // 获取故障码信息
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'topologyFaultCode', [obj]);
    };
    exports.vciConnect = function () { // VCI连接异常主动重连
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'vciConnect', []);
    };
    exports.stopService = function () { // VCI连接异常退出 app 那边收到后会主动发PT_END消息
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopService', []);
    };
    exports.showSystemUpgrade = function () { // app 通知 系统升级
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'showSystemUpgrade', []);
    };
    exports.iosShowLoad = function () { // 告知IOS显示LAOD了, 监听IOS_LOAD_END消息去除LAOD
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'iosShowLoad', []);
    };
    exports.openApp = function (str) { // 打开系统应用   text == SystemSettings 打开系统设置页面
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openApp', [str]);
    };
    exports.requestLingPaoCertificate = function(callback) {  //TDS810判断是否有新的授权文件
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'requestLingPaoCertificate', []);
    }
    exports.oemXLogin = function (callback, arr) { // TDS860登录功能
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'oemXLogin', arr);
    }; 
    exports.runDiagnosticPackageExGateway  = function (appid, mode, gateWayStatus, params, chilredid) { // 网关模拟 网关状态 gatewaySimulationStatus
        var arr = [appid, chilredid, mode, gateWayStatus];
        if (params) {
            for (var i = 0; i < params.length; i++) {
                arr.push(params[i]);
            }
        }
        exec(successStub, successStub, 'DiagnosticApplicationPlugin', 'runDiagnosticPackageExGateway', arr);
    };
    exports.clearLingPaoCertificate = function (callback) { // 清除TDS810证书
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'clearLingPaoCertificate', []);
    };
    exports.oemXLogout = function (callback) {   // TDS860退出登录功能
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'oemXLogout', []);
    };
    exports.refreshSubscriptionService = function () { // 刷新订阅服务数据
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'refreshSubscriptionService', []);
    };
    exports.activateSubscriptionService = function  (callback, str) {   //订阅服务点卡激活
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'activateSubscriptionService', [str]);
    };
    exports.openWechatMiniProgram = function (str) {   // 跳转微信小程序
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'openWechatMiniProgram', [str]);
    };
    exports.permissionStatement = function () {   // 判断Anyscan权限是否已经获取
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'permissionStatement', []);
    };
    exports.getPermissionsSet = function () {   // Anyscan进入设置页面获取权限
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'getPermissionsSet', []);
    };
    exports.sendPhoneVerifyCode = function (obj) {   // 获取验证码
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'sendPhoneVerifyCode', [obj]);
    };
    exports.domesticVerifyActivation = function (obj) {   // Anyscan 激活
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'domesticVerifyActivation', [obj]);
    };
    exports.getIsBluePermission = function (callback) {   // Anyscan 激活
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getIsBluePermission', []);
    };
    exports.getThirdPartyAccounts = function (callback) {  // 获取71自定义登录消息的第三方账号列表
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getThirdPartyAccounts', []);
    };
    exports.removeThirdPartyAccount = function (callback, id) {  // 删除自定义登录消息的账号
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'removeThirdPartyAccount', [id]);
    };
    exports.getCaptchaCode = function (callback, obj) {  // 删除自定义登录消息的账号
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'getCaptchaCode', [obj]);
    };
    exports.validateCaptcha = function (callback, obj) {  // 删除自定义登录消息的账号
        exec(callback, callback, 'DiagnosticApplicationPlugin', 'validateCaptcha', [obj]);
    };
    exports.enableBluetooth = function () {   // 打开系统蓝牙
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'enableBluetooth', []);
    };
    exports.startScanBluetoothDevices = function (arr) {   // 开始扫描蓝牙设备
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'startScanBluetoothDevices', [arr]);
    };
    exports.bindBluetoothDevice = function (mac) {   // 连接该蓝牙设备
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'bindBluetoothDevice', [mac]);
    };
    exports.stopScanBluetoothDevices = function () {   // 结束蓝牙设备扫描
        exec(successStub, errorStub, 'DiagnosticApplicationPlugin', 'stopScanBluetoothDevices', []);
    };
});