precision mediump float; //指定默认精度

varying vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform sampler2D inputImageTexture1;
uniform sampler2D inputImageTexture2;
uniform int blendType1;
uniform int blendType2;

vec4 blendDivide(vec4 base, vec4 blend){
    return vec4(blend.r > 0.0 ? min(base.r / blend.r, 1.0) : 1.0,
                blend.g > 0.0 ? min(base.g / blend.g, 1.0) : 1.0,
                blend.b > 0.0 ? min(base.b / blend.b, 1.0) : 1.0,
                1.0);
}

vec4 blendColorDodge(vec4 base, vec4 blend){
    return vec4((blend.r == 1.0) ? blend.r : min(base.r / (1.0 - blend.r), 1.0),
                (blend.g == 1.0) ? blend.g : min(base.g / (1.0 - blend.g), 1.0),
                (blend.b == 1.0) ? blend.b : min(base.b / (1.0 - blend.b), 1.0),
                1.0);
}

vec4 blendScreen(vec4 base, vec4 blend){
    return vec4(1.0) - ((vec4(1.0) - base) * (vec4(1.0) - blend));
}

vec4 blendOverlay(vec4 base, vec4 blend){
    return vec4(base.r < 0.5 ? (2.0 * base.r * blend.r) : (1.0 - 2.0 * (1.0 - base.r) * (1.0 - blend.r)),
                base.g < 0.5 ? (2.0 * base.g * blend.g) : (1.0 - 2.0 * (1.0 - base.g) * (1.0 - blend.g)),
                base.b < 0.5 ? (2.0 * base.b * blend.b) : (1.0 - 2.0 * (1.0 - base.b) * (1.0 - blend.b)),
                1.0);
}

vec4 blendLighten(vec4 base, vec4 blend){
    return max(base, blend);
}

vec4 blendSoftLight(vec4 base, vec4 blend){
    return vec4((blend.r < 0.5) ? (2.0 * base.r * blend.r + base.r * base.r * (1.0 - 2.0 * blend.r)) : (sqrt(base.r) * (2.0 * blend.r - 1.0) + 2.0 * base.r * (1.0 - blend.r)),
                (blend.g < 0.5) ? (2.0 * base.g * blend.g + base.g * base.g * (1.0 - 2.0 * blend.g)) : (sqrt(base.g) * (2.0 * blend.g - 1.0) + 2.0 * base.g * (1.0 - blend.g)),
                (blend.b < 0.5) ? (2.0 * base.b * blend.b + base.b * base.b * (1.0 - 2.0 * blend.b)) : (sqrt(base.b) * (2.0 * blend.b - 1.0) + 2.0 * base.b * (1.0 - blend.b)),
                1.0);
}

vec4 chooseBlend(int blendType, vec4 color1, vec4 color2){
    vec4 blendedColor = color2;
    if(blendType == 1){
        // 正常
    } else if(blendType == 2){
        blendedColor = blendDivide(color1, color2); //划分
    } else if( blendType == 3){
        blendedColor = color1 * color2; //正片叠底glblend
    } else if(blendType == 4){  // 颜色减淡
        blendedColor =  blendColorDodge(color1, color2);
    } else if(blendType == 5){
        blendedColor =  blendScreen(color1, color2); //滤色glblend
    } else if(blendType == 6){
        blendedColor =  blendOverlay(color1, color2); //叠加
    } else if(blendType == 7){
        blendedColor =  blendLighten(color1, color2); //变亮
    } else if(blendType == 8){
        blendedColor =  blendSoftLight(color1, color2); //柔光
    }
    vec4 ret =  vec4(mix(color1,blendedColor,color2.a).rgb, 1.0);
    return ret;
}

void main() {
    vec4 color = texture2D(inputImageTexture, textureCoordinate);
    vec2 uv = textureCoordinate;
    uv.y = 1. - uv.y;
    vec4 ret01, ret02;
    if(blendType1 > 0){
        vec4 color1 = texture2D(inputImageTexture1, uv);
        if(color1.a > 0.0){
            color1 = vec4(min(color1.rgb / color1.a, vec3(1.0)), color1.a);
        }
        ret01 = chooseBlend(blendType1, color, color1);
    } else {
        ret01 = color;
    }
    if(blendType2 > 0){
        vec4 color2 = texture2D(inputImageTexture2, uv);
        if(color2.a > 0.0){
            color2 = vec4(min(color2.rgb / color2.a, vec3(1.0)), color2.a);
        }
        ret02 = chooseBlend(blendType2, ret01, color2);
    } else {
        ret02 = ret01;
    }

    gl_FragColor = ret02;
}