;
if (!Object.keys) {
    Object.keys = (function() {
        var hasOwnProperty = Object.prototype.hasOwnProperty,
            hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString'),
            dontEnums = [
                'toString',
                'toLocaleString',
                'valueOf',
                'hasOwnProperty',
                'isPrototypeOf',
                'propertyIsEnumerable',
                'constructor'
            ],
            dontEnumsLength = dontEnums.length;

        return function(obj) {
            if (typeof obj !== 'object' && typeof obj !== 'function' || obj === null) throw new TypeError('Object.keys called on non-object');

            var result = [];

            for (var prop in obj) {
                if (hasOwnProperty.call(obj, prop)) {
                    result.push(prop);
                }
            }

            if (hasDontEnumBug) {
                for (var i = 0; i < dontEnumsLength; i++) {
                    if (hasOwnProperty.call(obj, dontEnums[i])) {
                        result.push(dontEnums[i]);
                    }
                }
            }
            return result;
        }
    })()
};

(function() {

    if(window.MyclassJSBridge!=undefined){
        return;
    }

    if (typeof define === 'function' && (define.amd || define.cmd)) {
        if (define.amd) {
            define(function() {
                return jMyclass;
            });
        } else if (define.cmd) {
            define(function(require, exports, module) {
                module.exports = jMyclass;
            });
        }
    }
    var configReady = -1;

    var debug = false;

    var supportApiList = new Array("authorise", "setNavigationBarTitle", "hideUrlTip", "showOptionMenuButton",
     "hideOptionMenuButton", "hideMenuItems", "showMenuItems", "hideAllNonBaseMenuItem", "showAllNonBaseMenuItem",
     "showToast", "hideToast", "closePage", "refresh", "navigateTo", "navigateBack", "redirectTo", "showActionSheet",
     "showDatePicker", "showCustomPicker", "showCheckBox", "updateAppShareData", "chooseImage", "previewImage",
     "uploadImage", "uploadImages", "downloadImage", "chooseVideo", "playVideo", "uploadVideo", "downloadVideo",
     "chooseVoice", "playVoice", "uploadVoice", "downloadVoice", "getLocation", "getNetworkType","showDialog",
     "previewFile","showCustomRightBarItem","showPopMenu","showInput","chooseContact","setNavigationType",
     "showScan","payOrder");

    function contains(arr, obj) {
        var i = arr.length;
        while (i--) {
            if (arr[i] === obj) {
                return true;
            }
        }
        return false;
    }

    function invoke(action, args) {
        if (configReady !== 1 && action !== 'js_config') {
            return;
        }

        if (debug) {
            var actionStrArr = action.split('_');
            var logStr = 'jsApi:' + actionStrArr[1] + '\nargs:' + JSON.stringify(args);
            alert(logStr);
            console.log(logStr);
        }

        var isiOS = false;
        if (/(iPhone|iPad|iPod|iOS)/i.test(navigator.userAgent)) {
            isiOS = true;
        } else if (/(Android)/i.test(navigator.userAgent)) {
            isiOS = false;
        }

        if (args !== undefined) {
            var timestamp = (new Date().getTime()) + '_' + Math.floor(Math.random() * 1000);
            var callbackId = timestamp + '_' + action;
            args.method = 'MyclassJSBridge.callback';
            args.callbackId = callbackId;

            Object.keys(args).forEach(function(key) {
                if (args[key] && typeof(args[key]) == 'function') {
                    if (key == 'success' || key == 'fail' || key == 'complete' || key == 'cancel') {
                        MyclassJSBridge[callbackId + '_' + key] = args[key];
                    }

                    delete args[key];
                }
            });

            if (!args.appId) {
                args.appId = window.appId;
            }
        } else {
            args = { appId: window.appId };
        }

        if (action !== 'js_checkJsApi') {
            if (isiOS) {
                if (args !== undefined) {
                    return window.webkit.messageHandlers[action].postMessage(args);
                } else {
                    return window.webkit.messageHandlers[action].postMessage('');
                }
            } else {
                if (args !== undefined) {
                    if (typeof args === 'object') {
                        try {
                            args = JSON.stringify(args);
                        } catch (e) {

                        }
                    }
                    return window.PageAction[action](args);
                } else {
                    return window.PageAction[action]();
                }
            }
        }
    }

    var MyclassJSBridge = {
        callback: function(args) {
            if (typeof args === 'string') {
                args = JSON.parse(args);
            }

            var callbackId = args.callbackId;
            if (!callbackId) {
                return false;
            }
            var callbackName = args.callbackName;
            if (!callbackName) {
                return false;
            }

            delete args.callbackId;
            delete args.callbackName;

            var callbackStrArr = callbackId.split('_');
            if (callbackName === 'success') {
                args.errMsg = callbackStrArr[3] + ':ok';
            } else if (callbackName === 'cancel') {
                args.errMsg = callbackStrArr[3] + ':cancel';
            }

            if (debug) {
                var logStr = callbackStrArr[3] + '.' + callbackName + ':' + JSON.stringify(args);
                alert(logStr);
                console.log(logStr);
            }

            var completeCallbackId = callbackId + '_complete';
            MyclassJSBridge[completeCallbackId] && MyclassJSBridge[completeCallbackId](args || {});

            var otherCallbackId = callbackId + '_' + callbackName;
            MyclassJSBridge[otherCallbackId] && MyclassJSBridge[otherCallbackId](args || {});

            var keepCallback = args.keepCallback;
            if (!keepCallback) {
                delete MyclassJSBridge[callbackId];
            }

            return true;
        },

        config: function(args) {
            if (args !== undefined) {
                if (typeof(args.debug) == 'boolean') {
                    debug = args.debug;
                }

                if (args.jsApiList != undefined) {
                    for (var i = 0, len = args.jsApiList.length; i < len; i++) {
                        args.jsApiList[i] = 'js_' + args.jsApiList[i];
                    }
                }
                args.success = function(data) {
                    configReady = 1;
                    MyclassJSBridge['readyCallback'] && MyclassJSBridge['readyCallback'](data || {});

                    delete MyclassJSBridge['readyCallback'];
                    delete MyclassJSBridge['errorCallback'];
                };
                args.fail = function(data) {
                    configReady = 0;
                    MyclassJSBridge['errorCallback'] && MyclassJSBridge['errorCallback'](data || {});

                    delete MyclassJSBridge['readyCallback'];
                    delete MyclassJSBridge['errorCallback'];
                };
                invoke('js_config', args);
            }
        },

        ready: function(readyCallback) {
            if (readyCallback && typeof(readyCallback) == 'function') {
                if (configReady === 1) {
                    readyCallback({});
                } else {
                    MyclassJSBridge['readyCallback'] = readyCallback;
                }
            }
        },

        error: function(errorCallback) {
            if (errorCallback && typeof(errorCallback) == 'function') {
                if (configReady === 0) {
                    errorCallback({});
                } else {
                    MyclassJSBridge['errorCallback'] = errorCallback;
                }
            }
        },

        checkJsApi: function(args) {
            invoke('js_checkJsApi', args);

            if (args !== undefined) {
                var jsApiList = args.jsApiList;
                var checkResult = new Object;
                for (var i = 0, len = jsApiList.length; i < len; i++) {
                    checkResult[jsApiList[i]] = contains(supportApiList, jsApiList[i]);
                }
                args.checkResult = checkResult;
                args.callbackName = 'success';
                delete args.jsApiList;
                delete args.method;
                delete args.appId;
                this.callback(args);
            }
        },

        authorise: function(args) {
            invoke('js_authorise', args);
        },

        setNavigationBarTitle: function(args) {
            invoke('js_setNavigationBarTitle', args);
        },

        setRequestHeaderReferer: function(args) {
            invoke('js_setRequestHeaderReferer', args);
        },

        hideUrlTip: function(args) {
            invoke('js_hideUrlTip', args);
        },

        showOptionMenuButton: function(args) {
            invoke('js_showOptionMenuButton', args);
        },

        hideOptionMenuButton: function(args) {
            invoke('js_hideOptionMenuButton', args);
        },

        hideMenuItems: function(args) {
            invoke('js_hideMenuItems', args);
        },

        showMenuItems: function(args) {
            invoke('js_showMenuItems', args);
        },

        hideAllNonBaseMenuItem: function(args) {
            invoke('js_hideAllNonBaseMenuItem', args);
        },

        showAllNonBaseMenuItem: function(args) {
            invoke('js_showAllNonBaseMenuItem', args);
        },

        showToast: function(args) {
            invoke('js_showToast', args);
        },

        hideToast: function(args) {
            invoke('js_hideToast', args);
        },

        closePage: function(args) {
            invoke('js_closePage', args);
        },

        refresh: function(args) {
            invoke('js_refresh', args);
        },

        navigateTo: function(args) {
            invoke('js_navigateTo', args);
        },

        navigateBack: function(args) {
            invoke('js_navigateBack', args);
        },

        redirectTo: function(args) {
            invoke('js_redirectTo', args);
        },

        showActionSheet: function(args) {
            invoke('js_showActionSheet', args);
        },

        showDatePicker: function(args) {
            invoke('js_showDatePicker', args);
        },

        showCustomPicker: function(args) {
            invoke('js_showCustomPicker', args);
        },

        showCheckBox: function(args) {
            invoke('js_showCheckBox', args);
        },

        updateAppShareData: function(args) {
            invoke('js_updateAppShareData', args);
        },

        shareData: function(args) {
            invoke('js_shareData', args);
        },

        chooseImage: function(args) {
            invoke('js_chooseImage', args);
        },

        previewImage: function(args) {
            invoke('js_previewImage', args);
        },

        uploadImage: function(args) {
            invoke('js_uploadImage', args);
        },

        uploadImages: function(args) {
            invoke('js_uploadImages', args);
        },

        downloadImage: function(args) {
            invoke('js_downloadImage', args);
        },

        saveImage: function(args) {
            invoke('js_saveImage', args);
        },

        chooseVideo: function(args) {
            invoke('js_chooseVideo', args);
        },

        playVideo: function(args) {
            invoke('js_playVideo', args);
        },

        uploadVideo: function(args) {
            invoke('js_uploadVideo', args);
        },

        downloadVideo: function(args) {
            invoke('js_downloadVideo', args);
        },

        chooseVoice: function(args) {
            invoke('js_chooseVoice', args);
        },

        playVoice: function(args) {
            invoke('js_playVoice', args);
        },

        uploadVoice: function(args) {
            invoke('js_uploadVoice', args);
        },

        downloadVoice: function(args) {
            invoke('js_downloadVoice', args);
        },

        getLocation: function(args) {
            invoke('js_getLocation', args);
        },

        getNetworkType: function(args) {
            invoke('js_getNetworkType', args);
        },

        getAppVersion: function(args) {
            invoke('js_getAppVersion', args);
        },

        showDialog: function(args) {
            invoke('js_showDialog', args);
        },

        previewFile: function(args) {
            invoke('js_previewFile', args);
        },

        showCustomRightBarItem: function(args) {
            invoke('js_showCustomRightBarItem', args);
        },

        showPopMenu: function(args) {
            invoke('js_showPopMenu', args);
        },

        showInput: function(args) {
            invoke('js_showInput', args);
        },

        chooseContact: function(args) {
            invoke('js_chooseContact', args);
        },

        setNavigationType: function(args) {
            invoke('js_setNavigationType', args);
        },

        showScan: function(args) {
            invoke('js_showScan', args);
        },

        payOrder: function(args) {
            invoke('js_payOrder', args);
        }
    };

    window.MyclassJSBridge = MyclassJSBridge;
}());