/**
 * base.js
 * @description 应用初始化
 * @createTime	2014-06-30
 * @author leon.deng
 */
var uiWidth = 480;
var deviceWidth = screen.width;
var deviceHeight = screen.height;
var rate = uiWidth / deviceWidth;
var screenSize = App.getScreen();

Util.screenAdapt();

 var APPID="281";
try {
	var APPID =App.getAppId();
	if(APPID == "undefined" || APPID == null || APPID == "" || APPID.indexOf("sdmpay") !=-1){
		APPID ="281";
	}
}catch (e) {
	console.error('应用ID:'+e.message);
	APPID ="281";
}

var productNo = "";
var locationCode = "";
var appVersion = "";	// 资源包的版本号（新）

// 每个页面的根节点（注意命名以page开头）
var pageMain;		// 主页1(无账单)
var pageBilllist;	// 主页2(有账单)
var pagePartner;    //收费单位列表页面
var pageQuery_msg; //欠费查询
var pageBillrecharge;	// 查询结果

var needfresh=false;//默认刷新首页账单列表 add 08-14  false 禁止刷新账单列表

// 每个页面对应的JS对象（注意命名以obj开头）
var objMain;
var objBilllist;
var objSelectAddress;
var objPartner;
var objQuery_msg;
var objOrderrecharge;

var viewData = {
    CurrentProvinceName:"",
    CurrentCityName:"",
    CurrentProvinceCode:"",
    CurrentCityCode:"",
    CityList:{},
    CityNameArray:[],
    CityCodeArray:[],
    CityCodeNameDict:{},
    AppVersion:"",
    Partners:[],
    CurrentPartner:null,
    isFirstLoad:true
}

// 省代码 ,当前省名称
var provinceCode,CurrentProvinceName;

// 城市代码,当前城市名称
var cityCode,CurrentCityName;

// 从接口获取所有开通城市的数组
var OpenCityList;

//创建户号条形码容器
var divEltCont = document.createElement("div");
divEltCont.className = "radio-btn-container";

//创建头部text容器
var headDivEltContainer = document.createElement("div");
headDivEltContainer.className = "headDivEltContainer";

var owingcdDiv= DomUtil.createDivElt("div");
owingcdDiv.className="owingcdDiv";	
// 收费单位
var isSinglePartner = false;

var pageArray = new Array();

window.onload = function() {
	pageMain = $_id(pageIds.main);
	pageBilllist = $_id(pageIds.billlist);
	pagePartner = $_id(pageIds.partner);
	pageQuery_msg=$_id(pageIds.query_msg);
	pageBillrecharge = $_id(pageIds.billrecharge);
	
	App.setKeyEventListener(function(event) {
		if (event == 'backpress') {
			back();
		}
	});
    // true返回键绑定，由JavaScript来处理事件；false表示WebView返回上一个页面
	App.overrideBackPressed(true);

	productNo = User.getProduct();
	locationCode = User.getLocation();
    viewData.AppVersion = App.getVersion();
    
	queryBill(false);

	bindBaseEvents();
};

function bindBaseEvents(){
    FastClick.attach(document.body);
    
    //文本框获取焦点，显示清除按钮
    $(".cinput").unbind("click").click(function(e){
        stopDefault(e);
        var _lline = $(this).parents(".iline");
        _lline.find(".rimg").hide();
        $(".txt-close").hide();
        _lline.find(".txt-close").show();
    });

    //文本框清空
    $(".txt-close").unbind("click").click(function(e){
        stopDefault(e);
        $(this).parents(".iline").find(".cinput").val("").focus();
        if(historyDiv){
            historyDiv.style.display = "none";
        }
        $(".text-warn").html("").hide();
        return false;
    });

    //点击界面任意地方，文本框样式复位
    $(document).unbind("click").bind("click", function(){
        if(obj.currentCheckQueryType == QUERYTYPE.SCAN){
            $_id("openScan").style.display = "block";
        }
        $(".txt-close").hide();
        historyDiv.style.display = "none";
    });
}
var back = function() {
	if (hDialogId != "") {
		DialogUtil.closeHDialog();
		return;
	}
	// 返回当前的页面（即将要关闭的页面）Id，并将其从pageArray数组中移除
	var length = pageArray.length;
	var oldId = pageArray.pop();
	var element = document.getElementById(oldId);
	
	if(oldId == pageIds.main && needfresh == true){//add 08-14
		this.queryBill(false);
	} else if (length <= 1) {
		App.exitApp();
		return;
	}
	element.style.display = 'none';
	onPageClose(oldId);

	// 关闭上面的页面后，新页面的Id
	len = pageArray.length;
	var id = pageArray[len - 1];
	element = document.getElementById(id);
	element.style.display = 'block';
	App.setTitle(pageTitles[id]);
    //add by leon.deng  15/04/13
    if(id == pageIds.selectProvince){
        var lastScroll = parseInt($("#_select_province").data("_scrollTop"));
        $("body").scrollTop(lastScroll);
    }else{
        scroll(0, 0);
    }

	if (pageIds.query_msg == oldId) {
			if (isSinglePartner) {
				isSinglePartner = false;
				back();
			}
	}
};

/**
 * 关闭当前界面
 * @param {} id 当前界面对应的id
 */
var onPageClose = function(id) {
	if(id==pageIds.partner){
		objPartner.onPageClose();
	}else if (id ==pageIds.query_msg) {
		objQuery_msg.onPageClose();
		objQuery_msg = null;
	}
};

var toNextPage = function(id, obj) {
	if (pageArray.length > 0) {
		var oldPageElt = $_id(pageArray[pageArray.length - 1]);
		oldPageElt.style.display = 'none';
	}
    if(id != pageIds.main){
        $_id(id).style.display = 'block';
    }

	scroll(0, 0);
	pageArray[pageArray.length] = id;
    var ptit = pageTitles[id];

	if(ptit && ptit != ""){
		App.setTitle(pageTitles[id]);
	}
	switchPageId(id, obj);
};

var switchPageId = function(id, obj) {
	switch (id) {
	case pageIds.billlist:
		objBilllist = new Billlist();
		objBilllist.initPage(obj);
		break;
	case pageIds.partner:
		objPartner = new Partner(productNo, locationCode, obj);
		break;
	case pageIds.query_msg:
		objQuery_msg = new QueryMsg(productNo, locationCode, obj);
		break;
	case pageIds.main:
		objMain = new Main();
		objMain.init();
		break;
	}
};

var handleException = function() {
	var id = pageArray[pageArray.length - 1];
	if (id == pageArray.billlist) {
		App.exitApp();
		return;
	}
	if (id == "partner" || id == "query_msg") {
		back();
	}
};



/**
 * 调用queryBill接口，查询所有账单
 */
var queryBill = function(isFromDelete) {
	needfresh = false;//禁止返回首页刷新账单列表
    var sessionKey = App.getSessionKey();
	var params = HttpUtil.getJsonHttpParams(METHOD.QUERYBILL, "", sessionKey);
	params['PRODUCTNO'] = productNo;
	params['STARTINDEX'] = 0;
	params['COUNTS'] = 5000;
	params['BUSINESSTYPE'] = BILLBUSITYPE;
	
	DialogUtil.showNDialog("小翼正在为您查找账单,请稍候..."+"\n"+"\n"+"账单左划可修改备注哦~");
	var successCallback = function(json) {
		if (ValiUtil.isJsonEmpty(json)) {
			Dialog.alert(REQUEST_ERROR_MSG);
			return;
		}
		if (!ValiUtil.hasErrorMsg(json)) {
			var billList = json.BILLLIST;
			if (billList == null || billList == "undefined" || billList.length <= 0) {
				//重置 防止账单删完,默认加载到主界面后, 点击返回任然退到该界面,未退出应用
				pageArray = new Array();//add 08-14
				toNextPage(pageIds.main);
			} else {
				if (isFromDelete) {
					$_id(pageIds.billlist).style.display = "none";
					pageArray = new Array();
				} else {
					isBoot();
					$_id(pageIds.main).style.display = "none";
				}
				toNextPage(pageIds.billlist, json);
			}
		} else {
			$_id(pageIds.billlist).style.display = "none";
			//重置 防止账单删完,默认加载到主界面后, 点击返回任然退到该界面,未退出应用
			pageArray = new Array();//add 08-14
			toNextPage(pageIds.main);
		}
	};
	var errorCallback = function() {
		DialogUtil.dismissNDialog();
		Dialog.alert(REQUEST_ERROR_MSG);
		handleException();
		return;
	};
	HttpUtil.sendRequest(billURL, params, successCallback, errorCallback);
};


function isBoot(){
	var isBootCode = Preference.get(SP.isBoot, "");
	if(isBootCode==""){
		var bootDiv= DomUtil.createDivElt("boot_div");
		bootDiv.ontouchmove=function(event) {
			event.preventDefault();
		}
        bootDiv.addEventListener('touchend', function(){
        	$(this).animate({right:'250px'});
        	$(this).fadeOut(2000);
        }, false);
		pageBilllist.appendChild(bootDiv);
		Preference.put(SP.isBoot,"true");
	}
}

var SPKEY  = {
    LASTQUERY: function(){
        var tk = [viewData.CurrentCityCode, "-" , BUSITYPE , "-", productNo].join('');
        return tk;
    },
    LASTPARTNERCOMPC: function(){
        var tk = ["partner-compc-", BUSITYPE, "-", viewData.CurrentCityCode,"-",productNo].join('');
        return tk;
    },
    LASTQUERYTYPE: function(){
        var tk = [viewData.CurrentCityCode,"-",BUSITYPE ,"-qtype-",productNo].join('');
        return tk;
    }
}