/**
 * 主界面(有账单记录)，对应的pageId为 _billlist
 */
var Billlist = function() {
	this.lastObj = null;
	this.lastOutObj=null;
	this.currentDateElt = null;		// 当前的提醒日期DOM对象
	/*当前选择的账期*/
	this.curCheckedBillMonthIndex = 0;
};

/**
 * 控制温馨提示的显示
 * @param {} msg
 */
Billlist.prototype.showMsg = function(msg) {
	if (msg == null || msg == "" || msg == "undefined") {
		$_id("bl_wenxintishi_s").style.display = "none";
		$_id("bl_wenxintishi_m").style.display = "none";
	} else {
		if (msg.length <= 13) {
			$_id("bl_wenxintishi_s").innerHTML = "温馨提示：" + msg;
			$_id("bl_wenxintishi_m").style.display = "none";
			$_id("bl_wenxintishi_s").style.display = "block";
		} else {
			$_id("bl_wxts_content").innerHTML = msg;
			$_id("bl_wenxintishi_s").style.display = "none";
			$_id("bl_wenxintishi_m").style.display = "block";
		}
	}
};

/**
 * 获取广告
 */
Billlist.prototype.getAppNotice = function() {
	var successCallback = function(result) {
		if (result == null || result == "" || result == '连接超时' || JSON.stringify(result) == '连接超时') {
			return;
		} else {
			var json_result = result;
			if (json_result.ERRORCODE == '000000') {// success
				var recordamount= result.RECORDAMOUNT;//返回列表中广告总数
				var adlist= result.ADLIST;//返回广告列表
				if(recordamount > 0 && adlist.length > 0) {		//显示广告位
					var adtext = adlist[0].ADTEXT;
					$("#bl_notice").html(adtext);
					$("#bl_notice").show();
				} else {
					$("#bl_notice").hide();
				}
			} else {
				var noteMsg = json_result.ERRORMSG;
			}
		}
	};
	HttpUtil.getAppNotice(httpURL, productNo, successCallback);
}

/**
 * 初始化账单记录页面
 */
Billlist.prototype.initPage = function(json) {
	var billlist = json.BILLLIST;
	for (var i = 0; i < billlist.length; i++) {
		var billItem = billlist[i];
		var displayName = billItem.BILLORGNAME;
		if (displayName && displayName != null && displayName.length > 9) {
			displayName = displayName.substring(0, 9) + "...";
		}
		var displayBarcode = billItem.BARCODE;
		if (displayBarcode && displayBarcode != null && displayBarcode.length > 12) {
			displayBarcode = displayBarcode.substring(0, 12) + "...";
		}
		
		var displayNotice = "暂无提醒";
		var tempDate = billItem.NOTICETIME;
		
		if (tempDate != null && tempDate.length == 8) {
			var curDate = "";
			if (tempDate.substring(6, 7) == "0") {
				curDate = tempDate.substring(7);
			} else {
				curDate = tempDate.substring(6);
			}
			displayNotice = curDate + "号提醒";
		}
		
		billItem.JSONVALUE = JSON.stringify(billItem);
		billItem.DISPLAYNAME = displayName;
		billItem.DISPLAYBARCODE = displayBarcode;
		billItem.DISPLAYNOTICE = displayNotice;
		billlist[i] = billItem;
	}
	var result = { BILLLIST : billlist };
	Util.Console.log("加载模版：" + JSON.stringify(result));
	var billListElt = $_id("billlist_out");
	billListElt.innerHTML = "";
	var bill_item_container = $(billListElt).setTemplateURL("tpl/item_bill_tpl.html");
	bill_item_container.processTemplate(result);
	this.showMsg(json.MSG);
	this.getAppNotice();
	this.initItem();
	
	$_id("recharge_other").onclick = function(e) {
        stopDefault(e);
		needfresh = false;//禁止返回首页调接口刷新账单列表初始化
		if (obj.lastObj != null) {
			obj.lastObj.prev();
		}
		objMain = new Main();
		toNextPage(pageIds.main);
	};
};

/**
 * 显示修改备注对话框
 */
Billlist.prototype.showRemarkDlg = function(elt) {
	var obj = this;
	var item = JSON.parse(elt.getAttribute("data-item"));
	DialogUtil.showHDialog("remark_dialog");
	if (ValiUtil.isJsonEmpty(item)) {
		return;
	}
	var delElt = $_id("bill_dialog_del");
	var remarkElt = $_id("remark_input");
	remarkElt.value = item["REMARK"];
	if (remarkElt.value != "") {
		$(delElt).show();
	} else {
		$(delElt).hide();
	}
	remarkElt.addEventListener("input", function() {
		var value = this.value;
		if (value.length >= 10) {
			this.value = value.substring(0, 10);
		}
		// 过滤&符号	2014/04/08
		if (value.indexOf("&") != -1) {
			this.value = value.replace("&", "");
		}
		if (value.length > 0) {
			$(delElt).show();
		} else {
			$(delElt).hide();
		}
	}, false);

	delElt.onclick = function(e) {
        stopDefault(e);
		remarkElt.value = "";
        remarkElt.focus();
		$(delElt).hide();
	}
	
	$_id("remark_btn_cancel").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		remarkElt.value = "";
		obj.lastObj.prev();
	};
	
	$_id("remark_btn_ok").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		var params = obj.getBillUpdateJson(item);
		var newRemark = remarkElt.value;
		params["REMARK"] = newRemark;
		remarkElt.value = "";
		var submitCallback = function(result) {
			DialogUtil.dismissNDialog();//add 08-18
			if (ValiUtil.isJsonError(result)) {
				return;
			}
			item["REMARK"] = newRemark;
			$_id("rm_" + item.SYSBILLNO).innerHTML = newRemark;
			elt.setAttribute("data-item", JSON.stringify(item));
			Toast.makeText("修改备注成功", Toast.LENGTH_SHORT);
			obj.lastObj.prev();
			return;
		};
		var errorCallback = function(json) {
			DialogUtil.dismissNDialog();
			DialogUtil.closeHDialog();
			Toast.makeText("修改备注失败", 1);
			obj.lastObj.prev();
		}
		DialogUtil.showNDialog();
		HttpUtil.sendRequest(billURL, params, submitCallback, errorCallback);
	};
};

/**
 * 显示修改提醒对话框
 */
Billlist.prototype.showNoticeDlg = function(elt) {
	var obj = this;
	obj.currentDateElt = null;
	var item = JSON.parse(elt.getAttribute("data-item"));
	if (ValiUtil.isJsonEmpty(item)) {
		return;
	}
	var noticeTime = item["NOTICETIME"];
	Util.Console.log("当前的noticetime：" + noticeTime);
	
	var noticeDate = 0;		// 提醒日 如12、5等
	var noDateDiv = null;	// 不提醒
	var dateNoticeMsg = $_id("data_notice_msg");
	
	//add 2014.10.22   “不提醒”样式
	var noDateDiv = DomUtil.createDivElt("div");
	var noDateImg1 = DomUtil.createDivElt("no-date-div-checked", null, null);
	var noDateImg2 = DomUtil.createDivElt("no-date-div-unchecked", null, null);
	var noDateCue = DomUtil.createDivElt("no-date-div", "date_div_0", "暂不提醒");
	
	if (noticeTime != null && noticeTime != "" && (noticeTime.length == 8)) {
		noticeDate = noticeTime.substring(6);
		noDateDiv.appendChild(noDateImg2);
		noDateDiv.appendChild(noDateCue);
		dateNoticeMsg.className = "date-notice-text";
	} else {
		noticeDate = 0;
		noDateDiv.appendChild(noDateImg1);
		noDateDiv.appendChild(noDateCue);
		dateNoticeMsg.className = "date-notice-text-disable";
		obj.currentDateElt = noDateDiv;
	}
	
	// 设置“不提醒”按钮的基本属性：
	noDateDiv.setAttribute("data-date", "0");
	noDateDiv.onclick = function(e) {
        stopDefault(e);
		if (obj.currentDateElt != null && obj.currentDateElt.getAttribute("data-date") != 0) {
			obj.currentDateElt.className = "date-div";
		}
		noDateDiv.innerHTML = "";
		obj.currentDateElt = this;
		//this.className = "no-date-div-select";
		noDateDiv.appendChild(noDateImg1);
		noDateDiv.appendChild(noDateCue);
		dateNoticeMsg.className = "date-notice-text-disable";
		this.appendChild(noDateDiv);
	}
		
	var outElt = $_id("date_notice_out");
	outElt.innerHTML = "";
	
	var d1 = DomUtil.createDivElt("date-div-out");		// 1-7
	var d2 = DomUtil.createDivElt("date-div-out");		// 8-14
	var d3 = DomUtil.createDivElt("date-div-out");		// 15-21
	var d4 = DomUtil.createDivElt("date-div-out");		// 22-28
	var d6 = DomUtil.createDivElt("date-div-out");		// "不提醒"

	d6.appendChild(noDateDiv);
	
	for (var i = 1; i <= 28; i++) {
		var dateElt;
		if (i == noticeDate) {
			dateElt = DomUtil.createDivElt("date-div-select", "date_div_" + i, i + "");
			obj.currentDateElt = dateElt;
		} else {
			dateElt = DomUtil.createDivElt("date-div", "date_div_" + i, i + "");
		}
		dateElt.setAttribute("data-date", i + "");		
		dateElt.onclick = function(e) {
            stopDefault(e);
			var newDate = this.getAttribute("data-date");
			if (obj.currentDateElt != null) {
				if (obj.currentDateElt.getAttribute("data-date") == 0) {
					noDateDiv.innerHTML = "";
					noDateDiv.appendChild(noDateImg2);
					noDateDiv.appendChild(noDateCue);
					obj.currentDateElt = noDateDiv;
				} else {
					obj.currentDateElt.className = "date-div";
				}
			}
			this.className = "date-div-select";
			obj.currentDateElt = this;
			dateNoticeMsg.className = "date-notice-text";
		};
		switch (parseInt((i - 1) / 7)) {
		case 0:
			d1.appendChild(dateElt);
			break;
		case 1:
			d2.appendChild(dateElt);
			break;
		case 2:
			d3.appendChild(dateElt);
			break;
		case 3:
			d4.appendChild(dateElt);
			break;
		}
	}
	outElt.appendChild(d1);
	outElt.appendChild(d2);
	outElt.appendChild(d3);
	outElt.appendChild(d4);
	outElt.appendChild(d6);
	
	DialogUtil.showHDialog("notice_dialog");
	
	$_id("notice_btn_cancel").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		obj.lastObj.prev();//--------
	};
	
	// 点击“确认”按钮，修改提醒
	$_id("notice_btn_ok").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		var params = obj.getBillUpdateJson(item);
		
		var newDate = "";
		if (obj.currentDateElt != null) {
			newDate = obj.currentDateElt.getAttribute("data-date");
			if (newDate == "0" || newDate == 0) {
				params["NOTICETIME"] = "";
			} else {
				params["NOTICETIME"] = DateUtil.getNoticeTime(newDate);
			}
		} else {
			params["NOTICETIME"] = "";
		}
		
		var submitCallback = function(result) {
				obj.lastObj.prev();//解决修改提醒日期后不能初始化item  add 08-20 
			if (ValiUtil.isJsonEmpty(result)) {
				Toast.makeText("修改提醒失败", Toast.LENGTH_SHORT);
				return;
			}
			
			item["NOTICETIME"] = params["NOTICETIME"];
			elt.setAttribute("data-item", JSON.stringify(item));
			
			if (ValiUtil.hasErrorMsg(result)) {
				Toast.makeText(result.ERRORMSG, Toast.LENGTH_SHORT);
				return;
			}
			if (newDate == "" || newDate == "0") {
				Toast.makeText("缴费提醒已关闭", Toast.LENGTH_SHORT);
				elt.innerHTML = "暂无提醒";
			} else {
				Toast.makeText("设置成功！您将每月的" + newDate + "号收到缴费提醒", Toast.LENGTH_SHORT);
				elt.innerHTML = newDate + "号提醒";
			}
			return;
		};
		var errorCallback = function(json) {
			obj.lastObj.prev();//解决修改提醒日期后不能初始化item  add 08-20 
			DialogUtil.dismissNDialog();
			DialogUtil.closeHDialog();
			Toast.makeText("修改提醒失败", Toast.LENGTH_SHORT);
		}
		DialogUtil.showNDialog();
		HttpUtil.sendRequest(billURL, params, submitCallback, errorCallback);
	};
};

/**
 * 显示删除账单对话框
 */
Billlist.prototype.showdeleteDlg = function(elt) {
	var obj = this;
	var item = JSON.parse(elt.getAttribute("data-item"));
	DialogUtil.showHDialog("delete_dialog");
	
	$_id("delete_btn_cancel").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		obj.lastObj.prev();
	};
	$_id("delete_btn_ok").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
		var params = obj.getBillDeleteJson(item);
		var submitCallback = function(result) {
			if (ValiUtil.isJsonEmpty(result)) {
				Toast.makeText("删除账单失败", Toast.LENGTH_SHORT);
				return;
			}
			if (ValiUtil.hasErrorMsg(result)) {
				Toast.makeText(result.ERRORMSG, Toast.LENGTH_SHORT);
				return;
			}
			obj.lastObj.prev();
//			$_id(pageIds.billlist).style.display = "none";
//			pageArray = new Array();
			queryBill(true);
			return;	
		};
		var errorCallback = function(json) {
			DialogUtil.dismissNDialog();
			DialogUtil.closeHDialog();
			Toast.makeText("删除账单失败", Toast.LENGTH_SHORT);
			obj.lastObj.prev();
		}
		DialogUtil.showNDialog();
		HttpUtil.sendRequest(billURL, params, submitCallback, errorCallback);
	};
};

/**
 * 点击整个item，进入快速欠费查询
 * @param {} elt
 */
Billlist.prototype.showOrderRecharge = function(elt) {	
	if (nDialogId != 0 || hDialogId != "" || elt.parentNode.parentNode.getAttribute("data-click") == "false") {
		return;
	}
	var item = JSON.parse(elt.getAttribute("data-item"));
	var monthMark = item["MONTHMARK"];
	Util.Console.log("账期标识：" + monthMark);
	if (monthMark == 1) { // 支持多账期,需要显示账期对话框
		this.showMonthDialog(item);
		return;
	}
	if ((item["CITYCODE"].startwith("31"))
			&& (item["BUSINESSTYPE"] == "S" || item["BUSINESSTYPE"] == "M")) {
		this.showAmtDialog(item, null);
		return;
	}
	needfresh = false;//禁止返回首页刷新账单列表
	this.queryDirectRecharge(item, null, null);
};

/**
 * 调用通用缴费中的快速欠费查询接口 queryDirectRecharge
 * @param {} jsonObj	该账单的JSON对象
 * @param {} month		输入的账期(广电等部分城市需要， null表示不需要账期)
 * @param {} amt		输入的查询金额(部分城市需要， null表示不需要查询金额)
 */
Billlist.prototype.queryDirectRecharge = function(jsonObj, month, amt) {
	if (this.lastObj != null) {
		this.lastObj.prev();
	}
    var sessionKey = App.getSessionKey();
	var params = HttpUtil.getJsonHttpParams("queryDirectRecharge", "", sessionKey);
	params['PRODUCTNO'] = productNo;
	params['ACCOUNTNO'] = jsonObj['BARCODE'];
	params['ID'] = HttpUtil.getPosSeqno(productNo);
	params['COMPC'] = jsonObj['BILLORGCODE'];
	params['CITYC'] = jsonObj['CITYCODE'];
	params['BUSITYPE'] = jsonObj["BUSINESSTYPE"];
	if (month != null) {
		params['FROMMONTH'] = month;
	} else {
		params['FROMMONTH'] = "";
	}
	if (amt != null) {
		params['QUERYAMT'] = amt;
	} else {
		params['QUERYAMT'] = "";
	}
	var successCallback = function(json) {
		if(ValiUtil.isJsonError(json)) {
			return;
		}
		objOrderrecharge = new Orderrecharge(json["RESERVED"]);
		toNextPage(pageIds.billrecharge, null);
	};
	
	DialogUtil.showNDialog();
	HttpUtil.sendRequest(httpURL, params, successCallback);
};

/**
 * 显示账期对话框
 */
Billlist.prototype.showMonthDialog = function(jsonObj) {
	var obj = this;
	DialogUtil.showHDialog("month_dialog");
	var months = DateUtil.generateMonths();
	$_id("select_month").innerHTML = months[0].month;
	obj.curCheckedBillMonthIndex = 0;//add 2014.10.29
	
	$_id("month_select_dialog").onclick = function(e) {
        stopDefault(e);
		Dialog.showSingleChoiceDialog("请选择账期", months, obj.curCheckedBillMonthIndex, "month",
			function(result) {
				obj.curCheckedBillMonthIndex = result;
				$_id("select_month").innerHTML = months[result].month;
			}
		);
	}
	$_id("month_btn_cancel").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
	};
	$_id("month_btn_ok").onclick = function(e) {
        stopDefault(e);
		var month = $_id("select_month").innerHTML;
		month = month.replace(/^([0-9]{4})-([0-9]{2})$/, "$1$2");
		DialogUtil.closeHDialog();
		if ((jsonObj["CITYCODE"].startwith("31"))
				&& (jsonObj["BUSINESSTYPE"] == "S" || jsonObj["BUSINESSTYPE"] == "M")) {
			obj.showAmtDialog(jsonObj, month);
		} else {
			obj.queryDirectRecharge(jsonObj, month, null);
		}
	}
};

/**
 * 上海的水和煤需要输入查询金额
 */
Billlist.prototype.showAmtDialog = function(jsonObj, month) {
	var obj = this;
    $("#amt_input").val("");
	DialogUtil.showHDialog("amt_dialog");
	$_id("amt_btn_cancel").onclick = function(e) {
        stopDefault(e);
		DialogUtil.closeHDialog();
	}
	$_id("amt_btn_ok").onclick = function(e) {
        stopDefault(e);
		var amt = $_id("amt_input").value;
		if (amt == null || amt == "") {
			return;
		}
		if (/[0-9]*\./.test(amt)) {
			return;
		}
		DialogUtil.closeHDialog();
		obj.queryDirectRecharge(jsonObj, month, amt);
	}
}

/**
 * 初始化item横拉
 */
Billlist.prototype.initItem = function() {
    obj = this;
    $(".billcenter_li").each(function () {
    	var curItem = this;
        var billcenter_li_Obj = Swipe(this, {
            speed: 250,
            continuous: false,
            callback: function () {
            	if (curItem.getAttribute("data-click") == "false") {
            		curItem.setAttribute("data-click", "true");
                } else {
                	curItem.setAttribute("data-click", "false");
                }
            	
                if (obj.lastObj == null) {
                    obj.lastObj = billcenter_li_Obj;
                    lastOutObj=curItem;
                } else {
                    if (obj.lastObj != billcenter_li_Obj) {
                        obj.lastObj.prev();
                        lastOutObj.setAttribute("data-click", "true");
                        obj.lastObj = billcenter_li_Obj;
                        lastOutObj=curItem;
                    }
                }
                if (nDialogId > 0) {
                	obj.lastObj.prev();
                }
            }
        });
    });
};

/**
 * 将查询到的账单JSON转换为修改账单时的入参
 * @param {} oldJson
 */
Billlist.prototype.getBillUpdateJson = function(oldJson) {
	var params = HttpUtil.getJsonHttpParams("updateBill", "", "");
	params["PRODUCTNO"] = productNo;
	params["BARCODE"] = oldJson["BARCODE"];
	params["NUMBERTYPE"] = oldJson["NUMBERTYPE"];
	params["BILLORGCODE"] = oldJson["BILLORGCODE"];
	params["BUSINESSTYPE"] = oldJson["BUSINESSTYPE"];
	params["PAYORGCODE"] = oldJson["PAYORGCODE"];
	params["PAYORGNAME"] = oldJson["PAYORGNAME"];
	params["NOTICETIME"] = oldJson["NOTICETIME"];
	params["ACCOUNT_MONTH"] = oldJson["ACCOUNTMONTH"];
	params["SYSBILLNO"] = oldJson["SYSBILLNO"];
	params["PROVINCECODE"] = oldJson["PROVINCECODE"];
	params["REPLACEFLAG"] = oldJson["REPLACEFLAG"];
	params["REMARK"] = oldJson["REMARK"];
	return params;
}

Billlist.prototype.getBillDeleteJson = function(oldJson) {
	var params = HttpUtil.getJsonHttpParams("cancelBill", "", "");
	params["SYSBILLNO"] = oldJson["SYSBILLNO"];
	params["PRODUCTNO"] = productNo;
	params["BARCODE"] = oldJson["BARCODE"];
	params["NUMBERTYPE"] = oldJson["NUMBERTYPE"];
	params["BUSINESSTYPE"] = oldJson["BUSINESSTYPE"];
	return params;
}


