/**
 * 主界面，对应的pageId为 _main
 */
var Main = function() {
	/**
	 * 所有开通城市列表数组
	 */
	this.cityStrings = null;
	/**
	 * 当前的省的名称
	 */
	this.provinceName = null;
	/**
	 * 当前的城市名称
	 */
	this.cityName = null;
	/**
	 * 当前的省在省列表数组中的位置
	 */
	this.provicePosition = 0;
	/**
	 * 当前的城市在城市列表数组中的位置
	 */
	this.cityPosition = 0;
	this.cities = null;
	this.provinces = null;
	/**
	 * 合作商信息
	 */
	this.partner_list = null;
	
	/**
	 * 水电煤应用是否有缓存
	 */
	this.hasUserCache = false;

    //是否有账期
    this.hasFromMonth = false;
    //是否有缴费金额
    this.hasPaymentAmount = false;
    //是否有户号/条形码选择
    this.hasRadio = false;

	this.obj = this;

	this.curCheckedBillMonthIndex = 0;
    this.inputNodes = null;
    this.addressUrl = null;
    this.method = null;
    this.formId = null;
    this.sendData = null;
    this.cityCode = null;
    this.submitElt = null;
    this.currentCheckQueryType = QUERYTYPE.SCAN;

    this.curCheckedRadio = null;
};

var inputTextElt;
var inputAmountElt;
var historyDiv;

Main.prototype.init = function() {
    var obj = this;
    this.submitElt = $_id("btnQueryAccount");
    inputTextElt = $_id("txtQueryNo");
    inputAmountElt = $_id("txtPaymentAmount");
    historyDiv = $_id("historyDiv");
    this.getOpenCityList();

	//加载广告
	this.getAppNotice();

    //跳转至省份城市选择页面
    $("#paymentCityNameLine").unbind("click").click(function(){
        objSelectAddress = new selectAddress();
        if(Util.isCityOnly(viewData.CurrentCityCode)){
            toNextPage(pageIds.selectProvince);
        }else{
            toNextPage(pageIds.selectProvince);
            objSelectAddress.toCityPage(viewData.CurrentProvinceCode, viewData.CurrentProvinceName);
        }
    });

    //绑定户号条形码切换事件
    this.bindQueryTypeCheckEvent();

    //条形码扫描事件绑定
    $_id("openScan").onclick = scan;


}

/**
 * 获取开通城市列表，获取后将开通城市的代码放入cityStrings中
 * (获取开通城市列表)
 */
Main.prototype.getOpenCityList = function() {
    var obj = this;
    try {
        // 获取SYSREQ
        var sessionKey = App.getSessionKey();
        var params = HttpUtil.getJsonHttpParams(METHOD.GETOPENCITYLIST, "", sessionKey);
        params.BUSITYPE = BUSITYPE;
        params.PRODUCTNO = productNo;

        var Getopencitylist_callback = function(JsonResult) {
            if (ValiUtil.isJsonError(JsonResult)) {
                App.exitApp();
                return;
            }
            viewData.CityList = JsonResult.CITYLIST;
            obj.cityStrings = new Array();
            var am = viewData.CityList.length;
            for (var i = 0; i < am; i++) {
                var oco = viewData.CityList[i];
                viewData.CityNameArray[i] = oco.CITYNAME;
                viewData.CityCodeArray[i] = oco.CITYCODE;
                viewData.CityCodeNameDict[oco.CITYCODE] = oco.CITYNAME;
                obj.cityStrings[i] = oco.CITYCODE;
            }

            // 根据位置代码，从SharedPreferences中获取省的代码和城市代码
            var provinceCode = Preference.get(SP.PROVICE_CODE, "");
            var cityCode = Preference.get(SP.CITY_CODE, "");
            if(provinceCode == "" && provinceCode == ""){
                obj.hasUserCache = false;
             }else{
                if(Util.isOpenCity(cityCode)){
                    obj.hasUserCache = true;
                }
            }

            if (obj.hasUserCache == true) {
                // 获取缴费供应商列表
                viewData.CurrentProvinceCode = provinceCode;
                viewData.CurrentCityCode = cityCode;
                viewData.CurrentProvinceName = Util.getProvinceName(provinceCode);
                viewData.CurrentCityName = viewData.CityCodeNameDict[cityCode];
                obj.getPartnerList();
            } else {
                obj.GetPhoneAttribution();
            }
        }

        DialogUtil.showNDialog('正在加载已开通缴费业务城市列表，请稍候......');
        var errorCallback = function() {
            DialogUtil.dismissNDialog();
            Dialog.alert(REQUEST_ERROR_MSG);
            back();
        };
        HttpUtil.sendRequest(httpURL, params, Getopencitylist_callback,errorCallback);
    } catch (e) {
        console.error(e.message);
    }
};


/**
 * 获取当前号码的归属地
 */
Main.prototype.GetPhoneAttribution = function() {
    try {
        var sessionKey = App.getSessionKey();
        var params = HttpUtil.getJsonHttpParams(METHOD.GETPHONEATTRIBUTION, "", sessionKey);
        params.PRODUCTNO = productNo;
        var obj = this;

        var GetPhoneAttribution_callback = function(JsonResult) {
            //首页归属地获取失败时显示北京  by 14.08.14
            viewData.CurrentProvinceCode = JsonResult["PROVINCECODE"];
            viewData.CurrentCityCode = JsonResult["CITYCODE"];
            viewData.CurrentProvinceName = JsonResult["PROVINCECNAME"];
            viewData.CurrentCityName = JsonResult["CITYNAME"];
            handleAddress(viewData.CurrentCityCode, obj);
        }

        var errorCallback = function() {
            DialogUtil.dismissNDialog();
            Dialog.alert(REQUEST_ERROR_MSG);
            back();
        };
        HttpUtil.sendRequest(httpURL, params, GetPhoneAttribution_callback,errorCallback);
    } catch (e) {
        console.error(e.message);
    }
};

/**
 * 解析归属地查询返回的结果
 */
function handleAddress (cityCode,obj) {
    if (Util.isOpenCity(cityCode)) {
        viewData.CurrentProvinceCode = "110000";
        viewData.CurrentCityCode = "110000";
        viewData.CurrentProvinceName = "北京";
        viewData.CurrentCityName = "北京";
    }

    obj.getPartnerList();
}

/**
 * 获取合作商信息 (获取通用缴费供应商列表)
 */
Main.prototype.getPartnerList = function(isShowDialog, from) {
    var sessionKey = App.getSessionKey();
	var params = HttpUtil.getJsonHttpParams(METHOD.GETPARTNERLIST, "", sessionKey);
	params.ID = HttpUtil.getPosSeqno(productNo);
	params.CURRENTVERSION = viewData.AppVersion;
	params.PROVINCE = viewData.CurrentProvinceCode;
	params.CITY = viewData.CurrentCityCode;
	params.DISTRICT = "";
	params.PRODUCTNO = productNo;
	params.BUSITYPE = BUSITYPE;

	var obj = this;

	var getPartnerList_callback = function(JsonResult) {
		if (ValiUtil.isJsonError(JsonResult)) {
			App.exitApp();
			return;
		}
        obj.SetLocation();

        Preference.put(SP.PROVICE_CODE, viewData.CurrentProvinceCode);
        Preference.put(SP.CITY_CODE, viewData.CurrentCityCode);

        try {
            obj.parsePartnerListXML(JsonResult.RESERVED);
            viewData.Partners = obj.parsePartnerString('002');
            var lastQp = Preference.get(SPKEY.LASTPARTNERCOMPC(),"");
            if(lastQp!=""){
                viewData.CurrentPartner = getPartnerByCompc(lastQp);
            }else{
                viewData.CurrentPartner = viewData.Partners[0];
            }

            if(viewData.Partners.length == 1){
                $("#companyNameLine").unbind();
                $_id("companyNameMore").style.display = "none";
            }else{
                $_id("companyNameMore").style.display = "block";
                $("#companyNameLine").unbind("click").click(function(){
                    objPartner = new Partner(productNo, locationCode, viewData.Partners);
                    toNextPage(pageIds.partner, viewData.Partners);
                });
            }
            obj.selectPartner(false, from);
            $_id("companyName").innerHTML = viewData.CurrentPartner.COMPN;
        } catch (e) {
            console.error(e.message)
        }
	};

	var errorCallback = function() {
		DialogUtil.dismissNDialog();
		Dialog.alert(REQUEST_ERROR_MSG);
        back();
	};

    if(isShowDialog){
        DialogUtil.showNDialog('小翼正在为您准备服务,请稍候...');
    }

	HttpUtil.sendRequest(httpURL, params, getPartnerList_callback,errorCallback);
}

function getPartnerByCompc(compc){
    for(var p in viewData.Partners){
        if(p.COMPC == compc){
            return p;
        }
    }
    return viewData.Partners[0];
}

Main.prototype.selectPartner = function(isShowDialog, from) {
    var sessionKey = App.getSessionKey();
    var json_params = HttpUtil.getJsonHttpParams(METHOD.SELECTPARTNER, "", sessionKey);
    json_params.ID = HttpUtil.getPosSeqno(productNo);
    json_params.CURRENTVERSION = App.getVersion();
    json_params.PROVINCE = "PROVINCE";
    json_params.CITY = "CITY";
    json_params.DISTRICT = "DISTRICT";
    json_params.PRODUCTNO = productNo;
    json_params.PROC = viewData.CurrentPartner.PROC;
    json_params.CITYC = viewData.CurrentPartner.CITYC;
    json_params.COMPC = viewData.CurrentPartner.COMPC;//缴费单位编码
    json_params.BUSITYPE = BUSITYPE;

    var obj = this;

    this.cityCode = viewData.CurrentPartner.CITYC;

    var selectpartner_callback = function(result) {
        if (result == null || result == "" || result == '连接超时' || JSON.stringify(result) == '连接超时') {
            Dialog.alert(SYSTEM_BUSY);
            back();
            return;
        } else {
            var json_result = result;
            if (json_result.ERRORCODE == '000000') {// success
                obj.hasFromMonth = false;
                obj.hasPaymentAmount = false;
                obj.hasRadio = false;
                obj.curCheckedRadio = null;

                obj.parsePartnerDetailXML(json_result.RESERVED);
                obj.getAppReminder(viewData.CurrentPartner);
                Preference.put(SPKEY.LASTPARTNERCOMPC(), viewData.CurrentPartner.COMPC);
                if(isShowDialog || from == "address_province"){
                    back();
                } else if(from == "address_city"){
                    back();
                    back();
                }
            } else {
                DialogUtil.dismissNDialog();
                var noteMsg = json_result.ERRORMSG;
                Dialog.alert(noteMsg);
                back();
            }
        }
    }

    if(isShowDialog){
        DialogUtil.showNDialog('小翼正在为您准备服务,请稍候...');
    }
    var errorCallback = function() {
        DialogUtil.dismissNDialog();
        Dialog.alert(REQUEST_ERROR_MSG);
        back();
    };
    $_id("busiTimeDiv").style.display = "none";
    HttpUtil.sendRequest(httpURL, json_params, selectpartner_callback,errorCallback);
}

/**
 * 获取温馨提示
 * @param partner
 */
Main.prototype.getAppReminder = function(partner){
    var sessionKey = App.getSessionKey();
    var json_params = HttpUtil.getJsonHttpParams(METHOD.GETAPPREMINDER, "", sessionKey);
    json_params.PRODUCTNO = productNo;
    json_params.APP_ID =APPID;//应用ID
    json_params.APP_MARK = partner.COMPC;//缴费单位编码
    json_params.CITY_CODE = partner.CITYC;//业务地区编码

    var getAppReminder_callback = function(result) {
        if (result == null || result == "" || result == '连接超时' || JSON.stringify(result) == '连接超时') {
            return;
        } else {
            var json_result = result;
            if (json_result.ERRORCODE == '000000') {// success
                var html_str=json_result.REM_CONTENT;
                if(html_str.contains("温馨提示:" ==0) || html_str.indexOf("温馨提示：" ==0 )){
                    html_str = html_str.substring(5,html_str.length);
                }
                if($.trim(html_str) == ""){
                    $_id("main_wenxintishi_m").style.display = "none";
                }else {
                    $_id("main_wxts_content").innerHTML = html_str;
                    $_id("main_wenxintishi_m").style.display = "block";
                }
            } else {
                var noteMsg = json_result.ERRORMSG;
                Util.Console.log("温馨提示:"+noteMsg);
            }
        }
    }
    var errorCallback = function() {
        DialogUtil.dismissNDialog();
        Dialog.alert(REQUEST_ERROR_MSG);
        back();
    };
    HttpUtil.sendRequest(httpURL, json_params, getAppReminder_callback,errorCallback);
}

Main.prototype.parsePartnerDetailXML = function(xml) {
    var obj = this;
    var xmlDoc = DomUtil.loadXML(xml);
    var root = xmlDoc.getElementsByTagName("HTML");
    if (typeof root != 'undefined') {
        var nodes = root[0].childNodes;
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var localName = node.localName;
            if (localName == 'TEXT') {
                this.XMLParser_TEXT(node);
            }else if (localName == 'FORM') {
                this.XMLParser_FORM(node);
            }
        }
    }else{
        Dialog.alert("系统繁忙，请稍后再试...");
        App.exitApp();
    }
}

Main.prototype.XMLParser_FORM = function(node) {
    this.getFormData(node.attributes);
    var childNodes = node.childNodes;
    this.inputNodes = new Array();

    for (var i = 0; i < childNodes.length; i++) {
        if (childNodes[i].localName == 'INPUT') {
            var attrs = childNodes[i].attributes;
            this.createInputNode(attrs, childNodes[i]);
        }
    }

    if(this.hasFromMonth){
        $_id("paymentDaysDiv").style.display = "block";
    }else{
        $_id("paymentDaysDiv").style.display = "none";
    }
    if(this.hasPaymentAmount){
        $_id("paymentAmountDiv").style.display = "block";
    }else{
        $_id("paymentAmountDiv").style.display = "none";
    }

    if(this.hasRadio){
        $_id("queryTypePanel").style.display = "block";
        this.switchQueryType();
    }else{
        $_id("queryTypePanel").style.display = "none";
        $("#queryTypeDiv .c_dg").html("用户号");
        if(this.currentCheckQueryType == QUERYTYPE.SCAN){
            $_id("openScan").style.display = "block";
        }
    }
    $_id(pageIds.main).style.display = "block";
    setTimeout(function(){
        DialogUtil.dismissNDialog();
    }, 500)

}

Main.prototype.XMLParser_TEXT = function(node) {
    var text = node.firstChild.data;
    //console.log("解析text标签："+text)
    if(text.contains("开放时间") || text.contains("营业时间")){
        var tary = text.split("：");
        if(tary.length < 2){
            tary = text.split(":");
        }
        if(tary.length<2){
            return;
        }
        $_id("busiTime").innerHTML = tary[1];
        $_id("busiTimeDiv").style.display = "block";
    }else if(text.contains("收费单位")){
        var tary = text.split("：");
        if(tary.length < 2){
            tary = text.split(":");
        }
        if(tary.length<2){
            return;
        }
        $_id("companyName").innerHTML = tary[1];
    }
}

Main.prototype.createInputNode = function(attrs, node) {
    var obj = this;
    var typeAttr = DomUtil.getAttribute(attrs, "TYPE");
    var nameAttr = DomUtil.getAttribute(attrs, "NAME");
    var valueAttr = DomUtil.getAttribute(attrs, "VALUE");
    var phAttr = DomUtil.getAttribute(attrs, "PLACEHOLDER");

    var typeAttrValue = (typeAttr == null ? "" : typeAttr.value).toUpperCase();
    var nameAttrValue = (nameAttr == null ? "" : nameAttr.value);
    var valueAttrValue = (valueAttr == null ? "" : valueAttr.value);
    var phAttrValue = (phAttr == null ? "" : phAttr.value);

    try {
         if (typeAttrValue == "TEXT") {
             if(nameAttrValue == "ACCOUNTNO"){
                if(obj.hasRadio){
                    inputTextElt.setAttribute("placeholder", this.curCheckedRadio.getAttribute("data-ph"));
                }else if(phAttrValue != ""){
                    inputTextElt.setAttribute("placeholder", phAttrValue);
                }
                 inputTextElt.addEventListener("input",function(){
                     var inputstr = trim($(this).val());
                     historyDiv.style.display = "none";
                     if(inputstr.length == 0){
                         $(".history-container").show();
                         obj.confrim("stop");
                     }else{
                         $(".history-container").hide();
                         obj.confrim("go");
                     }
                 },false);

                 obj.createHistoryDiv();
             }else {
                 if((nameAttrValue == "FROMMONTH")){    //账期
                     var months = DateUtil.generateMonths();
                     $_id("paymentDays").innerHTML = months[0].month;
                     $("#paymentDaysLine").unbind("click").click(function(){
                         Dialog.showSingleChoiceDialog("请选择账期", months, obj.curCheckedBillMonthIndex, "month",
                             function(result) {
                                 obj.curCheckedBillMonthIndex = result;
                                 $_id("paymentDays").innerHTML = months[result].month;
                             }
                         );
                     });
                     obj.hasFromMonth = true;
                 }else if(nameAttrValue == "QUERYAMT"){     //缴费金额
                     obj.hasPaymentAmount = true;
                     //文本框长度有限，可能显示不完全
/*                     if(phAttrValue != ""){
                         inputAmountElt.setAttribute("placeholder", phAttrValue);
                     }*/
                 }
            }
        }else if(typeAttrValue == "RADIO"){
             obj.hasRadio = true;
             var textName = node.firstChild.data;
             var radioElt = null;
             if (textName.indexOf("户号") != -1) {
                 radioElt = $_id("queryByAccountNo");
             } else {
                 radioElt = $_id("queryByScan");
             }
             radioElt.setAttribute("data-ph", phAttrValue);

             var isChecked = "FALSE";

             var lastQType = Preference.get(SPKEY.LASTQUERYTYPE(), "");
             if(lastQType == valueAttr.value){
                 isChecked = "TRUE";
             }else if(obj.curCheckedRadio == null){
                 var checkedAttr = DomUtil.getAttribute(attrs, "CHECKED");
                 if (checkedAttr != null && checkedAttr != "") {
                     isChecked = checkedAttr.value;
                 }
             }

             if (isChecked == "TRUE") {
                 radioElt.className = "ub-f1 selected";
                 obj.currentCheckQueryType = valueAttr.value;
                 obj.curCheckedRadio = radioElt;
             } else {
                 radioElt.className = "ub-f1";
             }
         } else if (typeAttrValue == "HIDDEN") {
             if(nameAttrValue == "QUERYACCOUNTTYPE"){
                 obj.currentCheckQueryType = valueAttrValue;
             }
            var input = document.createElement("input");
            input.setAttribute("type", "hidden");
            input.setAttribute("name", nameAttr.value);
            input.setAttribute("value", valueAttr.value);
             obj.addFormInput(input);
            return input;
        }
    } catch (e) {
        console.error(e.message)
    }
}

/**
 * 绑定切换户号/条形码 事件
 */
Main.prototype.bindQueryTypeCheckEvent = function() {
    var obj = this;
    $("#queryTypePanel .ub-f1").unbind("click").bind("click", function(e){
        var qtype = $(this).attr("val");
        if(obj.currentCheckQueryType == qtype){
            return;
        }
        $(this).addClass("selected").siblings().removeClass("selected");
        obj.currentCheckQueryType = qtype;
        inputTextElt.value = "";
        inputTextElt.setAttribute("placeholder", this.getAttribute("data-ph"));
        obj.switchQueryType();
        obj.confrim("stop");
    });
}

Main.prototype.switchQueryType = function(){
    if(this.currentCheckQueryType == QUERYTYPE.SCAN){
        $_id("openScan").style.display = "block";
        $("#queryTypeDiv .c_dg").html("条形码");
    }else{
        $_id("openScan").style.display = "none";
        $("#queryTypeDiv .c_dg").html("用户号");
    }

}

Main.prototype.addFormInput = function(element) {
    this.inputNodes[this.inputNodes.length] = element;
}

Main.prototype.getFormData = function(attrs) {
    for (var i = 0; i < attrs.length; i++) {
        if (attrs[i].localName == 'ACTION') {
            this.addressUrl = attrs[i].value;
        } else if (attrs[i].localName == 'METHOD') {
            this.method = attrs[i].value;
        } else if (attrs[i].localName == 'ID') {
            this.formId = attrs[i].value;
        }
    }
}

Main.prototype.submit = function() {
    if (nDialogId != 0) {
        return;
    }
    var nodes = this.inputNodes;
    this.sendData = {};
    this.sendData["QUERYACCOUNTTYPE"] = this.currentCheckQueryType;
    for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        var typeAttr = DomUtil.getAttribute(node.attributes, "type");
        var nameAttr = DomUtil.getAttribute(node.attributes, "name");
        var valueAttr = DomUtil.getAttribute(node.attributes, "value");

        var typeAttrValue = (typeAttr == null ? "" : typeAttr.value);
        var nameAttrValue = (nameAttr == null ? "" : nameAttr.value);
        var valueAttrValue = (valueAttr == null ? "" : valueAttr.value);

        if (typeAttrValue.toUpperCase() == "HIDDEN") {
            this.sendData[nameAttr.value] = valueAttr.value;
        }
    }
    if(this.hasFromMonth){
        var val = $_id("paymentDays").innerHTML;
        val = val.replace(/[^\d]/g,"");
        this.sendData["FROMMONTH"] = val;
    }

    if(this.hasPaymentAmount){
        this.sendData["QUERYAMT"] = inputAmountElt.value;
    }

    this.sendData["ACCOUNTNO"] = inputTextElt.value;

    var params = {};
    params.productno = productNo;
    params.cityCode = this.cityCode;
    params.location = locationCode;
    params.BUSITYPE = viewData.CurrentPartner.BUSITYPE;
    params.addressUrl = this.addressUrl;
    params.addressMethod = this.method;;
    params.sendData = this.sendData;
    this.queryOrder(params);
}

Main.prototype.queryOrder = function(params) {
    var sessionKey = App.getSessionKey();
    var json = HttpUtil.getJsonHttpParams(params.addressMethod, "", sessionKey);
    var sendData = params.sendData;
    for (var x in sendData) {
        json[x] = sendData[x];
    }
    json.method = params.addressMethod;

    var obj = this;
    var query_callback = function(result) {
        DialogUtil.dismissNDialog();
        Util.Console.log(JSON.stringify(result));
        if (result == null || result == "null" || result == "") {
            Dialog.alert(SYSTEM_BUSY);
            return;
        }
        var json_result = result;
        if (json_result.ERRORCODE == "000000") {
            needfresh = true;//返回首页刷新账单列表 add 08-14
            // 将查询成功的用户号保存在SP中，下次查询时自动加载
            var key = SPKEY.LASTQUERY(); // viewData.CurrentCityCode + "-" + BUSITYPE + "-" + productNo;
            var oldnums = Preference.get(key, "");
            var newnums = obj.sendData["ACCOUNTNO"];
            Util.Console.log(["oldnews=",oldnums,", newnums=",newnums,", key=",key].join(''));
            if (oldnums.indexOf(newnums) <= -1) {	// 新户号，添加到SP中
                if (oldnums != "") {
                    Preference.put(key, oldnums + "|" + newnums);
                } else {
                    Preference.put(key, newnums);
                }
            }

            objOrderrecharge = new Orderrecharge(json_result["RESERVED"]);
            toNextPage(pageIds.billrecharge, null);
        } else {
            Util.Console.log(JSON.stringify(json_result));
            Dialog.alert(json_result.ERRORMSG);
            return;
        }
    }
    DialogUtil.showNDialog("小翼正在为您查找账单,请稍候...");
    var errorCallback = function() {
        DialogUtil.dismissNDialog();
        Dialog.alert(REQUEST_ERROR_MSG);
    };
    HttpUtil.sendRequest(this.addressUrl, json, query_callback);
}

Main.prototype.confrim = function(param){
    var obj = this;
    if(param == "go"){
        this.submitElt.className="rbtn";
        this.submitElt.onclick = function(){
            obj.submit();
        }
    }else{
        this.submitElt.className="rbtn disabled";
        this.submitElt.onclick = "";
    }
}

var isScan = false;		// 是否进入扫描界面
function suc7(result) {
    isScan = false;
    if (result == "ERROR") {
        Dialog.alert("调用摄像头权限被禁止，请手动开启！");
    } else {
        inputTextElt.value = result;
        if(inputTextElt.value == ""){
            objMain.confrim("stop");
        }else{
            objMain.confrim("go");
        }
    }
};
function err7(result) {
    Dialog.alert("扫描错误："+result)
    isScan = false;
}
function scan() {
    if (isScan) {
        return;
    }
    isScan = true;
    try {
        Scanner.scan({"PRODUCTNO":"133"},suc7,err7);
    } catch(e) {
        Dialog.alert("调用摄像头失败");
    }
}

Main.prototype.SetLocation = function() {
    $_id("paymentCityName").innerHTML = viewData.CurrentCityName;
}


/*``````````````````````````````````````````````````````````````````````````````````*/
/*```````````````````````````````````解析XML`````````````````````````````````````````*/
Main.prototype.parsePartnerListXML = function(xml) {
	var xmlDoc = DomUtil.loadXML(xml);
	
	var WRESERVEDs = xmlDoc.getElementsByTagName("WRESERVED");

	if (typeof(WRESERVEDs) != 'undefined') {
		this.partner_list = new Array();
		this.XMLParser_WRESERVED(WRESERVEDs.item(0));
	}
	var TITLEs = xmlDoc.getElementsByTagName("TITLE");
	if (typeof(TITLEs) != 'undefined') {
		this.XMLParser_TITLE(TITLEs);
	}
	var ITEMs = xmlDoc.getElementsByTagName("ITEM");

	if (typeof(ITEMs) != 'undefined') {
		this.XMLParser_ITEM(ITEMs);
	}
	var MODEs = xmlDoc.getElementsByTagName("MODE");
	if (typeof(MODEs) != 'undefined') {
		this.XMLParser_MODE(MODEs);
	}

};

Main.prototype.XMLParser_WRESERVED = function(elements) {
	var ITEMs = elements.getElementsByTagName("ITEM");
	if (typeof ITEMs != 'undefined') {
		this.XMLParser_ITEM(ITEMs);
	}
};

Main.prototype.XMLParser_TITLE = function(elements) {
	var title = elements.item(0);
	if (title != null) {
		App.setTitle(title.firstChild.data);
		appTitle["main"] = title.firstChild.data;
	}
};

Main.prototype.XMLParser_ITEM = function(notelist) {
	for (var i = 0; i < notelist.length; i++) {
		try {
			var element = notelist.item(i);
			if (typeof element == 'undefined')
				continue;
			var text = element.firstChild.data;
			this.partner_list[i] = text;
		} catch (e) {
			console.error(e.message);
		}
	}
};
Main.prototype.XMLParser_MODE = function(elements) {
};

Main.prototype.parsePartnerString = function(business) {
	var len = this.partner_list.length;
	var partners = new Array();
	var accord = false;
	for (var i = 0; i < len; i++) {
		var p = this.partner_list[i];
		var params = p.split("!");
		var partner = {
			FCD : "",
			RCD : "",
			RM : "",
			BUSITYPE : "",
			PRON : "",
			PROC : "",
			CITYN : "",
			CITYC : "",
			COMPN : "",
			COMPC : ""
		};
		Util.Console.log("params:" + params);
		for (var j = 0; j < params.length; j++) {
			Util.Console.log("param:" + params[j]);
			if (params[j].indexOf("BUSITYPE=") == 0) {
				if (params[j].length > 9) {
					var busins = params[j].substring(9);
					if (busins != business) {
						partner = null;
						break;

					}
					partner.BUSITYPE = busins;
				} else {
					partner.BUSITYPE = "";
					partner = null;
					break;
				}
			} else if (params[j].indexOf("FCD=") == 0) {
				if (params[j].length > 4) {
					partner.FCD = params[j].substring(4);
					Util.Console.log("params[j].substring(4):" + params[j].substring(4));
				} else {
					partner.FCD = "";
				}
			} else if (params[j].indexOf("RCD=") == 0) {
				if (params[j].length > 4) {
					partner.RCD = params[j].substring(4);
				} else {
					partner.RCD = "";
				}
			} else if (params[j].indexOf("RM=") == 0) {
				if (params[j].length > 3) {
					partner.RM = params[j].substring(3);
				} else {
					partner.RM = "";
				}
			} else if (params[j].indexOf("PRON=") == 0) {
				if (params[j].length > 5) {
					partner.PRON = params[j].substring(5);
				} else {
					partner.PRON = "";
				}
			} else if (params[j].indexOf("PROC=") == 0) {
				if (params[j].length > 5) {
					partner.PROC = params[j].substring(5);
				} else {
					partner.PROC = "";
				}
			} else if (params[j].indexOf("CITYN=") == 0) {
				if (params[j].length > 6) {
					partner.CITYN = params[j].substring(6);
				} else {
					partner.CITYN = "";
				}
			} else if (params[j].indexOf("CITYC=") == 0) {
				if (params[j].length > 6) {
					partner.CITYC = params[j].substring(6);
				} else {
					partner.CITYC = "";
				}
			} else if (params[j].indexOf("COMPN=") == 0) {
				if (params[j].length > 6) {
					partner.COMPN = params[j].substring(6);
				} else {
					partner.COMPN = "";
				}
			} else if (params[j].indexOf("COMPC=") == 0) {
				if (params[j].length > 6) {
					partner.COMPC = params[j].substring(6);
				} else {
					partner.COMPC = "";
				}
			} else {
				console.error("none params");
			}
		}
		if (partner != null) {
			partners[partners.length] = partner;
		}
	}
	return partners;
}


/**
 * 6.23 add 首页广告接口
 * 
 */
Main.prototype.getAppNotice=function() {
	var successCallback = function(result) {
		Util.Console.log("接口 getAppNotice:"+JSON.stringify(result));
		if (result == null || result == "" || result == '连接超时' || JSON.stringify(result) == '连接超时') {
			Util.Console.log("接口 getAppNotice:"+SYSTEM_BUSY);
			return;
		} else {
			var json_result = result;
			if (json_result.ERRORCODE == '000000') {// success
				var recordamount= result.RECORDAMOUNT;//返回列表中广告总数
				var adlist= result.ADLIST;//返回广告列表
				if(recordamount > 0 && adlist.length > 0) {		//显示广告位
					var adtext = adlist[0].ADTEXT;
					$_id("gh_notice_msg").innerHTML = adtext;
                    $_id("id_notice_div").style.display = "block";
				} else {
                    $_id("id_notice_div").style.display = "none";
				}

			} else {
                $_id("id_notice_div").style.display = "none";
				var noteMsg = json_result.ERRORMSG;
				Util.Console.log("接口 getAppNotice:"+noteMsg);
			}
		}
	};
	HttpUtil.getAppNotice(httpURL, productNo, successCallback);
}

Main.prototype.createHistoryDiv = function() {
    var obj = this;
    var key = SPKEY.LASTQUERY();
    var usernums = Preference.get(key, "");
    historyDiv.innerHTML = "";
    historyDiv.style.display = "none";

    if (usernums == "") {
        historyDiv.setAttribute("data-count", "0");
        inputTextElt.value = "";
        obj.confirm("stop");
        return;
    }

    var nums = usernums.split("|");
    historyDiv.setAttribute("data-count", nums.length + "");
    inputTextElt.value = nums[0];
    obj.confrim("go");

    if (nums.length > 1) {
        inputTextElt.onclick = function(){
            historyDiv.style.display = "block";
        }
        for (var i = 0; i < nums.length; i++) {
            var sd = document.createElement("li");
            sd.innerHTML = nums[i];
            sd.onclick = function() {
                inputTextElt.value = this.innerHTML;
                historyDiv.style.display = "none";
                obj.confrim("go");
            }
            historyDiv.appendChild(sd);
        }
        historyDiv.style.top = $("#queryTypeDiv").outerHeight() + "px";
    }
}