function Orderrecharge(xmlstring) {
	this.mode = "";
	this.step = "";
	this.title = "";
	this.text = "";
	this.confbtn= false;//add 
	this.form = {
		attrs : {},	// 表单的属性
		hiddens : [],				// 隐藏域
		texts : [],					// 文本域（对应TEXT标签）
		inputs : [],					// 对应type="text"
		checkboxs : []			// 对应type="checkbox"
	};
	
//	this.bill_recharge_container = null;
	this.text_container = null;
	this.check_container = null;
	this.amount_container = null;
	this.input_container = null;

    this.submitButton = null;
    this.amountInput = null;

	this.billsType = 0;
	this.isFirstRecord;
	this.totalMoney;			// 单位为分
	this.needMoneyInput;

    this.amountLintFirst = true;
    this.checkLineFirst = true;

	this.initContainer();
	this.parseXml(xmlstring);
}
var warnElt = null;

Orderrecharge.prototype.initContainer = function() {
	this.totalMoney = 0;
	this.needMoneyInput = false;
	this.isFirstRecord = true;

    this.text_container = $_id("br_text_container");
    this.check_container = $_id("br_check_container");
    this.amount_container = $_id("br_amount_container");
    this.input_container = $_id("br_input_container");
    this.submitButton = $_id("btnSubmitOrder");
    this.amountInput = $_id("txtPayAmount");
    warnElt = $_id("aountWarn");

    this.text_container.innerHTML = "";
    this.check_container.innerHTML = "";
    this.check_container.style.display = "none";
    this.amount_container.innerHTML = "";
    this.amountInput.value = "";

	var inputElt = document.createElement("input");
	inputElt.setAttribute("type", "hidden");
	inputElt.id = "defaultOwing";
	inputElt.value = 0;
	
	pageBillrecharge.appendChild(inputElt);
}

Orderrecharge.prototype.loadXml = function(xmlstring) {
	var oParser = new DOMParser();
	var xmlDoc = oParser.parseFromString(xmlstring, "text/xml");
	return xmlDoc;
}

Orderrecharge.prototype.parseXml = function(xmlstring) {
	var xmlDoc = this.loadXml(xmlstring);
	var root = xmlDoc.getElementsByTagName("HTML");
	if (typeof(root) == "undefined") {
		return;
	}
	var nodes = root[0].childNodes;
	for (var i = 0; i < nodes.length; i++) {
		var node = nodes[i];
		var localName = node.localName;
		if (localName == "MODE") {
			this.mode = node.firstChild.data;
		} else if (localName == "STEP") {
			this.step = node.firstChild.data;
		} else if (localName == "TITLE") {
			this.title = node.firstChild.data;
			pageTitles["_bill_recharge"] = this.title;
			App.setTitle(this.title);
		} else if (localName == "TEXT") {
			this.text = node.firstChild.data;
            this.createTextLine(this.text);
		} else if (localName == "FORM") {
			this.parseForm(node);
		}
	}
}

Orderrecharge.prototype.parseForm = function(node) {
	this.confbtn=true;// add
	// 表单属性
	var attrs = node.attributes;
	this.parseForm_attr(attrs);
	// 表单子元素
	var childNodes = node.childNodes;
	for (var i = 0; i < childNodes.length; i++) {
		if (childNodes[i].localName == 'INPUT') {
			this.parseForm_input(childNodes[i]);
		} else if (childNodes[i].localName == 'TEXT') {
			this.parseForm_text(childNodes[i]);
		}
	}
}

/**
 * 解析表单的属性
 */
Orderrecharge.prototype.parseForm_attr = function(attrs) {
	for (var i = 0; i < attrs.length; i++) {
		if (attrs[i].localName == "ACTION") {
			this.form.attrs.action = attrs[i].value;
		} else if (attrs[i].localName == 'METHOD') {
			this.form.attrs.method = attrs[i].value;
		} else if (attrs[i].localName == 'ID') {
			this.form.attrs.id = attrs[i].value;
		}
	}
}

/**
 * 解析表单的TEXT结点
 */
Orderrecharge.prototype.parseForm_text = function(node) {
	var text = node.firstChild.data;
	if (text != null && text != "") {
		this.form.texts[this.form.texts.length] = text;
	}
    this.createTextLine(text);
}

/**
 * 解析表单的INPUT结点
 */
Orderrecharge.prototype.parseForm_input = function(node) {
	var obj = this;
	
	var inputObj = new Object();
	var inputType = 0;			// 1——hidden；2——text；3——submit；4——checkbox
	var attrs = node.attributes;
	if (typeof attrs == 'undefined') {
		return null;
	}
	for (var i = 0; i < attrs.length; i++) {
		inputObj[attrs[i].localName] = (attrs[i].value != null ? attrs[i].value : "");
		if (attrs[i].localName == "TYPE" && attrs[i].value != null) {
			if (attrs[i].value == "HIDDEN") {
				inputType = 1;
			} else if (attrs[i].value == "TEXT") {
				obj.confbtn=false;// add
				inputType = 2;
			} else if (attrs[i].value == "SUBMIT") {
				inputType = 3;
			} else if (attrs[i].value == "CHECKBOX" || attrs[i].value == "RADIO") {
				inputType = 4;
			}
		}
	}
    this.billsType = 2;
	if (inputType == 1) {
		this.form.hiddens.push(this.createInputHidden(inputObj));
	} else if (inputType == 2) {
		this.form.inputs.push(inputObj);
		this.initInputText(inputObj);
	} else if (inputType == 4) {
        this.createCheckBLine(inputObj);
	} else if (inputType == 3) {
		this.initSubmit(inputObj);
	}
}

/**
 * 创建input type="hidden"结点
 */
Orderrecharge.prototype.createInputHidden = function(inputObj) {
	var input = document.createElement("input");
	for (var attr in inputObj) {
		input[attr] = inputObj[attr];
	}
	input.type = "hidden";
	return input;
}

function toInt(str, defval){
    defval = defval || 0;
    try{
        return parseInt(str);
    }catch(ex){
        return defval;
    }
}


Orderrecharge.prototype.initInputText = function(inputObj) {
    var obj = this;
	if (inputObj["TYPE"] == "TEXT" && inputObj["NAME"] == "MONEY") {
		this.needMoneyInput = true;
        this.input_container.style.display = "block";
		var size = toInt(inputObj["SIZE"], 10);
        obj.amountInput.setAttribute("maxlength", size);
        var ph_value = inputObj["PLACEHOLDER"];
        if(ph_value && $.trim(ph_value).length > 0){
            obj.amountInput.setAttribute("placeholder", ph_value);
        }else{
            obj.amountInput.setAttribute("placeholder", "请输入金额");
        }
		var rx = this;

        obj.amountInput.addEventListener("input", function() {
			var val = $(this).val();
			//控制缴费按钮状态
			var cango = trim($(this).val());
			if(cango ==""){
				obj.submitButton.className = "rbtn disabled";
                obj.submitButton.onclick="";
			}else{
                obj.submitButton.className = "rbtn";
                obj.submitButton.onclick = function(e){
                    stopDefault(e);
					rx.getOrder();
				}
			}
			
			if (val == null || val == "") {
                setWarnText("");
				return;
			}
			
			if (val == "0" || val == "0.") {
                setWarnText(HINT.CORRECT_PAYMONEY);
				return;
			}else{
                setWarnText("");
            }
			
			if (/^0.*/.test(val)) {
				if (!/^0\..*/.test(val)) {
					this.value = 0;
                    setWarnText(HINT.CORRECT_PAYMONEY);
					return;
				}
				if (!/^0\.[0-9]*$/.test(val)) {
					val = val.match(/^0\.[0-9]*/);
					this.value = val;
					if (val == "0" || val == "0.") {
                        setWarnText(HINT.CORRECT_PAYMONEY);
						return;
					}else{
                        setWarnText("")
                    }
					return;
				}
			}

			if (/^[0-9][0-9]*\.[0-9]{2}.*/.test(val)) {
				val = val.match(/^[0-9][0-9]*\.[0-9]{2}/);
				$(this).val(val);
			} else if (/^[0-9][0-9]*\.[0-9]{1}.*/.test(val)) {
				val = val.match(/^[0-9][0-9]*\.[0-9]{1}/);
				$(this).val(val);
			}
			
			if (!/^[0-9]+\.?[0-9]*$/.test(val)) {
                setWarnText(HINT.CORRECT_PAYMONEY);
				return;
			}else{
                setWarnText("");
            }
	
			var account = Math.round(parseFloat(val)  * 100);
			if (account < parseInt(rx.totalMoney)) {
                setWarnText(HINT.LEAST_PAYMONEY);
				return false;
			}else{
                setWarnText("")
            }
			
			if (account <= 0) {
                setWarnText(HINT.CORRECT_PAYMONEY);
				return false;
			}else{
                setWarnText("");
            }
		}, false);
	}
}

/**
 * 创建input type="submit"结点
 * @param {} inputObj
 */
Orderrecharge.prototype.initSubmit = function(inputObj) {
	var obj = this;
	if(this.confbtn == true){
        obj.submitButton.className = "rbtn";
        obj.submitButton.onclick = function(e) {
            stopDefault(e);
			obj.getOrder();
		};
	}else{
        obj.submitButton.className = "rbtn disabled";
	}
    obj.submitButton.innerHTML = inputObj["VALUE"];
}

Orderrecharge.prototype.createTextLine = function(text) {
    if(text == "" || text == undefined || text.indexOf("温馨提示") == 0){
        return null;
    }
    var tsp= text.split("：");
    if(tsp.length < 2){
        tsp = text.split(":");
    }
    if(tsp.length < 2){
        tsp[1] = "";
    }
    var leftText = tsp[0];
    var rightText = tsp[1];
    leftText = leftText.replace("账单欠费金额", "欠费金额");
    if(leftText.length > 4){
        return;
    }
    if(leftText.contains("当前欠费") || leftText.contains("欠费金额") || leftText.contains("账户余额") || leftText.contains("缴费金额") || leftText.contains("帐户余额") || leftText.contains("账户余额")){
        if(leftText.contains("欠费金额")){
            rightText = Util.fen2yuan($_id("defaultOwing").value) + "元";
        }
        this.createTextLine_amount(leftText, rightText);
    }else{
        this.createTextLine_text(leftText, rightText);
    }
}

Orderrecharge.prototype.createTextLine_text = function(leftText, rightText) {
    var fline = DomUtil.createDivElt("fline clearfix");
    var fnl = DomUtil.createDivElt("fnl", null, leftText+"：");
    var fnr = DomUtil.createDivElt("fnr", null, rightText);
    fline.appendChild(fnl);
    fline.appendChild(fnr);
    this.text_container.appendChild(fline);
}

Orderrecharge.prototype.createTextLine_amount = function(leftText, rightText) {
    var iline = DomUtil.createDivElt("iline clearfix" + (this.amountLintFirst ? " first" : ""));
    var inl = DomUtil.createDivElt("inl", null, leftText);
    var inr = DomUtil.createDivElt("inr", null, rightText);
    iline.appendChild(inl);
    iline.appendChild(inr);
    this.amount_container.appendChild(iline);
    this.amountLintFirst = false;
}

Orderrecharge.prototype.createCheckBLine = function(inputObj) {
    var value = inputObj["value"];
    if (value == "undefine" || value == null || value == "") {
        value = inputObj["VALUE"];
    }
    var tsp= value.split(",");
    if(tsp.length != 4){
        return null;
    }
    var data = {
        name:(inputObj.name || inputObj.NAME),
        value: value,
        month: tsp[3],
        displayMonth:getCNMonth(tsp[3]),
        oweAmount: tsp[1],
        overAmount: tsp[2],
        isFirstRecord: this.checkLineFirst
    }

    Util.fillTemplate(("#"+TEMPLATES.TEMPRESULT), TEMPLATES.CHECKLINE, data);
    var checkLine = $($_id(TEMPLATES.TEMPRESULT).innerHTML);
    var isChecked = false;
    if (!(!inputObj["checked"]) && (inputObj["checked"] == true || inputObj["checked"] == "true")) {
        isChecked = true;
    }

    // 有多账期，全部显示欠费情况，默认选中第一笔，用户只可选择任意一条缴费
    this.totalMoney = parseInt(this.totalMoney) + parseInt(data.oweAmount) + parseInt(data.overAmount);
    $_id("defaultOwing").value = this.totalMoney;

    this.isFirstRecord = false;

    var rx = this;
    var cbx = checkLine.find(".cbx");
    cbx.click(function(e) {
        stopDefault(e);
        if($(".bmain .cbx").length < 2){
            return;
        }
        var isChecked = $(this).hasClass("checked");
        $(".bmain .cbx").removeClass("checked");
        if(!isChecked){
            $(this).addClass("checked");
        }
         rx.totalMoney = parseInt(data.oweAmount) + parseInt(data.overAmount);
        $_id("defaultOwing").value = rx.totalMoney;
    });

    var more = checkLine.find(".more");
    more.click(function(e){
        stopDefault(e);
        $(this).toggleClass("exp");
        if($(this).hasClass("exp")){
            checkLine.find(".bsub").show();
        }else{
            checkLine.find(".bsub").hide();
        }
    });

    this.form.checkboxs[this.form.checkboxs.length] = cbx.get(0);
    this.checkLineFirst = false;
    this.check_container.appendChild(checkLine.get(0));
    this.check_container.style.display = "block";
    $_id(TEMPLATES.TEMPRESULT).innerHTML = "";
}

function getCNMonth(month){
    var cnm = month.substr(0,4)+"年"+month.substr(4)+"月账单";
}


/**
 * 提交支付请求，生成订单
 */
Orderrecharge.prototype.getOrder = function() {
	if (nDialogId != 0) {
		return;
	}
	// 判断checkbox选中的个数是否满足billsType的值的要求
	var billmonth = "";
	var selectedCB = new Array();
	var cbValue = "";
	var cbKey = "";
	for (var i = 0; i < this.form.checkboxs.length; i++) {
		var cb = this.form.checkboxs[i];
		if ($(cb).hasClass("checked")) {
			selectedCB[selectedCB.length] = cb;
			if (cbKey == null || cbKey == "" || cbKey == "undefined") {
				cbKey = cb.getAttribute("data-name");
			}
			cbValue += cb.getAttribute("data-value") + "|";
			billmonth += cb.getAttribute("data-month") + "$";
		}
	}
	if (cbValue != null && cbValue.charAt(cbValue.length - 1) == "|") {
		cbValue = cbValue.substring(0, cbValue.length - 1);
	}
	if (billmonth != null && billmonth.charAt(billmonth.length - 1) == "$") {
		billmonth = billmonth.substring(0, billmonth.length - 1);
	}
	Util.Console.log("当前选中的账期总数：" + selectedCB.length);
	Util.Console.log("可选择的账期总数：" + this.form.checkboxs.length);

    if (selectedCB.length > 1) {
        Util.Toast.show("只能选择一个账期，请确认");
        return;
    }
	// 判断输入的金额是否满足要求
	var money = "";
	if (this.needMoneyInput) {
		money = this.amountInput.value;
		if (money == null || money == "") {
            Util.Toast.show(HINT.CORRECT_PAYMONEY);
			return;
		} else if (money.match(/^[0-9]+\.?[0-9]{0,2}$/) == null) {
            Util.Toast.show(HINT.CORRECT_PAYMONEY);
			return;
		} else if (money.charAt(money.length - 1) == ".") {
            Util.Toast.show(HINT.CORRECT_PAYMONEY);
			return;
		} else {
			var temp = Math.round(parseFloat(money)  * 100);
			if (temp <= 0) {
                Util.Toast.show(HINT.CORRECT_PAYMONEY);
				return;
			}
		}
	}
	// 构造JSON请求参数
	var nodes = this.form.hiddens;
	var orderParams = new Array();
 	for(var i = 0; i < nodes.length; i ++) {
 		orderParams[nodes[i].NAME] = ((nodes[i].VALUE == null || nodes[i].VALUE == "undefined") ? "" : nodes[i].VALUE);
 	}
    var sessionKey = App.getSessionKey();
 	var json = HttpUtil.getJsonHttpParams(this.form.attrs.method,"",sessionKey);
 	for(x in orderParams){
 		json[x] = orderParams[x];
 	}
 	json[cbKey] = cbValue;
 	if (this.needMoneyInput) {
	 	json.MONEY = money;
 	}

	// 广州电力 单账期 需要传递BILLMONTH
 	if (this.billsType != 0 && this.billsType != "0") {
 		json.BILLMONTH = billmonth;
 	}
 	json.ID = HttpUtil.getPosSeqno(productNo);
 	
 	var obj = this;
 	var callback = function(result) {
 		if (result == null || result == "null" || result == "") {
 			Dialog.alert(SYSTEM_BUSY);
 			return;
 		}
 		var json_result = result;
		if(json_result.ERRORCODE == "000000"){
			obj.parseOrder(json_result.RESERVED);
		}else{
			Dialog.alert(json_result.ERRORMSG);
		}
 	};
 	var errorCallback = function() {
 		DialogUtil.dismissNDialog();
		Dialog.alert(REQUEST_ERROR_MSG);
 	};
 	DialogUtil.showNDialog("正在生成订单,请稍候...");
 	HttpUtil.sendRequest(this.form.attrs.action, json, callback, errorCallback);
}

Orderrecharge.prototype.parseOrder = function(xml) {
	var xmlDoc = DomUtil.loadXML(xml);
	try{
	var html = xmlDoc.getElementsByTagName("HTML");
	var form;
	var html_nodelist = html[0].childNodes;
	for(var i = 0; i < html_nodelist.length; i ++) {
		if(html_nodelist[i].localName == "FORM"){
			form = html_nodelist[i];
		};
	}
	
	Util.Console.log("form:"+form);
	var nodes = form.childNodes;
	Util.Console.log("form-nodes:"+nodes);
	var pay_json = {};

	for(var i = 0; i < nodes.length; i ++){
		var node = nodes[i];
		var attrs = node.attributes;
		
		var nameAttr = DomUtil.getAttribute(attrs,'NAME');
		var valueAttr = DomUtil.getAttribute(attrs,'VALUE');
		
		if(nameAttr == null || valueAttr == null){
			continue;
		}
		
		pay_json[nameAttr.value] = valueAttr.value;
	}	
		
	var pay_success = function(result){
		Util.Console.log(result);
		Util.Toast.show(HINT.PAY_SUCCESS);
		var pageId = pageArray[pageArray.length - 1];
		while (pageArray.length > 1) {
			back();
			pageId = pageArray[pageArray.length - 1];
		}
	};
	
	var pay_fail = function(result){
		Util.Console.log(result);
		Util.Toast.show("您已退出缴费，如有需要，可重新操作");
		var pageId = pageArray[pageArray.length - 1];
		while (pageId != pageIds.query_msg && pageId != pageIds.billlist) {
			back();
			pageId = pageArray[pageArray.length - 1];
		}
	};
	
	Payment.pay(pay_json,pay_success,pay_fail);
	}catch(e){console.error(e.message)}
};

function setWarnText(msg){
    if(msg != ""){
        warnElt.innerHTML = msg;
        warnElt.style.display = "block";
    }else{
        warnElt.innerHTML = "";
        warnElt.style.display = "none";
    }
}
