var selectAddress=function(){
    this.ProvinceLists = Util.getProvinces(viewData.CityCodeArray);
	this.init();
	this.ChangeSelectDiv();
	this.queryProvince();
	this.inputProvinceEdit();
}
/**
 * 初始化状态
 */
selectAddress.prototype.init=function(){
	$("#_id_province_text").val('');
	$("#_id_input_province").html('');
	$("#_id_uninput_province").show();
	$("#_id_input_province").hide();
}


/**
 * 当前缴费城市
 */
selectAddress.prototype.ChangeSelectDiv = function() {
	if(Util.isCityOnly(viewData.CurrentProvinceCode)){
		$_id("_id_select_province").innerHTML = viewData.CurrentCityName;
	}else{
		$_id("_id_select_province").innerHTML = viewData.CurrentProvinceName +" - " + viewData.CurrentCityName;
	}
}

/**
 * 查询所有省份
 */
selectAddress.prototype.queryProvince=function(){
	var thisObj=this;
	var List=this.ProvinceLists;
	var provinceListObj=$_id("_id_provinceList");
	provinceListObj.innerHTML="";
 	if(ValiUtil.isJsonEmpty(List)){
		return;
	}
	
	for(var i=0;i<List.length;i++){
		var ListJson=List[i];
		var codeValue=ListJson.code;
		var item_out_div = DomUtil.createDivElt("select_item_out new");
			item_out_div.setAttribute("code_id",codeValue);
		var item_cm_div = DomUtil.createDivElt("select_item_cm");
		var item_text_div = DomUtil.createDivElt("select_item_text");
			item_text_div.innerHTML=ListJson.location;
		item_cm_div.appendChild(item_text_div);
		
		if(!Util.isCityOnly(codeValue)){
			var item_arr_div=DomUtil.createDivElt("select_item_arr");
			item_cm_div.appendChild(item_arr_div);
		}
		item_out_div.appendChild(item_cm_div);
		provinceListObj.appendChild(item_out_div);
		//绑定事件
		item_out_div.onclick=function(e){
            stopDefault(e);
			var code=$(this).attr("code_id");
			var provinceName=$(this).find(".select_item_text").html();
			thisObj.toCityPage(code,provinceName);
		}
	}
}

/**
 * 省份输入框
 */
selectAddress.prototype.inputProvinceEdit=function(){
	var engine = pinyinEngine();// 初始化搜索引擎
	var thisObj=this;
	var inputobj=$_id("_id_province_text");
	var inputeditobj=$_id("_id_input_province");
	var timer;
	var oldVal = inputobj.value;
	$("#_id_province_text").blur(function(){
		var val = inputobj.value;
        if(Util.Device.isIOS){
            $(".select_top_bg").css({"position":"fixed"});
            $(".space_fixed").show();
        }

		if(val==''){
			$("#_id_uninput_province").show();
			$("#_id_input_province").hide();
		}	
	});
	$("#_id_province_text").focus(function(){
        if(Util.Device.isIOS){
            $(".select_top_bg").css({"position":"static"});
            $(".space_fixed").hide();
                                  $("body").scrollTop(0);
        }
		$("#_id_uninput_province").hide();
		$("#_id_input_province").show();

	});

	// 填充省份数据
	var tmplCache,dataList=this.ProvinceLists;
	var loadProvince = function (callback) {
		var txt = [];
		for (var i in dataList) {
			// 建立拼音查询索引缓存
			engine.setCache([dataList[i].location], dataList[i]);
		};
	};

	// 拼音快速查询
	var pinyinSearch = function (keyword, callback) {
		var txt = [];
		var len = 0;
		if (keyword === '') {
			txt = '';
		} else {
			engine.search(keyword, function (data) {
				var codeValue=data.code;
				var item_out_div = DomUtil.createDivElt("select_item_out new");
				item_out_div.setAttribute("code_id",codeValue);
				var item_cm_div = DomUtil.createDivElt("select_item_cm");
				var item_text_div = DomUtil.createDivElt("select_item_text");
				item_text_div.innerHTML=data.location;
				item_cm_div.appendChild(item_text_div);
				if(!Util.isCityOnly(codeValue)){
					var item_arr_div=DomUtil.createDivElt("select_item_arr");
					item_cm_div.appendChild(item_arr_div);
				}
				item_out_div.appendChild(item_cm_div);
				var provinceListDiv =  document.createElement("div");
				provinceListDiv.appendChild(item_out_div);
				txt.push(provinceListDiv.innerHTML);
				
				len ++;
			});
			txt = txt.join('');
			txt = txt == '' ? '<li><div class="select_item_text" align="center">无查询结果..</div></li>' : txt;
		};
		callback(txt);
	};
	
	// 绑定输入事件
	inputobj.oninput = inputobj.onpropertychange = function () {
		var val = inputobj.value;
		if (val === oldVal) return;
		oldVal = inputobj.value;
		
		clearTimeout(timer);
		timer = setTimeout(function () {
			pinyinSearch(val, function (html) {
				inputeditobj.innerHTML = html;
				//绑定事件
				$(inputeditobj).find(".select_item_out").each(function(){
					$(this).click(function(e){
                          stopDefault(e);
						var code=$(this).attr("code_id");
						var provinceName=$(this).find(".select_item_text").html();
						thisObj.toCityPage(code,provinceName);
					});
				});
			});
		}, 40); // 延时可以减小查询频率
	};
	loadProvince(function (html) {
		inputeditobj.innerHTML = html;
	});
}

/**
 * 判断省份开通情况，跳转选择城市页面
 * @param {} 省份的code 
 * @param {} 省份的名称：provinceName
 */
selectAddress.prototype.toCityPage = function(code,provinceName){
	var thisobj=this;

    if(Util.Device.isIOS){
        $(".select_top_bg").css({"position":"fixed"});
    }

	if(Util.isCityOnly(code)){
		viewData.CurrentProvinceCode=code;
		viewData.CurrentCityCode = code;
        viewData.CurrentProvinceName = provinceName;
        viewData.CurrentCityName = provinceName;
		objMain.getPartnerList(true, "address_province");
		//back();
		return;
	}
	
	$("#_id_uninput_city").show();
	$("#_id_input_city").hide();
	$("#_id_city_text").val("");
	$("#_id_input_city").html("");
    $("#_select_province").data("_scrollTop", $("body").scrollTop());

	toNextPage(pageIds.selectCity);
	App.setTitle(provinceName);
	var CityLists = Util.getCityList(code);
	var CityListObj=$_id("_id_uninput_city");
	CityListObj.innerHTML="";
    $(CityListObj).attr({"provinceName":provinceName});
	this.inputCityEdit(CityLists,code);

	if(ValiUtil.isJsonEmpty(CityLists)){
		return;
	}
	
	for(var i=0;i<CityLists.length;i++){
		var ListJson=CityLists[i];
		var codeValue=ListJson.CITYCODE;
		var codeName=ListJson.CITYNAME;
		
		var item_out_div = DomUtil.createDivElt("select_item_out new");
			item_out_div.setAttribute("code_id",codeValue);
			item_out_div.setAttribute("code_name",codeName);
		var item_cm_div = DomUtil.createDivElt("select_item_cm");
		var item_text_div = DomUtil.createDivElt("select_item_text");
			item_text_div.setAttribute("code_name",codeName);
			item_text_div.innerHTML=codeName;
		item_cm_div.appendChild(item_text_div);
		if (codeName && codeName != null && codeName.length > 8) {
			codeName = codeName.substring(0, 8) + "...";
		}
		item_out_div.appendChild(item_cm_div);

		item_out_div.onclick=function(e){
            stopDefault(e);
			var CityCode=$(this).attr("code_id");
			var CityName=$(this).attr("code_name");
			thisobj.citySelect(code,CityCode, CityName);
		}
		CityListObj.appendChild(item_out_div);
	}
}


/**
 * 城市输入框
 */
selectAddress.prototype.inputCityEdit=function(CityDataList,provincecode_this){
	var engine = pinyinEngine();// 初始化搜索引擎
	var thisObj=this;
	var inputobj=$_id("_id_city_text");
	var inputeditobj=$_id("_id_input_city");
	inputeditobj.innerHTML='';
	var timer;
	var oldVal = inputobj.value;
	$("#_id_city_text").blur(function(){
        if(Util.Device.isIOS){
            $(".select_top_bg").css({"position":"fixed"});
            $(".space_fixed").show();
        }
		var val = inputobj.value;
		if(val==''){
			$("#_id_uninput_city").show();
			$("#_id_input_city").hide();
		}	
	});
	$("#_id_city_text").focus(function(){
        if(Util.Device.isIOS){
            $(".select_top_bg").css({"position":"static"});
            $(".space_fixed").hide();
                              $("body").scrollTop(0);
        }
		$("#_id_uninput_city").hide();
		$("#_id_input_city").show();
	});

	// 填充省份数据
	var tmplCache,dataList=CityDataList;
	var loadCity = function (callback) {
		var txt = [];
		for (var i in dataList) {
			// 建立拼音查询索引缓存
			engine.setCache([dataList[i].CITYNAME], dataList[i]);
		};
	};

	// 拼音快速查询
	var pinyinSearch = function (keyword, callback) {
		var txt = [];
		var len = 0;
		if (keyword === '') {
			txt = '';
		} else {
			engine.search(keyword, function (data) {
				
				var codeValue=data.CITYCODE;
				var codeName=data.CITYNAME;
				var item_out_div = DomUtil.createDivElt("select_item_out new");
				item_out_div.setAttribute("code_id",codeValue);
				item_out_div.setAttribute("code_name",codeName);
				var item_cm_div = DomUtil.createDivElt("select_item_cm");
				var item_text_div = DomUtil.createDivElt("select_item_text");
				item_text_div.innerHTML=data.CITYNAME;
				item_cm_div.appendChild(item_text_div);
				item_out_div.appendChild(item_cm_div);
				var provinceListDiv =  document.createElement("div");
				provinceListDiv.appendChild(item_out_div);
				txt.push(provinceListDiv.innerHTML);
				
				len ++;
			});
			txt = txt.join('');
			txt = txt == '' ? '<li><div class="select_item_text" align="center">无查询结果..</div></li>' : txt;
		};
		callback(txt);
		
	};
	
	// 绑定输入事件
	inputobj.oninput = inputobj.onpropertychange = function () {
		var val = inputobj.value;
		if (val === oldVal) return;
		oldVal = inputobj.value;
		
		clearTimeout(timer);
		timer = setTimeout(function () {
			pinyinSearch(val, function (html) {
				inputeditobj.innerHTML = html;
				//绑定事件
				$(inputeditobj).find(".select_item_out").each(function(){
					
					$(this).click(function(e){
                        stopDefault(e);
						var CityCode=$(this).attr("code_id");
						var CityName=$(this).attr("code_name");
						thisObj.citySelect(provincecode_this,CityCode, CityName);
					});
					
				});
			});
		}, 40); // 延时可以减小查询频率
	};
	loadCity(function (html) {
		inputeditobj.innerHTML = html;
	});
}
/**
 * 绑定点击城市事件 
 * @param {} provincecode_this
 * @param {} citycode_this
 */
selectAddress.prototype.citySelect=function(provincecode_this,citycode_this, cityname_this){
    if(Util.Device.isIOS){
        $(".select_top_bg").css({"position":"fixed"});
        $(".space_fixed").show();
    }
    viewData.CurrentProvinceCode = provincecode_this;
    viewData.CurrentCityCode = citycode_this;
    viewData.CurrentProvinceName = $("#_id_uninput_city").attr("provinceName");
    viewData.CurrentCityName = cityname_this;
    //objMain.SetLocation();
    objMain.getPartnerList(true, "address_city");
    //back();
    //back();
}

