var REQUEST_ERROR_MSG = "网络不给力哦…"+"\n"+"请再试一下>﹏<";
var nDialogId = 0;          // 原生对话框Id
var hDialogId = "";      	// HTML5对话框Id
var hDialogBgId = "order_detail_bg";	// H5对话框背景遮罩ID

function $_id(id) {
	return document.getElementById(id);
}

//去左空格; 
function ltrim(s) {
	return s.replace(/^\s*/, "");
}
//去右空格; 
function rtrim(s) {
	return s.replace(/\s*$/, ""); 
}
//去左右空格; 
function trim(s){
	return rtrim(ltrim(s));
}

//弹出框不能滑动
function  notouchmove(event) {
	event.preventDefault();
}

function emptyFunction() { }

String.prototype.startwith = function(str) {
	var reg = new RegExp("^" + str);
	return reg.test(this);
}

function stopPropagation(event) {
	event.preventDefault();
//	event.stopPropagation();
//	return false;
}

/************************************************************************************
 * ValiUtil：数据校验相关方法
 * <br>
 * <br>1、校验JSON是否错误：isJsonEmpty
 ***********************************************************************************/
var ValiUtil = {
	/**
	 * json是否有错误
	 * @param {} json
	 * @return {Boolean} true——非法；false——合法
	 */
	isJsonEmpty : function(json) {
		if (json == null || json == "" || json == "undefined" || (typeof json != "object")) {
			return true;
		}
		return false;
	},
	
	hasErrorMsg : function(json) {
		if (json.ERRORCODE != "000000") {
			
			return true;
		}
		return false;
	},
	
	/**
	 * 判断JSON是否错误
	 * @param {} json
	 * @return {Boolean}	true——有错误；false——没错
	 */
	isJsonError : function(json) {
		if (ValiUtil.isJsonEmpty(json)) {
			Dialog.alert(REQUEST_ERROR_MSG);
			return true;
		}
		if (ValiUtil.hasErrorMsg(json)) {
			Dialog.alert(json.ERRORMSG);
			return true;
		}
		return false;
	}
};

/************************************************************************************
 * DomUtil：DOM操作相关方法
 * <br>
 * <br>1、加载XML：loadXML
 * <br>2、创建DIV DOM结点：createDivElt
 * <br>3、获取结点的属性对象：getAttribute
 ***********************************************************************************/
var DomUtil = {
	
	/**
	 * 加载XML
	 */
	loadXML : function(xml) {
		var oParser = new DOMParser();
		var xmlDoc = oParser.parseFromString(xml, "text/xml");
		return xmlDoc;
	},
	createElt:function(tag, clsName, id, txt){
        var elt = document.createElement(tag);
        if (clsName != null && clsName != "") {
            elt.className = clsName;
        }
        if (id != null) {
            elt.id = id;
        }
        if (txt != null) {
            elt.innerHTML = txt;
        } else {
            elt.innerHTML = "";
        }
        return elt;
    },
	/**
	 * 创建Div结点
	 * @param {} clsName	div节点的class属性
	 * @param {} id				div节点的id属性
	 * @param {} txt			div节点的文本内容
	 */
	createDivElt : function(clsName, id, txt) {
	    return DomUtil.createElt("div", clsName, id, txt);
	},

    createSpanElt : function(clsName, id, txt) {
        return DomUtil.createElt("span", clsName, id, txt);
    },

	getAttribute : function(attrs, localName) {
		if (attrs == null) {
			return null;
		}
		for (var i = 0; i < attrs.length; i++) {
			var attr = attrs[i];
			var name = attr.localName.toUpperCase();
			if (name == localName.toUpperCase()) {
				return {
					"localName" : name,
					"value" : attr.value
				};
			}
		}
		return null;
	}
};

/************************************************************************************
 * HttpUtil：Http请求相关方法
 * <br>
 * <br>1、构造公共请求参数：getJsonHttpParams
 * <br>2、发送AJAX请求：sendRequest
 ***********************************************************************************/
var HttpUtil = {
	
	KEEP:0,
	VERSION :"000001",
	
	/**
	 * 返回系统请求参数(SYSREQ)
	 * @param method 		方法名称
	 * @param encrypt 		加密方式
	 * @param sessionkey 	用户会话码
	 * @return List<NameValuePair> 返回类型
	 */
	getJsonHttpParams : function(method, encrypt, sessionkey) {
		var json_params = {};
		json_params.method = method;
		json_params.encrypt = encrypt;
		json_params.timestamp = HttpUtil.getTimeStamp();
		json_params.sessionkey = sessionkey;
		json_params.v = Util.VERSION;
		json_params.sig = "";
		return json_params;
	},
    getJsonHttpParams_dx : function(method, encrypt, sessionkey) {
        var json_params = {};
        json_params.METHOD = method;
        json_params.ENCRYPT = encrypt;
        json_params.TIMESTAMP = HttpUtil.getTimeStamp();
        json_params.SESSIONKEY = sessionkey;
        json_params.V = Util.VERSION;
        json_params.SIG = "";
        return json_params;
    },
	/**
	 * 生成时间戳并返回,也可认为是呼叫序列号。格式为SSSSSS 
	 * 例如:003031。SSSSSS为客户端生成的序列号，每次接口调用时增加1。
	 * 在同一个用户会话状态下请求传递的SSSSSS需保证递增)
	 * @return String 返回类型
	 */
	getTimeStamp : function() {
		HttpUtil.KEEP++;
		var result = HttpUtil.KEEP + "";
		switch (result.length) {
		case 1 :
			result = "00000" + result;
			break;
		case 2 :
			result = "0000" + result;
			break;
		case 3 :
			result = "000" + result;
			break;
		case 4 :
			result = "00" + result;
			break;
		case 5 :
			result = "0" + result;
			break;
		case 6 :
			result = result;
			break;
		}
		return result;
	},
	
	/**
	 * 收银台流水号
	 * @param @return 设定文件
	 * @return String 返回类型
	 * @author luyi
	 * @date 2011-4-11 上午10:19:13 生成规则：手机生成的收银台流水号。流水号编码规则：收银台手机号后4位 +
	 *       yymmddhhmmss + 3位序列数。 业务管理平台必须判断收银台流水号的唯一性。
	 */
	getPosSeqno : function(productNo) {
		var phone;
		if (productNo.length == 11) {
			phone = productNo.substring(productNo.length - 4, productNo.length);
		}
		else {
			phone = "0293";
		}
		var time = HttpUtil.getCustomerTime();
		return phone + time + HttpUtil.get_KEEP_03d_format();
	},
	
	/**
	 * 返回当前时间的自定义格式
	 * @param @param model 时间格式 如：yymmddhhmmss
	 * @param @return 设定文件
	 * @return String 返回 当前时间字符串
	 */
	getCustomerTime : function() {
		var date = new Date();
		var yy, MM, dd, hh, mm, ss;
		yy = (date.getYear() + "").substr(1, 2);

		MM = (date.getMonth() + 1) + "";
		MM = MM.length < 2 ? "0" + MM : MM;

		dd = (date.getDate()) + "";
		dd = dd.length < 2 ? "0" + dd : dd;

		hh = (date.getHours() + 1) + "";
		hh = hh.length < 2 ? "0" + hh : hh;

		mm = (date.getMinutes() + 1) + "";
		mm = mm.length < 2 ? "0" + mm : mm;

		ss = (date.getSeconds() + 1) + "";
		ss = ss.length < 2 ? "0" + ss : ss;

		return yy + MM + dd + hh + mm + ss;
	},
	
	/**
	 * 以%03d的格式格式化KEEP
	 */
	get_KEEP_03d_format : function() {
		var t = HttpUtil.KEEP % 1000;
		if (t != 0) {
			t--;
		}
		var tmp = t + "";
		switch (tmp.length) {
		case 1 :
			tmp = "00" + tmp;
			break;
		case 2 :
			tmp = "0" + tmp;
			break;
		case 3 :
			tmp = tmp;
			break;
		default :
			tmp.substr(tmp.length - 4, tmp.length - 1);
			break;
		}
		return tmp;
	},
	
	/**
	 * 发送AJAX请求
	 * @param {} requestUrl
	 * @param {} params
	 * @param {} success_callback
	 * @param {} error_callback
	 * @param {} exception_callback
	 */
	sendRequest : function(requestUrl, params, successCallback, errorCallback) {
        this.sendPostRequest(requestUrl, params, successCallback, errorCallback);
	},
	
	/**
	 * 发送HTTP POST请求
	 * @param {} requestUrl	请求URL
	 * @param {} params			请求参数
	 * @param {} successCallback	成功时的回调函数
	 */
	sendPostRequest : function(requestUrl, params, successCallback, errorCallback) {
	    Util.Console.log("requestUrl : " + requestUrl);
	    var name = "ran" + Math.floor(Math.random() * 100 + 1);
		var value = Date.parse(new Date()); 
		requestUrl = requestUrl + "?" + name + "=" + value;
	    Util.Console.log("[" + params.method + " request] : "+JSON.stringify(params));
	    if (errorCallback == null || errorCallback == "undefined") {
	    	errorCallback = function(XMLHttpRequest, textStatus, errorThrown) {
	    		DialogUtil.dismissNDialog();
	    		Dialog.alert(REQUEST_ERROR_MSG);
	    		console.error("[" + params.method + " request error] : " + JSON.stringify(XMLHttpRequest) + " : " + requestUrl);
				handleException();
				return;
	    	};
	    }
		try {
			$.ajax({
				url : requestUrl,
				type : "POST",
				data : params,
				timeout : 60000,
				dataType : "json",
				async : true,
				success : function(json) {
					Util.Console.log("[" + params.method + " response] : "+JSON.stringify(json));
					successCallback.call(null, json);
					DialogUtil.dismissNDialog();
				},
				error: errorCallback
			});
		} catch (e) {
			errorCallback();
		}
	},
    getAppNotice : function(requestUrl, productNo, successCallback) {
        var json_params = HttpUtil.getJsonHttpParams("getappadlist", "", "");
        json_params.APPCODE =APPID;//应用ID

        var errorCallback = function() {
            console.error("error广告获取失败:");
        };

        HttpUtil.sendRequest(requestUrl, json_params, successCallback, errorCallback);
    }
}


/************************************************************************************
 * DialogUtil：对话框相关方法封装
 * <br>
 * <br>1、显示原生对话框：showNDialog
 * <br>2、关闭原生对话框：dismissNDialog
 * <br>3、设置H5对话框TOP值：setDialogHeight
 * <br>4、显示H5对话框背景遮罩：showDialogBg
 * <br>5、关闭H5对话框（需要自己实现）：closeHDialog
 ***********************************************************************************/
var DialogUtil = {
	
	/**
	 * 显示原生对话框
	 */
	showNDialog : function(msg) {
		DialogUtil.dismissNDialog();
		if (msg == null || msg == "") {
			msg = "小翼正在为您查找账单,请稍候...";
		}
		nDialogId = Dialog.showProgressDialog("", msg);
	},
	
	/**
	 * 关闭原生对话框
	 */
	dismissNDialog : function() {
		if (nDialogId != 0) {
			Dialog.dismissDialog(nDialogId);
			nDialogId = 0;
		}
	},
	
	/**
	 * 设置HTML5对话框距离顶部的高度
	 * @param {} dialogId	HTML5对话框的id
	 * @param {} dHeigth	HTML5对话框自身的高度
	 */
	setDialogHeight : function(dialogId, dHeigth) {
        $("#" + dialogId).css({
          "top": "45%",
          "marginTop": -(dHeigth / 2) + "px"
        });
	},
	
	/**
	 * 显示HTML5对话框背景遮罩
	 */
	showDialogBg : function() {
		var bgHeight = (Math.max(document.documentElement.scrollHeight, 
			document.documentElement.clientHeight)) + 'px';
		document.getElementById(hDialogBgId).style.height = bgHeight;
		document.getElementById(hDialogBgId).style.display = "block";
//		var bgHeight =document.body.scrollTop+"px";
//		document.getElementById(hDialogBgId).style.top = bgHeight;
//		document.getElementById(hDialogBgId).style.display = "block";

	},
	
	/**
	 * 显示HTML5对话框
	 * @param {} divId		对话框ID	 */
	showHDialog : function(divId) {
		hDialogId = divId;
        var dHeigth = $("#" + divId).innerHeight();
		DialogUtil.setDialogHeight(divId, dHeigth);
		DialogUtil.showDialogBg();
		$_id(divId).style.display = "block";
		$("body").css("overflow", "hidden");
	},
	
	/**
	 * 关闭HTML5对话框
	 */
	closeHDialog : function() {
		if (hDialogId != "") {
			$_id(hDialogId).style.display = "none";
		}
		$_id(hDialogBgId).style.display = "none";
		hDialogId = "";
		$("body").css("overflow", "auto");
		return;
	}
};


/************************************************************************************
 * Util：其他公共方法
 * <br>
 * <br>1、屏幕适配：screenAdapt
 * <br>2、省市代码相关方法：GetProviceCode、GetCityCode、isCityOnly、getProvinces、getProvince
 * <br>3、分转换为元：fen2yuan
 ***********************************************************************************/
var Util = {
	
	/**
	 * 获取设备的分辨率，设置页面meta的viewport属性，完成自适应
	 */
	screenAdapt : function() {
		if (screenSize != null && screenSize != "" ){
			var arr = screenSize.split("x");
			if (arr.length == 2) {
				deviceWidth = arr[0];
				deviceHeight = arr[1];
			}
		}
		var densitydpi = uiWidth / deviceWidth * window.devicePixelRatio * 160;
		var initialScale = deviceWidth / uiWidth;
		var targetDensitydpi = "";
		// Android or iOS ？
		Util.Console.log("当前浏览器版本： " + navigator.appVersion);
		if ((/android/gi).test(navigator.appVersion)) {
			targetDensitydpi = 'target-densitydpi=' + densitydpi + ', width=device-width, user-scalable=no';
		} else {
			targetDensitydpi = 'target-densitydpi=' + densitydpi + ', width=device-width, user-scalable=no, initial-scale=' + initialScale;
		}
		document.getElementsByName('viewport')[0].setAttribute( 'content', targetDensitydpi);
		Util.Console.log("完成终端适配");
		return;
	},
	
	/**
	 * 根据位置代码获取省代码
	 * @param {} locationCode	位置代码
	 * @return {String}		省代码
	 */
	GetProviceCode : function(locationCode) {
		if (locationCode == "01")// 北京
			return "110000";
		else if (locationCode == "02")// 上海
			return "310000";
		else if (locationCode == "03")// 天津
			return "120000";
		else if (locationCode == "04")// 重庆
			return "500000";
		else if (locationCode == "05")// 河北
			return "130000";
		else if (locationCode == "06")// 山西
			return "140000";
		else if (locationCode == "07")// 内蒙古
			return "150000";
		else if (locationCode == "08")// 辽宁
			return "210000";
		else if (locationCode == "09")// 吉林
			return "220000";
		else if (locationCode == "10")// 10 黑龙江
			return "230000";
		else if (locationCode == "11")// 江苏
			return "320000";
		else if (locationCode == "12")// 浙江
			return "330000";
		else if (locationCode == "13")// 安徽
			return "340000";
		else if (locationCode == "14")// 福建
			return "350000";
		else if (locationCode == "15")// 江西
			return "360000";
		else if (locationCode == "16")// 山东
			return "370000";
		else if (locationCode == "17")// 河南
			return "410000";
		else if (locationCode == "18")// 湖北
			return "420000";
		else if (locationCode == "19")// 湖南
			return "430000";
		else if (locationCode == "20")// 广东
			return "440000";
		else if (locationCode == "21")// 广西
			return "450000";
		else if (locationCode == "22")// 海南
			return "460000";
		else if (locationCode == "23")// 四川
			return "510000";
		else if (locationCode == "24")// 贵州
			return "520000";
		else if (locationCode == "25")// 云南
			return "530000";
		else if (locationCode == "26")// 西藏
			return "540000";
		else if (locationCode == "27")// 陕西
			return "610000";
		else if (locationCode == "28")// 甘肃
			return "620000";
		else if (locationCode == "29")// 青海
			return "630000";
		else if (locationCode == "30")// 宁夏
			return "640000";
		else if (locationCode == "31")// 新疆
			return "650000";
		else if (locationCode == "32")// 台湾
			return "710000";
		else if (locationCode == "33")// 香港
			return "810000";
		return "910000";// 澳门
	},

    getProvinceName:function(code){
        return pcnJson[code];
    },

    isOpenCity:function(code){
        var len = viewData.CityCodeArray.length;
        for(var i=0; i<len; i++){
            if(code == viewData.CityCodeArray[i]){
                return true;
            }
        }
        return false;
    },
	
	/**
	 * 根据位置代码，获取城市代码
	 * @param {} locationCode	位置代码
	 * @return {String}			城市代码
	 */
	GetCityCode : function(locationCode) {
		if (locationCode == "01")// 北京
			return "110000";
		else if (locationCode == "02")// 上海
			return "310000";
		else if (locationCode == "03")// 天津
			return "120000";
		else if (locationCode == "04")// 重庆
			return "500000";
		else if (locationCode == "05")// 河北
			return "130100";
		else if (locationCode == "06")// 山西
			return "140100";
		else if (locationCode == "07")// 内蒙古
			return "150100";
		else if (locationCode == "08")// 辽宁
			return "210100";
		else if (locationCode == "09")// 吉林
			return "220100";
		else if (locationCode == "10")// 10 黑龙江
			return "230100";
		else if (locationCode == "11")// 江苏
			return "320100";
		else if (locationCode == "12")// 浙江
			return "330100";
		else if (locationCode == "13")// 安徽
			return "340100";
		else if (locationCode == "14")// 福建
			return "350100";
		else if (locationCode == "15")// 江西
			return "360100";
		else if (locationCode == "16")// 山东
			return "370100";
		else if (locationCode == "17")// 河南
			return "410100";
		else if (locationCode == "18")// 湖北
			return "420100";
		else if (locationCode == "19")// 湖南
			return "430100";
		else if (locationCode == "20")// 广东
			return "440100";
		else if (locationCode == "21")// 广西
			return "450100";
		else if (locationCode == "22")// 海南
			return "460100";
		else if (locationCode == "23")// 四川
			return "510100";
		else if (locationCode == "24")// 贵州
			return "520100";
		else if (locationCode == "25")// 云南
			return "530100";
		else if (locationCode == "26")// 西藏
			return "540100";
		else if (locationCode == "27")// 陕西
			return "610100";
		else if (locationCode == "28")// 甘肃
			return "620100";
		else if (locationCode == "29")// 青海
			return "630100";
		else if (locationCode == "30")// 宁夏
			return "640100";
		else if (locationCode == "31")// 新疆
			return "650100";
		else if (locationCode == "32")// 台湾
			return "710000";
		else if (locationCode == "33")// 香港
			return "810000";
		return "910000";// 澳门
	},
	
	/**
	 * 判断某个城市是否没有省
	 * @param {} city_code	城市代码
	 * @return {Boolean}
	 */
	isCityOnly : function(city_code) {
		if (city_code == "110000" 	// 北京市
			|| city_code == "120000"// 天津市
			|| city_code == "310000"// 上海市
			|| city_code == "500000"// 重庆市
			|| city_code == "710000"// 台湾省
			|| city_code == "810000"// 香港特别行政区
			|| city_code == "820000"// 澳门特别行政区
		) {
			return true;
		} else {
			return false;
		}
	},
	
	/**
	 * 获取有开通城市的省
	 * @param {} citystrings 开通城市代码列表
	 */
	getProvinces : function(citystrings) {
		var provinces = new Array();
		for (var i = 0; i < citystrings.length; i++) {
			var province = Util.getProvince(citystrings[i]);
			if (typeof(province) == 'undefined')
				continue;
			// 过滤重复province
			var containt = false;

			for (var j = 0; j < provinces.length; j++) {
				if (provinces[j].code == province.code) {
					containt = true;
					break;
				}
			}
			if (!containt) {
				provinces[provinces.length] = province;
			}
		}
		return provinces;
	},
	
	/**
	 * 根据城市代码获取省的信息
	 * @param {} citycod 城市代码
	 * @return {}	省的信息
	 */
	getProvince : function(citycod) {
		var citycode = citycod + "";
		if (citycode.startwith("11")) {			// 北京
			return {
				code : "110000",
				location : '北京'
			};
		} else if (citycode.startwith("31")) { // 上海
			return {
				code : "310000",
				location : '上海'
			};
		} else if (citycode.startwith("12")) {	// 天津
			return {
				code : "120000",
				location : '天津'
			};
		} else if (citycode.startwith("50")) { // 重庆
			return {
				code : "500000",
				location : '重庆'
			};
		} else if (citycode.startwith("13")) {	// 河北
			return {
				code : "130000",
				location : '河北'
			};
		} else if (citycode.startwith("14")) {// 山西
			return {
				code : "140000",
				location : '山西'
			};
		} else if (citycode.startwith("15")) {	// 内蒙古
			return {
				code : "150000",
				location : '内蒙古'
			};
		} else if (citycode.startwith("21")) {	// 辽宁
			return {
				code : "210000",
				location : '辽宁'
			};
		} else if (citycode.startwith("22")) {	// 吉林
			return {
				code : "220000",
				location : '吉林'
			};
		} else if (citycode.startwith("23")) { // 10 黑龙江
			return {
				code : "230000",
				location : '黑龙江'
			};
		} else if (citycode.startwith("32")) {	// 江苏
			return {
				code : "320000",
				location : '江苏'
			};
		} else if (citycode.startwith("33")) {	// 浙江
			return {
				code : "330000",
				location : '浙江'
			};
		} else if (citycode.startwith("34")) { // 安徽
			return {
				code : "340000",
				location : '安徽'
			};
		} else if (citycode.startwith("35")) { // 福建
			return {
				code : "350000",
				location : '福建'
			};
		} else if (citycode.startwith("36")) { // 江西
			return {
				code : "360000",
				location : '江西'
			};
		} else if (citycode.startwith("37")) { // 山东
			return {
				code : "370000",
				location : '山东'
			};
		} else if (citycode.startwith("41")) { // 河南
			return {
				code : "410000",
				location : '河南'
			};
		} else if (citycode.startwith("42")) { // 湖北
			return {
				code : "420000",
				location : '湖北'
			};
		} else if (citycode.startwith("43")) { // 湖南
			return {
				code : "430000",
				location : '湖南'
			};
		} else if (citycode.startwith("44")) { // 广东
			return {
				code : "440000",
				location : '广东'
			};
		} else if (citycode.startwith("45")) { // 广西
			return {
				code : "450000",
				location : '广西'
			};
		} else if (citycode.startwith("46")) { // 海南
			return {
				code : "460000",
				location : '海南'
			};
		} else if (citycode.startwith("51")) { // 四川
			return {
				code : "510000",
				location : '四川'
			};
		} else if (citycode.startwith("52")) { // 贵州
			return {
				code : "520000",
				location : '贵州'
			};
		} else if (citycode.startwith("53")) { // 云南
			return {
				code : "530000",
				location : '云南'
			};
		} else if (citycode.startwith("54")) { // 西藏
			return {
				code : "540000",
				location : '西藏'
			};
		} else if (citycode.startwith("61")) { // 陕西
			return {
				code : "610000",
				location : '陕西'
			};
		} else if (citycode.startwith("62")) { // 甘肃
			return {
				code : "620000",
				location : '甘肃'
			};
		} else if (citycode.startwith("63")) { // 青海
			return {
				code : "630000",
				location : '青海'
			};
		} else if (citycode.startwith("64")) { // 宁夏
			return {
				code : "640000",
				location : '宁夏'
			};
		} else if (citycode.startwith("65")) { // 新疆
			return {
				code : "650000",
				location : '新疆'
			};
		} else if (citycode.startwith("71")) { // 台湾
			return {
				code : "710000",
				location : '台湾'
			};
		} else if (citycode.startwith("81")) { // 香港
			return {
				code : "810000",
				location : '香港'
			};
		} else if (citycode.startwith("91")) { // 澳门
			return {
				code : "910000",
				location : '澳门'
			};
		}
	},

    getCityList:function(provinceCode){
        var startCode = provinceCode.substr(0,2);
        var len = viewData.CityList.length;
        var cityList = new Array();
        for(var i=0;i<len;i++){
            if(viewData.CityList[i].CITYCODE.startwith(startCode)){
                cityList.push(viewData.CityList[i]);
            }
        }
        return cityList;
    },
	fen2yuan : function(fen) {
		if (fen == 0 || fen == "0") {
			return "0.00";
		}
		var f = fen.substring(fen.length-2);
	    var y = fen.substring(0,fen.length-2);
	    return y + "." + f; 
	},

    Console:{
        log:function(msg){
            if(isDev){
                console.log(msg);
            }
        }
    },

    fillTemplate: function (fele, furl, fdata){
        return $(fele).setTemplateURL(furl).processTemplate(fdata);
    },

    fillTemplateWithParams: function (fele, furl, fdata, fparams){
        var _ele = $(fele);
        _ele.setTemplateURL(furl);
        $.each(fparams, function(k){
            _ele.setParam(k, fparams[k]);
        })
        _ele.processTemplate(fdata);
        return _ele;
    },

    /************************************************************************************
     * Toast：仿Android Toast消息
     * <br>
     * <br> 1、显示toast：show
     ***********************************************************************************/
    Toast:{
        toastTimeout:null,
        /**
         * 显示Toast消息
         * @param 消息内容
         * @param  持续时间，默认2秒
         */
        show: function(_msg, _dur){
            var _duration = _dur || 2;
            var toastBox = $("#toastBox");
            if (toastBox.length == 0) {
                $("body").append("<div id='toastBox'><p></p></div>");
                toastBox = $("#toastBox");
            }
            toastBox.find("p").html(_msg);
            toastBox.css("left", $(document).width() / 2 - toastBox.innerWidth() / 2).show();

            if(Util.Toast.toastTimeout){
                clearTimeout(Util.Toast.toastTimeout);
                Util.Toast.toastTimeout = null;
            }
            Util.Toast.toastTimeout = setTimeout(function () {
                toastBox.fadeOut(300);
            }, _duration * 1000);
        }
    },
    Device:{
        isIOS:function(){
            var ver = Util.Device.versions();
            return (ver.ios || ver.iPhone || ver.iPad);
        },
        versions: function() {
            var u = navigator.userAgent, app = navigator.appVersion;
            return {//移动终端浏览器版本信息
                trident: u.indexOf('Trident') > -1, //IE内核
                presto: u.indexOf('Presto') > -1, //opera内核
                webKit: u.indexOf('AppleWebKit') > -1, //苹果、谷歌内核
                gecko: u.indexOf('Gecko') > -1 && u.indexOf('KHTML') == -1, //火狐内核
                mobile: !!u.match(/AppleWebKit.*Mobile.*/) || !!u.match(/AppleWebKit/), //是否为移动终端
                ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
                android: u.indexOf('Android') > -1 || u.indexOf('Linux') > -1, //android终端或者uc浏览器
                iPhone: u.indexOf('iPhone') > -1 || u.indexOf('Mac') > -1, //是否为iPhone或者QQHD浏览器
                iPad: u.indexOf('iPad') > -1, //是否iPad
                webApp: u.indexOf('Safari') == -1 //是否web应该程序，没有头部与底部
            };
        }
    }
};


var DateUtil = {
	
	getNoticeTime : function(selectDate) {
		if (selectDate == 0 || selectDate == "0" || selectDate == "" || selectDate == null) {
			return "";
		}
		var curDate = new Date();
		var yy = curDate.getFullYear();
		var mm = "";
		var dd = curDate.getDate();
		if (selectDate < dd) {
			mm = DateUtil.changeMonth(curDate.getMonth() + 1);
			if (mm == "01") {
				yy = yy + 1;
			}
		} else {
			mm = DateUtil.changeMonth(curDate.getMonth());
		}
		if ((selectDate + "").length == 1) {
			selectDate = "0" + selectDate;
		}
		return yy + mm + selectDate;
	},
	
	changeMonth : function(month) {
		var retValue = "00";
		switch (month) {
			case 0 :
			case 12 :
				retValue = "01";
				break;
			case 1 :
				retValue = "02";
				break;
			case 2 :
				retValue = "03";
				break;
			case 3 :
				retValue = "04";
				break;
			case 4 :
				retValue = "05";
				break;
			case 5 :
				retValue = "06";
				break;
			case 6 :
				retValue = "07";
				break;
			case 7 :
				retValue = "08";
				break;
			case 8 :
				retValue = "09";
				break;
			case 9 :
				retValue = "10";
				break;
			case 10 :
				retValue = "11";
				break;
			case 11 :
				retValue = "12";
				break;
		}
		return retValue;
	},
	
	/**
	 * 生成账期下拉选项
	 */
	generateMonths : function() {
		var months = new Array();
		var curDate = new Date();
		var curMonth = curDate.getMonth() + 1;
		var curYear = curDate.getFullYear();
		for (var i = curMonth; i > 0; i--) {
			if ((i + "").length == 1) {
				months.push({"month" : curYear + "-0" + i});
			} else {
				months.push({"month" : curYear + "-" + i});
			}
		}
		var last = 12 - curMonth;
		for (var i = 12; i > curMonth; i--) {
			if ((i + "").length == 1) {
				months.push({"month" : (curYear - 1) + "-0" + i});
			} else {
				months.push({"month" : (curYear - 1) + "-" + i});
			}
		}
		return months;
	}
};

String.prototype.contains = function(t){return this.indexOf(t) >= 0}

var pcnJson = {
    "110000":"北京",
    "310000":"上海",
    "120000":"天津",
    "500000":"重庆",
    "130000":"河北",
    "140000":"山西",
    "150000":"内蒙古",
    "210000":"辽宁",
    "220000":"吉林",
    "230000":"黑龙江",
    "320000":"江苏",
    "330000":"浙江",
    "340000":"安徽",
    "350000":"福建",
    "360000":"江西",
    "370000":"山东",
    "410000":"河南",
    "420000":"湖北",
    "430000":"湖南",
    "440000":"广东",
    "450000":"广西",
    "460000":"海南",
    "510000":"四川",
    "520000":"贵州",
    "530000":"云南",
    "540000":"西藏",
    "610000":"陕西",
    "620000":"甘肃",
    "630000":"青海",
    "640000":"宁夏",
    "650000":"新疆",
    "710000":"台湾",
    "810000":"香港",
    "910000":"澳门"
}

//停止事件冒泡
function stopDefault(event){
    event.preventDefault();
    event.stopPropagation();
}

var WEBDB = {
	db:null,
	db_ver: '2.0',
	db_name: 'bestpay_h5_database',
	db_size: 2 * 1024,
	isSupport: true,

	/**
	 * 将值转换成SQL拼接的字符
	 * @param v
	 */
	convertValue:function(v){
		if(typeof v == 'number'){
			return v;
		}else{
			return "'" + v + "'";
		}
	},

	/**
	 * 将SQL查询结果转换成JSON
	 * @param datas
	 */
	convertResult:function(datas){
		var len = datas.rows.length, i;
		var resultAry = [];
		for (i = 0; i < len; i++){
			resultAry.push(datas.rows.item(i));
		}
		return resultAry;
	},

	/**
	 * 打开数据库/如不存在则创建
	 */
	openDb: function(){
		if(!WEBDB.db){
			try{
				WEBDB.db = openDatabase(WEBDB.db_name, WEBDB.db_ver, 'bestpay h5 webapp database', WEBDB.db_size);
				WEBDB.isSupport = true;
			}catch(ex){
				WEBDB.isSupport = false;
			}
		}
	},

	/**
	 * 创建表
	 * @param table_name	表名
	 * @param columns	列-列表，以,分隔的字符串
	 */
	createTable: function(table_name, columns){
		WEBDB.openDb();
		if(WEBDB.isSupport){
			WEBDB.db.transaction(function (tx) {
				var sql = ['CREATE TABLE IF NOT EXISTS ', table_name, '(', columns, ')'].join('');
				Utils.Console.log(["webdb createTable sql: ", sql].join(''));
				tx.executeSql(sql);
			});
		}
	},

	/**
	 * 插入数据
	 * @param table_name	表名
	 * @param columns	列-列表，数组，如：["id", "name"]
	 * @param values	值-列表，数组，如：[1, "添益宝"]
	 */
	insert: function(table_name, columns, values){
		WEBDB.openDb();
		if(WEBDB.isSupport){
			WEBDB.db.transaction(function (tx) {
				if(!columns || columns.length == 0){
					columns = "*";
				}else{
					columns = columns.join(',');
				}
				var valueStr = '';
				for(var i in values){
					var v = values[i];
					valueStr += WEBDB.convertValue(v) + ",";
				}
				valueStr = valueStr.substr(0, valueStr.length - 1);
				var sql = ['INSERT INTO ',table_name,'(', columns ,')',' VALUES(', valueStr, ')'].join('');
				Utils.Console.log(["webdb insert sql: ", sql].join(''));
				tx.executeSql(sql);
			});
		}else{
			var pKey = [table_name,'_',values[0]].join('');
			Preference.put(pKey, values[1]);
			Utils.Console.log(["pref insert data: ", pKey].join(''));
		}
	},

	/**
	 * 查询所有数据
	 * @param table_name	表名
	 * @param callback	查询成功后的回调函数
	 */
	getAll: function(table_name, callback){
		WEBDB.openDb();
		if(WEBDB.isSupport) {
			WEBDB.db.transaction(function (tx) {
				var sql = ['SELECT * FROM ', table_name].join('');
				Utils.Console.log(["webdb getAll sql: ", sql].join(''));
				tx.executeSql(sql, [], function (tx, result) {
					if (callback) {
						var res = WEBDB.convertResult(result);
						callback(res);
					}

				});
			});
		}else{
			if (callback) {
				callback([]);
			}
		}
	},

	/**
	 * 按条件查询
	 * @param table_name	表名
	 * @param condition	条件，如：id=1 and name="goods"
	 * @param callback	查询成功后的回调函数
	 */
	get: function(table_name, condition, callback){
		WEBDB.openDb();
		if(WEBDB.isSupport) {
			WEBDB.db.transaction(function (tx) {
				if (condition) {
					condition = ' WHERE ' + condition;
				}
				var sql = ['SELECT * FROM ', table_name, condition].join('');
				Utils.Console.log(["webdb get sql: ", sql].join(''));
				tx.executeSql(sql, [], function (tx, result) {
					if (callback) {
						var res = WEBDB.convertResult(result);
						callback(res);
					}

				});
			});
		}else{
			var rgx = /['"](.+)['"]/g;
			if(rgx.test(condition)){
				var prefKey = [table_name,'_', RegExp.$1].join('');
				var prefVal = Preference.get(prefKey, "");
				Utils.Console.log(["pref get data: ", prefKey].join(''));
				var result = [];
				if(prefVal) {
					result = [{"m_data": prefVal}];
				}
				if(callback){
					callback(result);
				}
			}
		}
	},

	/**
	 * sql 查询
	 * @param sql	查询语句
	 * @param callback	查询成功后的回调函数
	 */
	query: function(sql, callback){
		WEBDB.openDb();
		if(WEBDB.isSupport) {
			WEBDB.db.transaction(function (tx) {
				Utils.Console.log(["webdb query sql: ", sql].join(''));
				tx.executeSql(sql, [], function (tx, result) {
					if (callback) {
						var res = WEBDB.convertResult(result);
						callback(res);
					}
				});
			});
		}else{
			if (callback) {
				callback([]);
			}
		}
	},

	/**
	 * 删除数据
	 * @param table_name	表名
	 * @param callback	条件
	 */
	delete: function(table_name, condition){
		WEBDB.openDb();
		if(WEBDB.isSupport) {
			WEBDB.db.transaction(function (tx) {
				if (condition) {
					condition = ' WHERE ' + condition;
				}
				var sql = ['DELETE FROM ', table_name, condition].join('');
				Utils.Console.log(["webdb delete sql: ", sql].join(''));
				tx.executeSql(sql);
			});
		}else{
			var rgx = /['"](.+)['"]/g;
			if(rgx.test(condition)){
				var prefKey = RegExp.$1;
				Preference.put(prefKey, "");
			}
		}
	},

	/**
	 *	更新一条数据
	 * @param table_name	表名
	 * @param column_name	列名
	 * @param column_value	更新值
	 * @param condition	条件
	 */
	update:function(table_name, column_name, column_value, condition){
		WEBDB.openDb();
		if(WEBDB.isSupport) {
			WEBDB.db.transaction(function (tx) {
				if (condition) {
					condition = ' WHERE ' + condition;
				}
				var sql = ['UPDATE ', table_name, ' SET ', column_name, '=',
					WEBDB.convertValue(column_value), condition].join('');
				Utils.Console.log(["webdb update sql: ", sql].join(''));
				tx.executeSql(sql);
			});
		}else{
			var rgx = /['"](.+)['"]/g;
			if(rgx.test(condition)){
				var prefKey = [table_name,'_', RegExp.$1].join('');
				Utils.Console.log(["pref update data: ", prefKey].join(''));
				Preference.put(prefKey, column_value);
			}
		}
	}
}