/*%%HEADER%%*/

in vec2 vTexCoord;

uniform sampler2D inputTexture;
uniform bool horizontal;
uniform float blurRadius;

out vec4 color;

// 增加采样点数量到26个，使用更发散的权重分布
const float weights[26] = float[](
    0.0947416,  // 中心权重
    0.0930776,  // 第1层
    0.0884826,  // 第2层
    0.0812956,  // 第3层
    0.0719463,  // 第4层
    0.0610463,  // 第5层
    0.0492463,  // 第6层
    0.0372463,  // 第7层
    0.0257463,  // 第8层
    0.0152463,  // 第9层
    0.0082463,  // 第10层
    0.0042463,  // 第11层
    0.0020463,  // 第12层
    0.0009463,  // 第13层
    0.0004163,  // 第14层
    0.0001763,  // 第15层
    0.0000713,  // 第16层
    0.0000283,  // 第17层
    0.0000108,  // 第18层
    0.0000040,  // 第19层
    0.0000014,  // 第20层
    0.0000005,  // 第21层
    0.0000002,  // 第22层
    0.0000001,  // 第23层
    0.0000000,  // 第24层
    0.0000000   // 第25层
);

void main() {
    vec2 texelSize = 1.0 / vec2(textureSize(inputTexture, 0));
    
    // 获取中心像素
    vec4 centerSample = texture(inputTexture, vTexCoord);
    vec3 result = centerSample.rgb * weights[0];
    float totalAlpha = centerSample.a * weights[0];
    
    if (horizontal) {
        for (int i = 1; i < 26; ++i) {
            float offset = float(i) * blurRadius * 1.0; // 进一步增加偏移量系数
            
            vec4 sample1 = texture(inputTexture, vTexCoord + vec2(texelSize.x * offset, 0.0));
            vec4 sample2 = texture(inputTexture, vTexCoord - vec2(texelSize.x * offset, 0.0));
            
            result += sample1.rgb * weights[i];
            result += sample2.rgb * weights[i];
            totalAlpha += sample1.a * weights[i];
            totalAlpha += sample2.a * weights[i];
        }
    } else {
        for (int i = 1; i < 26; ++i) {
            float offset = float(i) * blurRadius * 1.0; // 进一步增加偏移量系数
            
            vec4 sample1 = texture(inputTexture, vTexCoord + vec2(0.0, texelSize.y * offset));
            vec4 sample2 = texture(inputTexture, vTexCoord - vec2(0.0, texelSize.y * offset));
            
            result += sample1.rgb * weights[i];
            result += sample2.rgb * weights[i];
            totalAlpha += sample1.a * weights[i];
            totalAlpha += sample2.a * weights[i];
        }
    }
    
    // 确保输出正确的颜色和透明度
    color = vec4(result, totalAlpha);
}