/*%%HEADER%%*/

in vec4 frag_color;  // radiance of splat
in vec4 frag_cov2inv;  // inverse of the 2D screen space covariance matrix of the guassian
in vec2 frag_p;  // 2D screen space center of the guassian
in float frag_h_convolution_scaling;

out vec4 out_color;

void main()
{
    vec2 d = gl_FragCoord.xy - frag_p;

    // 计算高斯值
    mat2 cov2Dinv = mat2(frag_cov2inv.xy, frag_cov2inv.zw);
    float g = exp(-0.5f * dot(d, cov2Dinv * d));

    // 提高 epsilon 阈值,减少小贡献像素的计算
    const float epsilon = 1.0 / 128.0;  // 原来是1/256
    
    // 提前进行 alpha 测试
    float alpha = frag_color.a * frag_h_convolution_scaling * g;
    if (alpha <= epsilon)
    {
        discard;
    }

    // 设置输出颜色
    out_color.rgb = alpha * frag_color.rgb;
    out_color.a = alpha;
}
