/*%%HEADER%%*/

/*%%DEFINES%%*/

uniform mat4 viewMat;
uniform mat4 projMat;
uniform vec4 projParams;
uniform vec4 viewport;
uniform vec3 eye;
uniform float projScale;
uniform float h_var;

in vec4 position;

in vec4 r_sh0;
in vec4 r_sh1;
in vec4 r_sh2;
in vec4 r_sh3;

in vec4 g_sh0;
in vec4 g_sh1;
in vec4 g_sh2;
in vec4 g_sh3;

in vec4 b_sh0;
in vec4 b_sh1;
in vec4 b_sh2;
in vec4 b_sh3;

in vec3 cov3_col0;
in vec3 cov3_col1;
in vec3 cov3_col2;

out vec4 geom_color;
out vec4 geom_cov2;
out vec2 geom_p;
out float pScale;
out float geom_h_convolution_scaling;

vec3 ComputeRadianceFromSH(const vec3 v)
{
    float b[16];

    float vx2 = v.x * v.x;
    float vy2 = v.y * v.y;
    float vz2 = v.z * v.z;

    b[0] = 0.28209479177387814f;

    float k1 = 0.4886025119029199f;
    b[1] = -k1 * v.y;
    b[2] = k1 * v.z;
    b[3] = -k1 * v.x;

    float k2 = 1.0925484305920792f;
    float k3 = 0.31539156525252005f;
    float k4 = 0.5462742152960396f;
    b[4] = k2 * v.y * v.x;
    b[5] = -k2 * v.y * v.z;
    b[6] = k3 * (3.0f * vz2 - 1.0f);
    b[7] = -k2 * v.x * v.z;
    b[8] = k4 * (vx2 - vy2);

    float k5 = 0.5900435899266435f;
    float k6 = 2.8906114426405543f;
    float k7 = 0.4570457994644658f;
    float k8 = 0.37317633259011546f;
    float k9 = 1.4453057213202771f;
    b[9] = -k5 * v.y * (3.0f * vx2 - vy2);
    b[10] = k6 * v.y * v.x * v.z;
    b[11] = -k7 * v.y * (5.0f * vz2 - 1.0f);
    b[12] = k8 * v.z * (5.0f * vz2 - 3.0f);
    b[13] = -k7 * v.x * (5.0f * vz2 - 1.0f);
    b[14] = k9 * v.z * (vx2 - vy2);
    b[15] = -k5 * v.x * (vx2 - 3.0f * vy2);

    float re = (b[0] * r_sh0.x + b[1] * r_sh0.y + b[2] * r_sh0.z + b[3] * r_sh0.w +
                b[4] * r_sh1.x + b[5] * r_sh1.y + b[6] * r_sh1.z + b[7] * r_sh1.w +
                b[8] * r_sh2.x + b[9] * r_sh2.y + b[10]* r_sh2.z + b[11]* r_sh2.w +
                b[12]* r_sh3.x + b[13]* r_sh3.y + b[14]* r_sh3.z + b[15]* r_sh3.w);

    float gr = (b[0] * g_sh0.x + b[1] * g_sh0.y + b[2] * g_sh0.z + b[3] * g_sh0.w +
                b[4] * g_sh1.x + b[5] * g_sh1.y + b[6] * g_sh1.z + b[7] * g_sh1.w +
                b[8] * g_sh2.x + b[9] * g_sh2.y + b[10]* g_sh2.z + b[11]* g_sh2.w +
                b[12]* g_sh3.x + b[13]* g_sh3.y + b[14]* g_sh3.z + b[15]* g_sh3.w);

    float bl = (b[0] * b_sh0.x + b[1] * b_sh0.y + b[2] * b_sh0.z + b[3] * b_sh0.w +
                b[4] * b_sh1.x + b[5] * b_sh1.y + b[6] * b_sh1.z + b[7] * b_sh1.w +
                b[8] * b_sh2.x + b[9] * b_sh2.y + b[10]* b_sh2.z + b[11]* b_sh2.w +
                b[12]* b_sh3.x + b[13]* b_sh3.y + b[14]* b_sh3.z + b[15]* b_sh3.w);

    return vec3(0.5f, 0.5f, 0.5f) + vec3(re, gr, bl);
}

void main(void)
{
    float alpha = position.w;
    vec4 t = viewMat * vec4(position.xyz, 1.0f);

    float X0 = viewport.x * (0.00001f * projParams.y);
    float Y0 = viewport.y;
    float WIDTH = viewport.z;
    float HEIGHT = viewport.w;
    float Z_NEAR = projParams.y;
    float Z_FAR = projParams.z;

    float SX = projMat[0][0];
    float SY = projMat[1][1];
    float WZ =  projMat[3][2];
    float tzSq = t.z * t.z;
    float jsx = -(SX * WIDTH) / (2.0f * t.z);
    float jsy = -(SY * HEIGHT) / (2.0f * t.z);
    float jtx = (SX * t.x * WIDTH) / (2.0f * tzSq);
    float jty = (SY * t.y * HEIGHT) / (2.0f * tzSq);
    float jtz = ((Z_FAR - Z_NEAR) * WZ) / (2.0f * tzSq);
    mat3 J = mat3(vec3(jsx, 0.0f, 0.0f),
                  vec3(0.0f, jsy, 0.0f),
                  vec3(jtx, jty, jtz));

    mat3 W = mat3(viewMat);
    mat3 V = mat3(cov3_col0, cov3_col1, cov3_col2);
    mat3 JW = J * W;
    mat3 V_prime = JW * V * transpose(JW);

    mat2 cov2D = mat2(V_prime);

    geom_h_convolution_scaling = 1.0f;

    if (h_var != 0.0f)
    {
        float det_cov = cov2D[0][0] * cov2D[1][1] - cov2D[0][1] * cov2D[1][0];

        cov2D[0][0] += h_var;
        cov2D[1][1] += h_var;

        float det_cov_plus_h_cov = cov2D[0][0] * cov2D[1][1] - cov2D[0][1] * cov2D[1][0];

        float h_convolution_scaling = sqrt(max(0.000025f, det_cov / det_cov_plus_h_cov));

        geom_h_convolution_scaling = h_convolution_scaling;
    }

    cov2D[0][0] += 0.3f;
    cov2D[1][1] += 0.3f;
    geom_cov2 = vec4(cov2D[0], cov2D[1]);

    vec4 p4 = projMat * t;
    geom_p = vec2(p4.x / p4.w, p4.y / p4.w);
    geom_p.x = 0.5f * (WIDTH + (geom_p.x * WIDTH) + (2.0f * X0));
    geom_p.y = 0.5f * (HEIGHT + (geom_p.y * HEIGHT) + (2.0f * Y0));

    vec3 v = normalize(position.xyz - eye);
    geom_color = vec4(ComputeRadianceFromSH(v), alpha);

    gl_Position = p4;

    float dist = length(t.xyz);
    float distanceScale = smoothstep(0.0, 50.0, dist);
    distanceScale = mix(0.7, 1.0, distanceScale);
    pScale = projScale * distanceScale;
}
