/*%%HEADER%%*/

in float lightIntensity;
in float pointSize;

out vec4 color;

void main() {
    // 计算点内坐标
    vec2 coord = gl_PointCoord * 2.0 - 1.0;
    float distance = length(coord);
    
    if (distance > 1.0) {
        discard;
    }

    // 创建多层光晕效果
    float innerGlow = 1.0 - smoothstep(0.2, 0.7, distance);
    float middleGlow = 1.0 - smoothstep(0.2, 0.7, distance);
    float outerGlow = 1.0 - smoothstep(0.2, 0.7, distance);

    // 组合光晕层
    vec3 lightColor = vec3(1.0, 1.0, 1.0); // 蓝色光
    vec3 finalColor = lightColor * innerGlow * 0.8  +
                     lightColor * middleGlow * 0.8 +
                     lightColor * outerGlow * 0.8 ;

    // 应用光照强度
    finalColor *= lightIntensity;

    // 计算透明度
    float alpha = (innerGlow * 0.6 + middleGlow * 0.6 + outerGlow * 0.6) * lightIntensity;

    color = vec4(finalColor, alpha);
}