/*%%HEADER%%*/

layout(location = 0) in vec2 position;
layout(location = 1) in float pointIndex;

uniform float sweepProgress;  // 扫光进度 [0, 1]
uniform float totalPoints;   // 总点数
uniform mat4 projection;
uniform float basePointSize; // 基础点大小
uniform float maxPointSize;  // 最大点大小

out float lightIntensity;
out float pointSize;

void main() {
    gl_Position = projection * vec4(position, 0.0, 1.0);
    
    // 计算当前点在轮廓中的相对位置
    float relativePosition = pointIndex / totalPoints;
    float reversedProgress = 1.0 - sweepProgress;
    // 改进的循环距离计算
    float distance1 = abs(relativePosition - reversedProgress);
    float distance2 = min(distance1, 1.0 - distance1); // 反向距离
    
    // 计算光照强度
    float maxDistance = 0.13;
    if (distance2 < maxDistance) {
        lightIntensity = 1.0 - smoothstep(0.0, maxDistance, distance2);
    } else {
        lightIntensity = 0.0;
    }
    
    // 根据光照强度调整点大小
    pointSize = mix(basePointSize, maxPointSize, lightIntensity);
    gl_PointSize = pointSize;
}