// MVP matrices
uniform mat4 u_MMatrix;
uniform mat4 u_VMatrix;
uniform mat4 u_PMatrix;

// mesh
attribute vec4 a_Position;

// textures
attribute vec2 a_TexCoordinate;
varying vec2 v_TexCoordinate;

void main(){

    // calculate MVP matrix
    mat4 u_MVMatrix = u_VMatrix * u_MMatrix;
    mat4 u_MVPMatrix = u_PMatrix * u_MVMatrix;

    // calculate rendered position
    gl_Position = u_MVPMatrix * a_Position;

    // pass texture to fragment shader
    v_TexCoordinate = a_TexCoordinate;
}