cordova.define("dramaApp.DramaApplication", function(require, exports, module) {
var exec = require('cordova/exec');

/* 获取当前apk的签名（MD5格式） 
 * success: function(string) 返回签名字符串
 * fail: function(string) 返回错误描述
 */
exports.getMD5Sign = function (success, error) {
    exec(success, error, 'DramaApplication', 'getMD5Sign', []);
};

/* 获取当前apk的签名（SHA1格式） 
 * success: function(string) 返回签名字符串
 * fail: function(string) 返回错误描述
 */
exports.getSHA1Sign = function (success, error) {
    exec(success, error, 'DramaApplication', 'getSHA1Sign', []);
};

/* 获取设备唯一标识 返回String 
 * success: function(string) 返回设备唯一标识字符串
 * fail: function(string) 返回错误描述
 */
exports.getDeviceID = function (success, error) {
    exec(success, error, 'DramaApplication', 'getDeviceID', []);
};

/* 获取APP信息
 * success: function(string) 返回APP信息JsonObject
 * 具体结构如下
 * {
     appid: "",
     appkey: ""
   }
 }
 * fail: function(string) 返回错误描述
 */
exports.getAppInfo = function (success, error) {
    exec(success, error, 'DramaApplication', 'getAppInfo', []);
};

/* 获取版本号 **/
exports.getAppVersion = function (success, error) {
  exec(success, error, 'DramaApplication', 'getAppVersion', []);
}

/* 获取设备信息、供云梯使用 **/
exports.getDeviceInfo = function (success, error) {
  exec(success, error, 'DramaApplication', 'getDeviceInfo', []);
}

/* 获取包名 **/
exports.getPackName = function (success, error) {
  exec(success, error, 'DramaApplication', 'getPackName', []);
}

exports.getAppProcessName = function (success, error) {
  exec(success, error, 'DramaApplication', 'getAppProcessName', []);
}

/* 显示Alert框
 * msg: string 消息
 * exitApp: bool 是否退出app
 **/
exports.showAlert = function(msg, exitApp, success, error) {
  exec(success, error, 'DramaApplication', 'showAlert', [msg, exitApp]);
};

});
