function waterMarkScript() {
    var getShortHash = function () {
        var self = getShortHash;
        var now = Date.now();
        if (now === self.last) {
            now = now + 1;
        }
        self.last = now.toString(36).toLocaleUpperCase();
        return self.last;
    };

    var Watermark = function (containerSelector, coveredSelector, config) {
        this.containerSelector = containerSelector;
        this.coveredSelector = coveredSelector;
        this.config = config;
        this.element = document.createElement('div');
        this.className = 'watermark-for-epub-' + getShortHash();
    };

    Watermark.prototype.mount = function () {
        var container = document.querySelector(this.containerSelector);
        container.style.position = 'relative ';
        this.element.classList.add(this.className);
        container.appendChild(this.element);
        console.log('mounted', this.element.getAttribute('style'));
        var clild = container.querySelectorAll('div,img,image');
        console.log('clild', clild, clild.length);
        for (let i = 0; i < clild.length; i++) {
            console.log('child[i]  ', clild[i].getAttribute('style'));
        }
    };

    Watermark.prototype.resetContainer = function () {
        var container = document.querySelector(this.containerSelector);
        var target = document.querySelector('.'+this.className);
        console.log('epub-remove target reset');
        if(target){
            target.parentElement.removeChild(target);
            console.log('epub-remove target');
        }


        var calibre = document.querySelector('.calibre');
        if(calibre) {
            calibre.style.margin = 0;
        }
        const img = document.querySelectorAll('img,image,svg');
           if (img.length) {
           img.forEach(pic => {
                 pic.style.maxWidth = '100%';
                 pic.style.height = 'auto';
           });

        }

    };

    Watermark.prototype.draw = function() {
        var type = this.config.type;
        this.resetContainer();
        if (type === '1') {
            this.drawImg();
        } else if (type === '2') {
            this.drawTextWithCanvas();
        }
    };

    Watermark.prototype.drawImgByBackground = function () {
        var that = this;
        var config = this.config;
        var opacity = config.opacityImg;
        var img = new Image();
        img.setAttribute('crossOrigin', 'Anonymous');
        img.src = this.config.imgSrc;
        img.onload = function () {
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var imgCanvas = document.createElement('canvas');
            var imgContext = imgCanvas.getContext('2d');
            var pWidth = width/2;
            imgCanvas.width = pWidth;
            imgCanvas.height = pWidth;
            imgContext.rotate(-45 * Math.PI / 180);

            var translateX = -(Math.sqrt(2)-1)/2*pWidth;
            var translateY = (pWidth)/2;
            console.log(`translateX  ${translateX}`);
            console.log(`translateY  ${translateY}`);

            imgContext.translate(-(Math.sqrt(2)-1)/2*pWidth, (pWidth)/2);
            imgContext.drawImage(img, 0, 0, pWidth/2  , pWidth/2);
            var backgroundImgUrl = imgCanvas.toDataURL('image/png');
            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'absolute';
            that.element.style.top = '0';
            that.element.style.left = '0';
            that.element.style.opacity = opacity;
            that.element.style['background-image'] = 'url("' + backgroundImgUrl + '")';
            that.mount();
        };
    };


    Watermark.prototype.drawImgByImg2 = function () {
            var that = this;
            var config = this.config;
            var opacity = config.opacityImg;
            var imgSrc = config.imgSrc;

            var container = document.createElement('div');
            for (var i = 0; i < 3; i++) {
                var childDiv = document.createElement('div');
                var imgStr = '<img style="width: 100px; margin-right:100px ; position: static ; display: inline-block; " src="' + imgSrc + '"/>';
                var imgStr2 = '<img style="width: 100px;  position: static ; display: inline-block; " src="' + imgSrc + '"/>';
                childDiv.innerHTML = imgStr
                    + imgStr2  ;
                childDiv.style = 'transform-origin: center;'
                    + 'transform: rotate(-45deg) translateX(100px) ;'
                    + 'line-height: 200px;'
                    + 'height: 300px;'
                    + 'overflow: hidden;'
                    + 'color: #000;'
                    + 'white-space: nowrap'
                    + 'opacity:' + opacity+';';
                container.appendChild(childDiv);
            }
            that.element.style = 'position: absolute;'
                + 'top: 0; bottom: 0;'
                + 'z-index: 999;'
                + 'color: #ccc;'
                + 'overflow: hidden;'
                + 'opacity:' + opacity+';';

            that.element.innerHTML = '';
            that.element.appendChild(container);
            var coveredSelector = document.querySelector(that.coveredSelector);
            var width = coveredSelector.offsetWidth || coveredSelector.clientWidth;
            var height = coveredSelector.offsetHeight || coveredSelector.clientHeight;

            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'absolute';

            that.mount();
        };



    Watermark.prototype.drawImg = Watermark.prototype.drawImgByImg2;

    Watermark.prototype.drawTextWithCanvas = function (){
            var that = this;
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var opacity =  this.config.opacityImg;
            var imgCanvas = document.createElement('canvas');
            var imgContext = imgCanvas.getContext('2d');
            var pWidth = width/2;
            imgCanvas.width = pWidth;
            imgCanvas.height = pWidth;
            imgContext.rotate(-45 * Math.PI / 180);
            imgContext.translate(-(Math.sqrt(2)-1)/2*pWidth, (pWidth)/2);
            imgContext.font = "16px";
            imgContext.textBaseline = "middle";
            imgContext.fillText(this.config.text, 0, 0);
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var backgroundImgUrl = imgCanvas.toDataURL('image/png');
            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'fixed';
            that.element.style.top = '0';
            that.element.style.left = '0';
            that.element.style.opacity = opacity;
            that.element.style['background-image'] = 'url("' + backgroundImgUrl + '")';
            that.mount();
    };

    Watermark.prototype.drawText = function () {
        var coveredElement = document.querySelector(this.coveredSelector);
        var width = coveredElement.offsetWidth;
        var height = coveredElement.offsetHeight;
        var config = this.config;
        var pWidth = Math.floor(Math.sqrt(width/2*width/2/2));
        console.log(`p width ${pWidth}`);
        var opacity =  config.opacityText;
        var cell =
            `<p style="transform: rotate(-45deg);
                       transform-origin: left;
                       margin: 0px;
                       display: inline-block;
                       white-space: nowrap;
                       width: ${pWidth};
                       overflow: hidden;
                       text-overflow:ellipsis;">
                ${config.text}
            </p>`;
        this.element.innerHTML = '';
        for (var i = 0; i < 300; i++) {
            this.element.innerHTML += cell;
        }
        this.element.style = 'position: absolute;'
            + 'top: 0; bottom: 0;'
            + 'z-index: 999;'
            + 'line-height: 9rem;'
            + 'color: #000;'
            + 'overflow: hidden;'
            + 'opacity: ' + opacity + ';';
        this.element.style.width = width + 'px';
        console.log(`container width ${width}`);
        this.element.style.height = height + 'px';
        this.mount();
    };

    Watermark.prototype.clearOtherMask = function () {
        setTimeout(function(){
            var maskList = document.querySelectorAll('.'+this.className);
            for (var i = 0; i < (maskList.length-1); i++) {
                var target = maskList[i];
                target.parentElement.removeChild(target);
            }
        },1000);
    };

    var __main = function () {
		var config = {
			show: true,
            type: 'EXECUEL_WATER_MASK_TYPE',
            text: 'WATER_MASK_TEXT',
            imgSrc: 'WATER_MASK_TEXT',
            opacityImg: WATER_MASK_OPACITY,
            opacityText: WATER_MASK_OPACITY,
		};
        if (config && config.show) {
			console.log('native water mask');
            var watermark = new Watermark('body', 'body', config);

            var maskList = document.querySelectorAll('.'+this.className);
            watermark.draw();
        }
    };

    __main();

}

waterMarkScript();

