function waterMarkScript() {
    var getShortHash = function () {
        var self = getShortHash;
        var now = Date.now();
        if (now === self.last) {
            now = now + 1;
        }
        self.last = now.toString(36).toLocaleUpperCase();
        return self.last;
    };

    var Watermark = function (containerSelector, coveredSelector, config) {
        this.containerSelector = containerSelector;
        this.coveredSelector = coveredSelector;
        this.config = config;
        this.element = document.createElement('div');
        this.className = 'watermark-for-excel-' + getShortHash();
    };

    Watermark.prototype.mount = function () {
        var container = document.querySelector(this.containerSelector);
        container.style.position = 'relative';
        this.element.classList.add(this.className);
        container.appendChild(this.element);
    };

    Watermark.prototype.resetContainer = function () {
        var container = document.querySelector(this.containerSelector);
        var target = document.querySelector('.'+this.className);
        console.log('epub-remove target reset');
        if(target){
            target.parentElement.removeChild(target);
            console.log('epub-remove target');
        }

    };

    Watermark.prototype.draw = function() {
        var type = this.config.type;
        this.resetContainer();
        if (type === '1') {
            this.drawImg();
        } else if (type === '2') {
            this.drawText();
        }
    };

    Watermark.prototype.drawImgByBackground = function () {
        var that = this;
        var config = this.config;
        var opacity = (100 - config.opacityImg) / 100;
        var img = new Image();
        img.setAttribute('crossOrigin', 'Anonymous');
        img.src = this.config.imgSrc;
        img.onload = function () {
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var imgCanvas = document.createElement('canvas');
            var imgContext = imgCanvas.getContext('2d');
            var pWidth = 170;
            imgCanvas.width = pWidth;
            imgCanvas.height = pWidth;
            imgContext.rotate(-45 * Math.PI / 180);
            imgContext.translate(-(Math.sqrt(2)-1)/2*pWidth, (pWidth)/2);
            imgContext.drawImage(img, 0, 0, pWidth/2  , pWidth/2);
            var backgroundImgUrl = imgCanvas.toDataURL('image/png');
            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'absolute';
            that.element.style.top = '0';
            that.element.style.left = '0';
            that.element.style.opacity = opacity;
            that.element.style['background-image'] = 'url("' + backgroundImgUrl + '")';
            that.mount();
        };
    };


    Watermark.prototype.drawImgByImg2 = function () {
            var config = this.config;
            var opacity = config.opacityImg;
            var imgSrc = config.imgSrc;
            var container = document.createElement('div');
            document.body.style.overflow = 'hidden';
            for (var i = 0; i < 10; i++) {
                var childDiv = document.createElement('div');
                var imgStr = '<img style="width: 100px; margin-right: 200px; position: static;" src="' + imgSrc + '"/>';
                childDiv.innerHTML = imgStr
                    + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr
                    + imgStr;
                childDiv.style = 'transform-origin: left;'
                    + 'transform: translateX(100px) rotate(-45deg);'
                    + 'line-height: 324px;'
                    + 'overflow: hidden;'
                    + 'height: 324px;'
                    + 'color: #000;'
                    + 'white-space: nowrap'
                    + 'opacity:' + opacity+';';
                container.appendChild(childDiv);
            }
            this.element.style = 'position: absolute;'
                + 'top: 0; bottom: 0;'
                + 'z-index: 999;'
                + 'color: #ccc;'
                + 'overflow: hidden;'
                + 'opacity:' + opacity+';';

            this.element.innerHTML = '';
            this.element.appendChild(container);
            var coveredSelector = document.querySelector(this.coveredSelector);
            var width = coveredSelector.offsetWidth;
            var height = coveredSelector.offsetHeight;
            this.element.style.width = width + 'px';
            this.element.style.height = height + 'px';
            this.mount();
        };


    Watermark.prototype.drawImg = Watermark.prototype.drawImgByImg2;

    Watermark.prototype.drawTextWithCanvas = function (){
            var that = this;
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var opacity =  this.config.opacityImg;
            var imgCanvas = document.createElement('canvas');
            var imgContext = imgCanvas.getContext('2d');
            var pWidth = width/2;
            imgCanvas.width = pWidth;
            imgCanvas.height = pWidth;
            imgContext.rotate(-45 * Math.PI / 180);
            imgContext.translate(-(Math.sqrt(2)-1)/2*pWidth, (pWidth)/2);
            imgContext.font = "16px";
            imgContext.textBaseline = "middle";
            imgContext.fillText(this.config.text, 0, 0);
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            var backgroundImgUrl = imgCanvas.toDataURL('image/png');
            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'absolute';
            that.element.style.top = '0';
            that.element.style.left = '0';
            that.element.style.opacity = opacity;
            that.element.style['background-image'] = 'url("' + backgroundImgUrl + '")';
            that.mount();
    };

    Watermark.prototype.drawText = function () {
                   var coveredElement = document.querySelector(this.coveredSelector);
                   var width = coveredElement.offsetWidth;
                   var height = coveredElement.offsetHeight;
                   var config = this.config;
                   var opacity = this.config.opacityImg;
                   var cell = `<p style = 'transform: rotate(-45deg);transform-origin:left;margin: 20px 40px; display: inline-block;' > ` + config.text + '</p>';
                   this.element.innerHTML = '';
                   for (var i = 0; i < 300; i++) {
                       this.element.innerHTML += cell;
                   }
                   this.element.style = 'position:absolute;' + 'top: 0; bottom: 0;' + 'z-index: 999;' + 'line-height: 9rem;' + 'color: #000;' + 'overflow: hidden;' + 'opacity: ' + opacity + ';';
                   this.element.style.width = width + 'px';
                   this.element.style.height = height + 'px';
                   this.mount();
    };

    Watermark.prototype.clearOtherMask = function () {
        setTimeout(function(){
            var maskList = document.querySelectorAll('.'+this.className);
            for (var i = 0; i < (maskList.length-1); i++) {
                var target = maskList[i];
                target.parentElement.removeChild(target);
            }
        },1000);
    };

    var addEvents = function(watermark) {
            document.querySelector('.tab-nav')
            .addEventListener('click',function() {
                setTimeout(function() {
                    watermark.draw();
                });
            });
    };

    var __main = function () {
		var config = {
			show: true,
            type: 'EXECUEL_WATER_MASK_TYPE',
            text: 'WATER_MASK_TEXT',
            imgSrc: 'WATER_MASK_TEXT',
            opacityImg: WATER_MASK_OPACITY,
            opacityText: WATER_MASK_OPACITY,
		};
        if (config && config.show) {
			console.log('native water mask');
            var watermark = new Watermark('.cur', '.cur table', config);
            watermark.draw();
            addEvents(watermark);
        }
    };

    __main();

}

waterMarkScript();

