export function waterMarkScript() {
    var getShortHash = function () {
        var self = getShortHash;
        var now = Date.now();
        if (now === self.last) {
            now = now + 1;
        }
        self.last = now.toString(36).toLocaleUpperCase();
        return self.last;
    };

    var Watermark = function (containerSelector, coveredSelector, config) {
        this.containerSelector = containerSelector;
        this.coveredSelector = coveredSelector;
        this.config = config;
        this.element = document.createElement('div');
        this.className = 'watermark-for-excel-' + getShortHash();
    };

    Watermark.prototype.mount = function () {
        var container = document.querySelector(this.containerSelector);
        container.style.position = 'relative';
        this.element.classList.add(this.className);
        container.appendChild(this.element);
    };

    Watermark.prototype.resetContainer = function () {
        var container = document.querySelector(this.containerSelector);
        var target = container.querySelector(this.className);
        target && target.remove();
    };

    Watermark.prototype.draw = function() {
        var type = this.config.type;
        this.resetContainer();
        if (type === '1') {
            this.drawImg();
        } else if (type === '2') {
            this.drawText();
        }
    };

    Watermark.prototype.drawImgByBackground = function () {
        var that = this;
        var config = this.config;
        var opacity = (100 - config.opacityImg) / 100;
        var img = new Image();
        img.setAttribute('crossOrigin', 'Anonymous');
        img.src = this.config.imgSrc;
        img.onload = function () {
            // 旋转图片
            var imgCanvas = document.createElement('canvas');
            var imgContext = imgCanvas.getContext('2d');
            imgCanvas.width = 170;
            imgCanvas.height = 170;
            imgContext.rotate(-45 * Math.PI / 180);
            imgContext.translate(0, 80);
            imgContext.drawImage(img, 0, 0, 80, 80);
            // 获取被遮挡元素宽高
            var coveredElement = document.querySelector(that.coveredSelector);
            var width = coveredElement.offsetWidth;
            var height = coveredElement.offsetHeight;
            // 设置水印背景
            var backgroundImgUrl = imgCanvas.toDataURL('image/png');
            that.element.style.width = width + 'px';
            that.element.style.height = height + 'px';
            that.element.style.position = 'absolute';
            that.element.style.top = '0';
            that.element.style.left = '0';
            that.element.style.opacity = opacity;
            that.element.style['background-image'] = 'url("' + backgroundImgUrl + '")';
            that.mount();
        };
    };

    Watermark.prototype.drawImgByImg = function () {
        var config = this.config;
        var opacity = (100 - config.opacityImg) / 100;
        this.element.style = 'position: absolute;'
            + 'top: 0; bottom: 0;'
            + 'z-index: 999;'
            + 'color: #ccc;'
            + 'overflow: hidden;'
            + 'opacity: ' + opacity + ';';
        var cell = '<img style="transform: rotate(-45deg); width: 100px; position: static; margin: 20px 40px;" src="'
            + config.imgSrc + '"/>';
        this.element.innerHTML = '';
        for (let i = 0; i < 300; i++) {
            this.element.innerHTML += cell;
        }
        var coveredSelector = document.querySelector(this.coveredSelector);
        var width = coveredSelector.offsetWidth;
        var height = coveredSelector.offsetHeight;
        this.element.style.width = width + 'px';
        this.element.style.height = height + 'px';
        this.mount();
    };

    Watermark.prototype.drawImgByImg2 = function () {
        var config = this.config;
        var opacity = (100 - config.opacityImg) / 100;
        var imgSrc = config.imgSrc;
        var container = document.createElement('div');
        document.body.style.overflow = 'hidden';
        for (var i = 0; i < 10; i++) {
            var childDiv = document.createElement('div');
            var imgStr = '<img style="width: 100px; margin-right: 200px; position: static;" src="' + imgSrc + '">';
            childDiv.innerHTML = imgStr
                + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr + imgStr
                + imgStr;
            childDiv.style = 'transform-origin: left;'
                + 'transform: translateX(100px) rotate(-45deg);'
                + 'line-height: 324px;'
                + 'height: 400px;'
                + 'overflow: hidden;'
                + 'height: 324px;'
                + 'color: #000;'
                + 'white-space: nowrap'
                + 'opacity:' + opacity;
            container.appendChild(childDiv);
        }
        this.element.style = 'position: absolute;'
            + 'top: 0; bottom: 0;'
            + 'z-index: 999;'
            + 'color: #ccc;'
            + 'overflow: hidden;'
            + 'opacity: ' + opacity + ';';
        this.element.innerHTML = '';
        this.element.appendChild(container);
        var coveredSelector = document.querySelector(this.coveredSelector);
        var width = coveredSelector.offsetWidth;
        var height = coveredSelector.offsetHeight;
        this.element.style.width = width + 'px';
        this.element.style.height = height + 'px';
        this.mount();
    };

    Watermark.prototype.drawImg = Watermark.prototype.drawImgByImg2;

    Watermark.prototype.drawText = function () {
        var coveredElement = document.querySelector(this.coveredSelector);
        var width = coveredElement.offsetWidth;
        var height = coveredElement.offsetHeight;
        var config = this.config;
        var opacity = (100 - config.opacityText) / 100;
        // 设置文本内容
        var cell = ' <p style="transform: rotate(-45deg);transform-origin: left;margin: 20px 40px; display: inline-block;">'
            + config.text
            + '</p>';
        this.element.innerHTML = '';
        for (var i = 0; i < 300; i++) {
            this.element.innerHTML += cell;
        }
        this.element.style = 'position: absolute;'
            + 'top: 0; bottom: 0;'
            + 'z-index: 999;'
            + 'line-height: 9rem;'
            + 'color: #000;'
            + 'overflow: hidden;'
            + 'opacity: ' + opacity + ';';
        this.element.style.width = width + 'px';
        this.element.style.height = height + 'px';
        this.mount();
    };

    var addEvents = function (watermark) {
        /* 什么时候重新绘制 */
        document.querySelector('.tab-nav')
            .addEventListener('click', function () {
                setTimeout(function () {
                    watermark.draw();
                });
            });
    };

    var __main = function () {
        var config = window.scriptConfig;
        /* config 格式:
            {
                // 显示隐藏
                show: true,
                // '1' 图片, '2' 文字
                type: 1,
                text: '',
                imgSrc: '',
                opacityImg: '',
                opacityText: '',
            }
        */
        if (config && config.show) {
            /* 第一个参数是容器, 第二个参数是要遮挡的元素 */
            var watermark = new Watermark('.cur', '.cur table', config);
            watermark.draw();
            addEvents(watermark);
        }
    };

    __main();
}

