var getBlackBoxData;
var CustomModuleUtil = function() {
    this.jsonUrl = './custom/config.json';
    this.url = window._domain_.split('/app/')[0] + '/api/v1/system/custom-config/front';
    this.jsonConfig = '';
};

CustomModuleUtil.prototype.getJsonConfig = function(callback) {
    var me = this;
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState === 4) {
            if (xmlhttp.status === 200 || xmlhttp.status === 0) {
                me.jsonConfig = JSON.parse(xmlhttp.responseText);
                callback();
            }else{
                callback();
            }
        }
    };
    xmlhttp.open('get', this.jsonUrl + '?_=' + new Date().getTime(), true);
    xmlhttp.send(null);
};
// 从服务器获取企业定制化模块数据
CustomModuleUtil.prototype.getCustomData = function(callback) {
    var me = this;
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState === 4) {
            if (xmlhttp.status === 200) {
                // 缓存到window
                callback(me.extractData(JSON.parse(xmlhttp.responseText)));
            }else{
                callback(null);
            }
        }
    };
    xmlhttp.open('get', this.url + '?_=' + new Date().getTime(), true);
    xmlhttp.send(null);
};

// 组装数据
CustomModuleUtil.prototype.extractData = function(arr) {
    var customModules = {
        customModuleDomain: '',
        styleLoadPath: '',
        modules: []
    };
    var arrayData = arr;
    if (!arrayData) return customModules;
    arrayData.map(function(item) {
        customModules.customModuleDomain = item.domain;
        if (!customModules.styleLoadPath && Number(item.customCss) === 1) {
            customModules.styleLoadPath = 'custom.css';
        }
        customModules.modules.push({
            id: item.id,
            name: item.name,
            moduleName: item.moduleName,
            domain: item.domain,
            moduleLoadPath: item.moduleLoadPath,
            description: item.description
        });
        return true;
    });
    return customModules;
};

// 获取黑箱相关数据
getBlackBoxData = function(callFn) {
    var ins = new CustomModuleUtil();
    if (window.location.host.indexOf('localhost') > -1) {
        ins.getJsonConfig(function() {
            window.zxyBlackBoxVersion = ins.jsonConfig.version;
            if (ins.jsonConfig.customMode === 'development') { // 启用本地开发模式
                window.zxyCustomModules = ins.extractData(ins.jsonConfig.customModules);
                callFn();
            } else {
                console.log('%c如需调试黑箱工程，请修改本地config.json中customMode为development', 'color: red; font-size: 20px');
                callFn();
            }
        });
    } else {
        ins.getCustomData(function(data) { // 从服务器获取定制化数据
            window.zxyCustomModules = data;
            callFn();
        });
    }
};

export default getBlackBoxData;
