cordova.define("org.devgeeks.Canvas2ImagePlugin.Canvas2ImagePlugin", function(require, exports, module) {
//
//  Canvas2ImagePlugin.js
//  Canvas2ImagePlugin PhoneGap/Cordova plugin
//
//  Created by Tommy-Carlos Williams on 29/03/12.
//  Copyright (c) 2012 Tommy-Carlos Williams. All rights reserved.
//  MIT Licensed
//

  module.exports = {
    
    saveImageDataToLibrary:function(successCallback, failureCallback, canvasId) {
        // successCallback required
        if (typeof successCallback != "function") {
            console.log("Canvas2ImagePlugin Error: successCallback is not a function");
        }
        else if (typeof failureCallback != "function") {
            console.log("Canvas2ImagePlugin Error: failureCallback is not a function");
        }
        else {
            var canvas = (typeof canvasId === "string") ? document.getElementById(canvasId) : canvasId;
            var imageData = canvas.toDataURL().replace(/data:image\/png;base64,/,'');
            return cordova.exec(successCallback, failureCallback, "Canvas2ImagePlugin","saveImageDataToLibrary",[imageData]);
        }
    },
    saveFileByUrl:function(successCallback, failureCallback, url) {
            // successCallback required
            if (typeof successCallback != "function") {
                console.log("Canvas2ImagePlugin Error: successCallback is not a function");
            }
            else if (typeof failureCallback != "function") {
                console.log("Canvas2ImagePlugin Error: failureCallback is not a function");
            }
            else {
                return cordova.exec(successCallback, failureCallback, "Canvas2ImagePlugin","saveFileByUrl",[url]);
            }
        }
  };
  

});
