/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.androidquery.AQuery;
import com.androidquery.util.Common;
import com.androidquery.util.Progress;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AQUtility {
    private static boolean debug = false;
    private static Object wait;
    private static Thread.UncaughtExceptionHandler eh;
    private static Map<String, Long> times;
    private static Handler handler;
    private static final int IO_BUFFER_SIZE = 4096;
    public static boolean TEST_IO_EXCEPTION;
    private static ScheduledExecutorService storeExe;
    private static File cacheDir;
    private static File pcacheDir;
    private static Context context;
    private static final char[] map1;
    private static final byte[] map2;

    static {
        times = new HashMap<String, Long>();
        TEST_IO_EXCEPTION = false;
        map1 = new char[64];
        int i = 0;
        int c = 65;
        while (c <= 90) {
            AQUtility.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            AQUtility.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            AQUtility.map1[i++] = c;
            c = (char)(c + 1);
        }
        AQUtility.map1[i++] = 43;
        AQUtility.map1[i++] = 47;
        map2 = new byte[128];
        i = 0;
        while (i < map2.length) {
            AQUtility.map2[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 64) {
            AQUtility.map2[AQUtility.map1[i]] = (byte)i;
            ++i;
        }
    }

    public static void setDebug(boolean debug) {
        AQUtility.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugWait(long time) {
        if (!debug) {
            return;
        }
        if (wait == null) {
            wait = new Object();
        }
        Object object = wait;
        synchronized (object) {
            try {
                wait.wait(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugNotify() {
        if (!debug || wait == null) {
            return;
        }
        Object object = wait;
        synchronized (object) {
            wait.notifyAll();
        }
    }

    public static void debug(Object msg) {
        if (debug) {
            Log.w((String)"AQuery", (String)("" + msg));
        }
    }

    public static void warn(Object msg, Object msg2) {
        Log.w((String)"AQuery", (String)(msg + ":" + msg2));
    }

    public static void debug(Object msg, Object msg2) {
        if (debug) {
            Log.w((String)"AQuery", (String)(msg + ":" + msg2));
        }
    }

    public static void debug(Throwable e) {
        if (debug) {
            String trace = Log.getStackTraceString((Throwable)e);
            Log.w((String)"AQuery", (String)trace);
        }
    }

    public static void report(Throwable e) {
        if (e == null) {
            return;
        }
        try {
            AQUtility.warn("reporting", Log.getStackTraceString((Throwable)e));
            if (eh != null) {
                eh.uncaughtException(Thread.currentThread(), e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        eh = handler;
    }

    public static void time(String tag) {
        times.put(tag, System.currentTimeMillis());
    }

    public static long timeEnd(String tag, long threshold) {
        Long old = times.get(tag);
        if (old == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long diff = now - old;
        if (threshold == 0L || diff > threshold) {
            AQUtility.debug(tag, diff);
        }
        return diff;
    }

    public static Object invokeHandler(Object handler, String callback, boolean fallback, boolean report, Class<?>[] cls, Object ... params) {
        return AQUtility.invokeHandler(handler, callback, fallback, report, cls, null, params);
    }

    public static Object invokeHandler(Object handler, String callback, boolean fallback, boolean report, Class<?>[] cls, Class<?>[] cls2, Object ... params) {
        try {
            return AQUtility.invokeMethod(handler, callback, fallback, cls, cls2, params);
        }
        catch (Exception e) {
            if (report) {
                AQUtility.report(e);
            } else {
                AQUtility.debug(e);
            }
            return null;
        }
    }

    private static Object invokeMethod(Object handler, String callback, boolean fallback, Class<?>[] cls, Class<?>[] cls2, Object ... params) throws Exception {
        if (handler == null || callback == null) {
            return null;
        }
        Method method = null;
        try {
            if (cls == null) {
                cls = new Class[]{};
            }
            method = handler.getClass().getMethod(callback, cls);
            return method.invoke(handler, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                if (fallback) {
                    if (cls2 == null) {
                        method = handler.getClass().getMethod(callback, new Class[0]);
                        return method.invoke(handler, new Object[0]);
                    }
                    method = handler.getClass().getMethod(callback, cls2);
                    return method.invoke(handler, params);
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
            return null;
        }
    }

    public static void transparent(View view, boolean transparent) {
        float alpha = 1.0f;
        if (transparent) {
            alpha = 0.5f;
        }
        AQUtility.setAlpha(view, alpha);
    }

    private static void setAlpha(View view, float alphaValue) {
        if (alphaValue == 1.0f) {
            view.clearAnimation();
        } else {
            AlphaAnimation alpha = new AlphaAnimation(alphaValue, alphaValue);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            view.startAnimation((Animation)alpha);
        }
    }

    public static void ensureUIThread() {
        if (!AQUtility.isUIThread()) {
            AQUtility.report(new IllegalStateException("Not UI Thread"));
        }
    }

    public static boolean isUIThread() {
        long cId;
        long uiId = Looper.getMainLooper().getThread().getId();
        return uiId == (cId = Thread.currentThread().getId());
    }

    public static Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        return handler;
    }

    public static void post(Runnable run) {
        AQUtility.getHandler().post(run);
    }

    public static void post(Object handler, String method) {
        AQUtility.post(handler, method, new Class[0], new Object[0]);
    }

    public static void post(final Object handler, final String method, final Class<?>[] sig, final Object ... params) {
        AQUtility.post(new Runnable(){

            @Override
            public void run() {
                AQUtility.invokeHandler(handler, method, false, true, sig, params);
            }
        });
    }

    public static void postAsync(final Runnable run) {
        AsyncTask<Void, Void, String> task = new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                try {
                    run.run();
                }
                catch (Exception e) {
                    AQUtility.report(e);
                }
                return null;
            }
        };
        task.execute((Object[])new Void[0]);
    }

    public static void postAsync(Object handler, String method) {
        AQUtility.postAsync(handler, method, new Class[0], new Object[0]);
    }

    public static void postAsync(final Object handler, final String method, final Class<?>[] sig, final Object ... params) {
        AQUtility.postAsync(new Runnable(){

            @Override
            public void run() {
                AQUtility.invokeHandler(handler, method, false, true, sig, params);
            }
        });
    }

    public static void removePost(Runnable run) {
        AQUtility.getHandler().removeCallbacks(run);
    }

    public static void postDelayed(Runnable run, long delay) {
        AQUtility.getHandler().postDelayed(run, delay);
    }

    public static void apply(SharedPreferences.Editor editor) {
        if (AQuery.SDK_INT >= 9) {
            AQUtility.invokeHandler((Object)editor, "apply", false, true, null, null);
        } else {
            editor.commit();
        }
    }

    private static String getMD5Hex(String str) {
        byte[] data = AQUtility.getMD5(str.getBytes());
        BigInteger bi = new BigInteger(data).abs();
        String result = bi.toString(36);
        return result;
    }

    private static byte[] getMD5(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(data);
            byte[] hash = digest.digest();
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            AQUtility.report(e);
            return null;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        AQUtility.copy(in, out, 0, null);
    }

    public static void copy(InputStream in, OutputStream out, int max, Progress progress) throws IOException {
        int read;
        if (progress != null) {
            progress.reset();
            progress.setBytes(max);
        }
        byte[] b = new byte[4096];
        int count = 0;
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
            if (TEST_IO_EXCEPTION && ++count > 2) {
                AQUtility.debug("simulating internet error");
                throw new IOException();
            }
            if (progress == null) continue;
            progress.increment(read);
        }
        if (progress != null) {
            progress.done();
        }
    }

    public static byte[] toBytes(InputStream is) {
        byte[] result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            AQUtility.copy(is, baos);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            AQUtility.report(e);
        }
        AQUtility.close(is);
        return result;
    }

    public static void write(File file, byte[] data) {
        try {
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    AQUtility.debug("file create fail", file);
                    AQUtility.report(e);
                }
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ScheduledExecutorService getFileStoreExecutor() {
        if (storeExe == null) {
            storeExe = Executors.newSingleThreadScheduledExecutor();
        }
        return storeExe;
    }

    public static void storeAsync(File file, byte[] data, long delay) {
        ScheduledExecutorService exe = AQUtility.getFileStoreExecutor();
        Common task = new Common().method(1, file, data);
        exe.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static File getCacheDir(Context context, int policy) {
        if (policy == 1) {
            if (pcacheDir != null) {
                return pcacheDir;
            }
            File cd = AQUtility.getCacheDir(context);
            pcacheDir = new File(cd, "persistent");
            pcacheDir.mkdirs();
            return pcacheDir;
        }
        return AQUtility.getCacheDir(context);
    }

    public static File getCacheDir(Context context) {
        if (cacheDir == null) {
            cacheDir = new File(context.getCacheDir(), "aquery");
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static void setCacheDir(File dir) {
        cacheDir = dir;
        if (cacheDir != null) {
            cacheDir.mkdirs();
        }
    }

    private static File makeCacheFile(File dir, String name) {
        File result = new File(dir, name);
        return result;
    }

    private static String getCacheFileName(String url) {
        String hash = AQUtility.getMD5Hex(url);
        return hash;
    }

    public static File getCacheFile(File dir, String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith(File.separator)) {
            return new File(url);
        }
        String name = AQUtility.getCacheFileName(url);
        File file = AQUtility.makeCacheFile(dir, name);
        return file;
    }

    public static File getExistedCacheByUrl(File dir, String url) {
        File file = AQUtility.getCacheFile(dir, url);
        if (file == null || !file.exists() || file.length() == 0L) {
            return null;
        }
        return file;
    }

    public static File getExistedCacheByUrlSetAccess(File dir, String url) {
        File file = AQUtility.getExistedCacheByUrl(dir, url);
        if (file != null) {
            AQUtility.lastAccess(file);
        }
        return file;
    }

    private static void lastAccess(File file) {
        long now = System.currentTimeMillis();
        file.setLastModified(now);
    }

    public static void store(File file, byte[] data) {
        try {
            if (file != null) {
                AQUtility.write(file, data);
            }
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    public static void cleanCacheAsync(Context context) {
        long triggerSize = 3000000L;
        long targetSize = 2000000L;
        AQUtility.cleanCacheAsync(context, triggerSize, targetSize);
    }

    public static void cleanCacheAsync(Context context, long triggerSize, long targetSize) {
        try {
            File cacheDir = AQUtility.getCacheDir(context);
            Common task = new Common().method(2, cacheDir, triggerSize, targetSize);
            ScheduledExecutorService exe = AQUtility.getFileStoreExecutor();
            exe.schedule(task, 0L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    public static void cleanCache(File cacheDir, long triggerSize, long targetSize) {
        try {
            File temp;
            File[] files = cacheDir.listFiles();
            if (files == null) {
                return;
            }
            Arrays.sort(files, new Common());
            if (AQUtility.testCleanNeeded(files, triggerSize)) {
                AQUtility.cleanCache(files, targetSize);
            }
            if ((temp = AQUtility.getTempDir()) != null && temp.exists()) {
                AQUtility.cleanCache(temp.listFiles(), 0L);
            }
        }
        catch (Exception e) {
            AQUtility.report(e);
        }
    }

    public static File getTempDir() {
        File ext = Environment.getExternalStorageDirectory();
        File tempDir = new File(ext, "aquery/temp");
        tempDir.mkdirs();
        if (!tempDir.exists() || !tempDir.canWrite()) {
            return null;
        }
        return tempDir;
    }

    private static boolean testCleanNeeded(File[] files, long triggerSize) {
        long total = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if ((total += f.length()) > triggerSize) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void cleanCache(File[] files, long maxSize) {
        long total = 0L;
        int deletes = 0;
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isFile() && (total += f.length()) >= maxSize) {
                f.delete();
                ++deletes;
            }
            ++i;
        }
        AQUtility.debug("deleted", deletes);
    }

    public static int dip2pixel(Context context, float n) {
        int value = (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return value;
    }

    public static float pixel2dip(Context context, float n) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = n / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static void setContext(Application app) {
        context = app.getApplicationContext();
    }

    public static Context getContext() {
        if (context == null) {
            AQUtility.warn("warn", "getContext with null");
            AQUtility.debug(new IllegalStateException());
        }
        return context;
    }

    public static char[] encode64(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }
}

