/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.util;

import android.graphics.Bitmap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class BitmapCache
extends LinkedHashMap<String, Bitmap> {
    private static final long serialVersionUID = 1L;
    private int maxCount;
    private int maxPixels;
    private int maxTotalPixels;
    private int pixels;

    public BitmapCache(int mc, int mp, int mtp) {
        super(8, 0.75f, true);
        this.maxCount = mc;
        this.maxPixels = mp;
        this.maxTotalPixels = mtp;
    }

    @Override
    public Bitmap put(String key, Bitmap bm) {
        Bitmap old = null;
        int px = this.pixels(bm);
        if (px <= this.maxPixels) {
            this.pixels += px;
            old = super.put(key, bm);
            if (old != null) {
                this.pixels -= this.pixels(old);
            }
        }
        return old;
    }

    @Override
    public Bitmap remove(Object key) {
        Bitmap old = (Bitmap)super.remove(key);
        if (old != null) {
            this.pixels -= this.pixels(old);
        }
        return old;
    }

    @Override
    public void clear() {
        super.clear();
        this.pixels = 0;
    }

    private int pixels(Bitmap bm) {
        if (bm == null) {
            return 0;
        }
        return bm.getWidth() * bm.getHeight();
    }

    private void shrink() {
        if (this.pixels > this.maxTotalPixels) {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                keys.next();
                keys.remove();
                if (this.pixels <= this.maxTotalPixels) break;
            }
        }
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<String, Bitmap> eldest) {
        if (this.pixels > this.maxTotalPixels || this.size() > this.maxCount) {
            this.remove(eldest.getKey());
        }
        this.shrink();
        return false;
    }
}

