(function(exports) {

    (function() {
        function a() {
            b || (b = !0, c.forEach(function(b) {
                b()
            }), c = [])
        }
        function d() {
            b || /loaded|complete/i.test(document.readyState) ? a() : requestAnimationFrame ? requestAnimationFrame(d) : setTimeout(d, 0)
        }
        var b, c = [];
        document.addEventListener("DOMContentLoaded", a, !1);
        document.addEventListener("load", a, !1);
        d();
        window.esunDomReady = function(a) {
            b ? a() : c.push(a)
        }
    })();

    function assert(assertion, msg) {
        if (!assertion) {
            alert(msg)
        }
    }

    function is(unknow, assertion) {
        return typeof unknow === assertion
    }

    function getType(obj){
        return (Object.prototype.toString.call(obj)+'').replace(/^\[object\s+(\w+)\]$/, '$1').toLowerCase();
    }

    function isPlainObject(obj) {
        return obj && Object.prototype.toString.call(obj) === '[object Object]';
    }

    var guidSeed = 1000;
    function getGuid(prefix) {
        guidSeed++;
        return (prefix || 'guid') + '_' + guidSeed;
    }

    var nativeApi = exports.ESOpen;

    var WEB_FOR_APP = "web4app";
    var APP_FOR_WEB = "app4web";

    var wrapper = {
        isAndroid: true,
        statusBarHeight: 0 /*__StatusBarHeight__*/,
        getInfo: function() {
            var info;
            try {
                info = nativeApi._getInfo()
            } catch(e) {
                return alert("客户端EsApp._getInfo()接口异常\n" + e)
            }
            try {
                info = JSON.parse(info)
            } catch(e) {
                alert("客户端EsApp._getInfo()返回值数据格式不正确\n" + info)
            }
            info.platform = "1";
            return info
        },
        _protocol: function() {
            try {
                return nativeApi._getProtocolName()
            } catch(e) {
                alert("客户端EsApp._getProtocolName()调用异常\n" + e)
            }
        },
        invokeWithCallback: function(options, invokeName) {
            if(!options){
                options = {};
            }
            if(getType(options) == 'string'){
                 if("/navigateTo/openUrl/openEsun/".indexOf("/" + invokeName + "/") > -1){
                     options = {url: options}
                 } else {
                     options = {title: options}
                 }
            }
            if (!isPlainObject(options)) {
                alert("[ESOpen]: 参数格式错误(" + invokeName + ')');
                return false;
            }
            var params = {
                options: options
            };
            if (options.success) {
                params.successCallbackName = getGuid(invokeName + "_success");
                window[params.successCallbackName] = options.success;
            }
            if (options.error) {
                params.errorCallbackName = getGuid(invokeName + "_error");
                window[params.errorCallbackName] = options.error;
            }

            /* 去除不合法的内容 */
            var types = "string,object,number,boolean,";
            for(var k in options){
                if(types.indexOf(getType(options[k]) + ',') == -1){
                   delete options[k];
                }
            }
            this.invoke(invokeName, params);
            return true;
        },
        invoke: function(rabbitName, options) {
            try {
                nativeApi._invoke(rabbitName, JSON.stringify(options));
            } catch(e) {
                alert("客户端EsApp._invoke接口异常\n" + e)
            }
        },


        publish: function (msgName, args) {
            if(/^[\w_\-\.]+$/.test(msgName) && JSON.stringify(args).length < 1024){
                this.invoke('triggerSystemMessage-' + msgName, args);
             } else {
                alert("消息名不正确或者参数过长");
             }
        },

        subscribe: function (msgName, fn) {
             if(/^[\w_\-\.]+$/.test(msgName)){
                this.invoke('subscribeSystemMessage-' + msgName);
                this.on('onSystemMessage-' + msgName, fn);
             } else {
                alert("消息名不正确");
             }
        },

        subscribes: function(msgNames, fn) {
            if(typeof(msgNames) == 'string'){
                msgNames = msgNames.split(',');
            }
            if(Array.isArray(msgNames)){
                var self = this;
                 msgNames.forEach(function (item){
                      self.subscribe(item.trim(), fn);
                 });
            } else {
                alert("消息集合格式不正确");
            }
        },

        send: function(type, data, callback) {
            assert(is(type, "string") && is(data, "object"), "Webview调用EsApp.send(type, data): 参数类型错误");
            if (is(callback, "function")) {
                var eventName = WEB_FOR_APP + type;
                this.removeListener(eventName, null, true);
                this.once(eventName, callback)
            }
            this.invoke(WEB_FOR_APP, {
                type: type,
                data: data
            })
        },
        get: function(type, callback, params) {
            assert(is(type, "string") && is(callback, "function"), "Webview调用EsApp.get(type, callback): 参数错误");
            this.once(APP_FOR_WEB + type, callback);
            var options = {
                type: type
            };
            if (params != null) {
                options.params = params
            }
            this.invoke(APP_FOR_WEB, options)
        },
        _events: {},
        _trigger: function(type, data) {
            var list = this._events[type];
            if (list && list.length) {
                var arr = [];
                list.forEach(function(handler) {
                    handler.call(this, data);
                    if (handler.__once) {
                        arr.push(handler)
                    }
                },
                this);
                if (arr.length) {
                    arr.forEach(function(handler) {
                        this.removeListener(type, handler)
                    },
                    this)
                }
            }
        },

        getHorizontalViewLoc: function forAppToGetRegion(){
                          	try{
                          		var dom = document.querySelectorAll('.forapptogetregion');
                          		if(dom.length>0){
                          			var result = [];
                          			for(var i=0;i<dom.length;i++){
                          				var item = dom[i];
                          				var rect = item.getClientRects(),t = rect[0].top>>0 ;
                          				if(t + item.offsetHeight>0){
                          					result.push({y0:t,y1:t + item.offsetHeight >>0 })
                          				}

                          			}
                                nativeApi._getHorizontalLocation(JSON.stringify(result));
                          		}else{
                          		nativeApi._getHorizontalLocation(1);
                          		}
                          	}catch(e){
                          		nativeApi._getHorizontalLocation(1);
                   }
        },
        on: function(type, handler) {
            assert(is(type, "string") && is(handler, "function"), "Webview调用EsApp.on(type, handler): 参数错误");
            var list = this._events[type] || (this._events[type] = []);
            if (list.indexOf(handler) === -1) {
                list.push(handler)
            }
        },
        once: function(type, handler) {
            assert(is(type, "string") && is(handler, "function"), "Webview调用EsApp.once(type, handler): 参数错误");
            function wrap() {
                handler.apply(EsApp, arguments)
            }
            wrap.__once = true;
            this.on(type, wrap)
        },
        off: function(type, handler, removeOnce) {
            var list = this._events[type];
            if (!list || !list.length) {
                return
            }
            if (removeOnce) {
                list.slice().forEach(function(func) {
                    if (func.__once) {
                        list.splice(list.indexOf(func), 1)
                    }
                })
            } else {
                if (handler) {
                    var index = list.indexOf(handler);
                    if (index !== -1) {
                        list.splice(index, 1)
                    }
                } else {
                    list.length = 0
                }
            }
        },
        encryString: function(source, fn){
            if(typeof fn != 'function'){
                return;
            }

            if(typeof source != 'string'){
                fn(true, "只能对字符串进行加密处理");
                return;
            }

            source = encodeURIComponent(source.trim());

            var encryptData = nativeApi._esunEncrypt(source);
            fn(encryptData == null , encryptData);
        },

        isBindedEvent: function(eventName){
                    var list = ESOpen._events[eventName];
                    if(!list || list.length == 0){
                        return false;
                    }
                    return true;
        },

        queryStringSign: function(source , fn){
                if(typeof fn != 'function'){
                    return;
                }

                if(typeof source != 'string'){
                    fn(true, "只能对字符串进行签名处理");
                    return;
                }

                var dataSigned = nativeApi._esunSignature(source);
                fn(dataSigned == null , dataSigned);
        },
        hasApi: function (name){
            return ([/*__InvokeList__*/]).indexOf(name) != -1;
        },
    
        hasEvent: function (event){
            return ([/*__EventList__*/]).indexOf(event) != -1;
        }
    };


    if ('scrollRestoration' in history) {
        /* 处理记住滚动位置 */
        history.scrollRestoration = 'manual';
    }

    ["config", "shareTo", "getNetworkType", "hideNavbar", "showNavbar",
    "closeWindow", "setTitle", "setNavbar", "navigateTo", "login", "openUrl", "openMiniApp","playRewardAD",
    "openEsun", "getLocation", "getAppVersion", "checkSession", "checkLogin", "closePage","eqqAD"].forEach(function(interfaceName) {
        wrapper[interfaceName] = function(options) {
            return this.invokeWithCallback(options, interfaceName);
        }
    });

    if (window.ESOpenReady) {
        window.ESOpenReady();
    }

    for (var key in wrapper) {
        nativeApi[key] = wrapper[key]
    }
    nativeApi.on("invalidrabbit", function(rabbit) {
    });

    var autoOffsetYBody = 0 /*__MINIAPP_STATUS_HEIGHT__*/;
    esunDomReady(function() {
            /* fixTitle(); */
            /* 添加class标记 */
            var className = document.documentElement.className;
            document.documentElement.className = (className ? (className + " ") : "") + "es-is-android es-is-app";
            /* 嵌入style */
            var style = document.createElement('style');
            var injectStyle = ""
            /*__MINIAPP_INLINESTYLE__*/
            ;
            var dpr = document.documentElement.getAttribute('data-dpr');
            if (dpr) {
                injectStyle = injectStyle.replace(/([\d\.]+)(?=px)/g,
                function(v) {
                    return v * dpr;
                });
            }
            style.innerHTML = injectStyle;
            document.head.appendChild(style);
            /* 其它嵌入脚本 */
            /*__MINIAPP_DOMCONTENTLOADED_SCRIPT__*/
        });

        nativeApi.onApiReady && nativeApi.onApiReady()
})(window);

window.ESOpen._onReady();