(function(exports) {

    (function() {
        function a() {
            b || (b = !0, c.forEach(function(b) {
                b()
            }), c = [])
        }
        function d() {
            b || /loaded|complete/i.test(document.readyState) ? a() : requestAnimationFrame ? requestAnimationFrame(d) : setTimeout(d, 0)
        }
        var b, c = [];
        document.addEventListener("DOMContentLoaded", a, !1);
        document.addEventListener("load", a, !1);
        d();
        window.esunDomReady = function(a) {
            b ? a() : c.push(a)
        }
    })();

    function isWhiteList(list){
        if(Array.isArray(list)){
          var host = (location.hostname || "").toLowerCase();
          return list.filter(function(domain){
            return host.endsWith(domain);
          }).length > 0;
        } else if(!list){
          return true;
        }
        return false;
      }

     if (!isWhiteList(/*__whiteList__*/)) {
         return;
     }

    function assert(assertion, msg) {
        if (!assertion) {
            alert(msg)
        }
    }

    function is(unknow, assertion) {
        return typeof unknow === assertion
    }

    function getType(obj){
        return (Object.prototype.toString.call(obj)+'').replace(/^\[object\s+(\w+)\]$/, '$1').toLowerCase();
    }

    function isPlainObject(obj) {
        return obj && Object.prototype.toString.call(obj) === '[object Object]';
    }

     var guidSeed = 1000;
     function getGuid(prefix) {
         guidSeed++;
         return (prefix || 'guid') + '_' + guidSeed;
     }

    var allSupports = ["login.forceLogin","middle","setDarkStatus","clearcache","eqqAD","getpermission"];
    var nativeApi = exports.EsApp;

    var WEB_FOR_APP = "web4app";
    var APP_FOR_WEB = "app4web";

    var wrapper = {
        isAndroid: true,
        statusBarHeight: 0 /*__StatusBarHeight__*/,
        getInfo: function() {
            var info;
            try {
                info = nativeApi._getInfo()
            } catch(e) {
                return alert("客户端EsApp._getInfo()接口异常\n" + e)
            }
            try {
                info = JSON.parse(info)
            } catch(e) {
                alert("客户端EsApp._getInfo()返回值数据格式不正确\n" + info)
            }
            info.platform = "1";
            return info
        },
        _protocol: function() {
            try {
                return nativeApi._getProtocolName()
            } catch(e) {
                alert("客户端EsApp._getProtocolName()调用异常\n" + e)
            }
        },
        invokeWithCallback: function(options, invokeName) {
            if(!options){
                options = {};
            }
            if(getType(options) == 'string'){
                 if("/navigateTo/openUrl/openEsun/".indexOf("/" + invokeName + "/") > -1){
                     options = {url: options}
                 } else {
                     options = {title: options}
                 }
            }
            if (!isPlainObject(options)) {
                alert("[ESAPP]: 参数格式错误(" + invokeName + ')');
                return false;
            }
            var params = {
                options: options
            };
            if (options.success) {
                params.successCallbackName = getGuid(invokeName + "_success");
                window[params.successCallbackName] = options.success;
            }
            if (options.error) {
                params.errorCallbackName = getGuid(invokeName + "_error");
                window[params.errorCallbackName] = options.error;
            }

            /* 去除不合法的内容 */
            var types = "string,object,number,boolean,";
            for(var k in options){
                if(types.indexOf(getType(options[k]) + ',') == -1){
                   delete options[k];
                }
            }
            this.invoke(invokeName, params);
            return true;
        },
        invoke: function(rabbitName, options) {
            assert(is(rabbitName, "string"), "Webview调用EsApp.invoke(rabbitName): rabbitName未提供");

            if(!is(options, 'object')){
                options = {value: options};
            }

            options = options || {};
            var params = [],
            key,
            val;
            for (key in options) {
                val = options[key];
                if (is(val, "object")) {
                    val = JSON.stringify(val);
                }
                params.push(key + "=" + encodeURIComponent(val));
            }
            if (params.length) {
                params = "?" + params.join("&")
            } else {
                params = ""
            }
            try {
                nativeApi._invoke(this._protocol() + rabbitName + params)
            } catch(e) {
                alert("客户端EsApp._invoke接口异常\n" + e)
            }
        },


        publish: function (msgName, args) {
            if(/^[\w_\-\.]+$/.test(msgName) && JSON.stringify(args).length < 1024){
                this.invoke('triggerSystemMessage-' + msgName, args);
             } else {
                alert("消息名不正确或者参数过长");
             }
        },

        subscribe: function (msgName, fn) {
             if(/^[\w_\-\.]+$/.test(msgName)){
                this.invoke('subscribeSystemMessage-' + msgName);
                this.on('onSystemMessage-' + msgName, fn);
             } else {
                alert("消息名不正确");
             }
        },

        subscribes: function(msgNames, fn) {
            if(typeof(msgNames) == 'string'){
                msgNames = msgNames.split(',');
            }
            if(Array.isArray(msgNames)){
                var self = this;
                 msgNames.forEach(function (item){
                      self.subscribe(item.trim(), fn);
                 });
            } else {
                alert("消息集合格式不正确");
            }
        },

        send: function(type, data, callback) {
            assert(is(type, "string") && is(data, "object"), "Webview调用EsApp.send(type, data): 参数类型错误");
            if (is(callback, "function")) {
                var eventName = WEB_FOR_APP + type;
                this.removeListener(eventName, null, true);
                this.once(eventName, callback)
            }
            this.invoke(WEB_FOR_APP, {
                type: type,
                data: data
            })
        },
        get: function(type, callback, params) {
            assert(is(type, "string") && is(callback, "function"), "Webview调用EsApp.get(type, callback): 参数错误");
            this.once(APP_FOR_WEB + type, callback);
            var options = {
                type: type
            };
            if (params != null) {
                options.params = params
            }
            this.invoke(APP_FOR_WEB, options)
        },
        _events: {},
        _trigger: function(type, data) {
            var list = this._events[type];
            if (list && list.length) {
                var arr = [];
                list.forEach(function(handler) {
                    handler.call(this, data);
                    if (handler.__once) {
                        arr.push(handler)
                    }
                },
                this);
                if (arr.length) {
                    arr.forEach(function(handler) {
                        this.removeListener(type, handler)
                    },
                    this)
                }
            }
        },

        getHorizontalViewLoc: function forAppToGetRegion(){
                          	try{
                          		var dom = document.querySelectorAll('.forapptogetregion');
                          		if(dom.length>0){
                          			var result = [];
                          			for(var i=0;i<dom.length;i++){
                          				var item = dom[i];
                          				var rect = item.getClientRects(),t = rect[0].top>>0 ;
                          				if(t + item.offsetHeight>0){
                          					result.push({y0:t,y1:t + item.offsetHeight >>0 })
                          				}

                          			}
                                nativeApi._getHorizontalLocation(JSON.stringify(result));
                          		}else{
                          		nativeApi._getHorizontalLocation(1);
                          		}
                          	}catch(e){
                          		nativeApi._getHorizontalLocation(1);
                   }
        },
        on: function(type, handler) {
            assert(is(type, "string") && is(handler, "function"), "Webview调用EsApp.on(type, handler): 参数错误");
            var list = this._events[type] || (this._events[type] = []);
            if (list.indexOf(handler) === -1) {
                list.push(handler)
            }
        },
        once: function(type, handler) {
            assert(is(type, "string") && is(handler, "function"), "Webview调用EsApp.once(type, handler): 参数错误");
            function wrap() {
                handler.apply(EsApp, arguments)
            }
            wrap.__once = true;
            this.on(type, wrap)
        },
        removeListener: function(type, handler, removeOnce) {
            var list = this._events[type];
            if (!list || !list.length) {
                return
            }
            if (removeOnce) {
                list.slice().forEach(function(func) {
                    if (func.__once) {
                        list.splice(list.indexOf(func), 1)
                    }
                })
            } else {
                if (handler) {
                    var index = list.indexOf(handler);
                    if (index !== -1) {
                        list.splice(index, 1)
                    }
                } else {
                    list.length = 0
                }
            }
        },
        encryString: function(source, fn){
            if(typeof fn != 'function'){
                return;
            }

            if(typeof source != 'string'){
                fn(true, "只能对字符串进行加密处理");
                return;
            }

            source = encodeURIComponent(source.trim());

            var encryptData = nativeApi._esunEncrypt(source);
            fn(encryptData == null , encryptData);
        },

        queryStringSign: function(source , fn){
            if(typeof fn != 'function'){
                return;
            }

            if(typeof source != 'string'){
                fn(true, "只能对字符串进行签名处理");
                return;
            }

            var dataSigned = nativeApi._esunSignature(source);
            fn(dataSigned == null , dataSigned);
        },
        isSupported: function(key){
            return allSupports.indexOf(key) > -1;
        },
 
        fullScreen: function(isFull){
            var classList = document.documentElement.classList;
            if(isFull){
                classList.add("es-is-full");
            }else{
                classList.remove("es-is-full");
            }
        }
    };

    ["playRewardAD","playRewardAd"].forEach(function(interfaceName) {
        wrapper[interfaceName] = function(options) {
            return this.invokeWithCallback(options, interfaceName);
        }
    });

    for (var key in wrapper) {
        nativeApi[key] = wrapper[key]
    }
    nativeApi.on("invalidrabbit",
    function(rabbit) {
    });
    nativeApi.onApiReady && nativeApi.onApiReady();

    function webConfig(){
        var match = location.search.match(/webconf=([^&]+)/);
        var ret = {};
        if(match){
            var query = decodeURIComponent(match[1]);
            query.split("&").forEach(function(kqv){
                var list = kqv.split('=');
                if(list.length == 2){
                    ret[list[0]] = list[1];
                }
            });
        }
        return ret;
    }

    esunDomReady(function() {
        /* 添加class标记 */
        var webconf = webConfig();
        var classList = document.documentElement.classList;
        classList.add("es-is-ios");
        classList.add("es-is-app");
        if(webconf.hiddenTitle == "1"){
           EsApp.fullScreen(true);
        }else {
           EsApp.statusBarHeight = 0;
        }
        /* 嵌入style */
        var style = document.createElement('style');
        var injectStyle = ""
        /*__MINIAPP_INLINESTYLE__*/
        ;
        var dpr = document.documentElement.getAttribute('data-dpr');
        if (dpr) {
            injectStyle = injectStyle.replace(/([\d\.]+)(?=px)/g,
            function(v) {
                return v * dpr;
            });
        }
        style.innerHTML = injectStyle;
        document.head.appendChild(style);
        /* 其它嵌入脚本 */
        /*__MINIAPP_DOMCONTENTLOADED_SCRIPT__*/
    });

})(window);

window.EsApp._onReady();