precision mediump float;
precision highp int;

uniform sampler2D texSampler;
uniform float ambientIntensity;

varying vec2 fragment_uv;
varying float fragment_light;

const vec3 magenta = vec3(1.0, 0.0, 1.0);

void main()
{
    vec3 color = vec3(texture2D(texSampler, fragment_uv));
    if (color == magenta) {
        discard;
    }

    vec3 dark = vec3(0.28 + fragment_light * 0.72, 
                     0.23 + fragment_light * 0.77,
                     0.38 + fragment_light * 0.62);
    color = color * dark;

    float ambient = 0.33 + ambientIntensity * 0.67;
    vec3 finalColor = ambient * color;
    gl_FragColor = vec4(finalColor, 1.0);
}
