precision highp float;

uniform int started;
uniform sampler2D sample_y;
uniform sampler2D sample_cbcr;

varying vec2 fragment_uv;

void main() {
    vec4 videoColor = vec4(0.0, 0.0, 0.0, 1.0);
    if(started == 1) {
        vec4 Y_planeColor = texture2D(sample_y, fragment_uv);
        vec4 CbCr_planeColor = texture2D(sample_cbcr, fragment_uv);

        float Cb, Cr, Y;
        float R, G, B;
        Y = Y_planeColor.r * 255.0;
        Cb = CbCr_planeColor.r * 255.0 - 128.0;
        Cr = CbCr_planeColor.a * 255.0 - 128.0;

        R = 1.402 * Cr + Y;
        G = -0.344 * Cb - 0.714 * Cr + Y;
        B = 1.772 * Cb + Y;

        videoColor = vec4(R / 255.0, G / 255.0, B / 255.0, 1.0);
    }
    gl_FragColor = videoColor;
}
