uniform sampler2D sampler;
uniform sampler2D sky_sampler;
uniform float timer;

varying vec2 fragment_uv;
varying float fog_factor;
varying float fog_height;
varying float fragment_light;
varying float fragment_sunlight;

void main() {
    vec3 color = vec3(texture2D(sampler, fragment_uv));
    
//    vec3 dark = vec3(0.28 + fragment_light * 0.72,
//                     0.23 + fragment_light * 0.77,
//                     0.38 + fragment_light * 0.62); // original version
    
    
//    vec3 dark = vec3(0.03 + fragment_light * 0.97,
//                     0.02 + fragment_light * 0.98,
//                     0.04 + fragment_light * 0.96);
    
    /*
    vec3 dark = vec3(0.03 + fragment_sunlight * 0.15 + fragment_light * 0.82,
                     0.02 + fragment_sunlight * 0.15 + fragment_light * 0.83,
                     0.04 + fragment_sunlight * 0.20 + fragment_light * 0.76); // more moonlight at night (only if it is not inside caves, and more blue too)  */
    
    vec3 dark = vec3(0.13 + fragment_sunlight * 0.15 + fragment_light * 0.72,
                     0.12 + fragment_sunlight * 0.15 + fragment_light * 0.73,
                     0.17 + fragment_sunlight * 0.18 + fragment_light * 0.65);
    
    color = color * dark;
    color.z = clamp(color.z + 0.05 * (1.0-fragment_light), 0.0, 1.0); // shadows and nights a little bit more blue, even more
    
    vec3 sky_color = vec3(texture2D(sky_sampler, vec2(timer, 1.0 - fog_height)));
    color = mix(color, sky_color, fog_factor);
    
    gl_FragColor = vec4(color, 1.0);
}
