// VERTEX SHADER
uniform vec3 camera;
uniform float fog_distance;
uniform float daylight;

attribute vec4 position;
attribute vec3 uv;
attribute float sunLight;

varying vec2 fragment_uv;
varying float fragment_light; // has both artificial and sunlight
varying float fragment_sunlight; // only the information about sunlight, can be used to detect if inside caves or not
varying float fog_factor;
varying float fog_height;

const float pi = 3.14159265;

void main() {
    gl_Position = CC_MVPMatrix * position;

    fragment_uv = uv.xy;
    
    //fragment_light = clamp(uv.z + daylight * 0.75, 0.0, 1.0); // original version
    fragment_light = clamp( uv.z  + sunLight * daylight, 0.0, 1.0 );
    //fragment_light = clamp( max(uv.z, sunLight * daylight), 0.0, 1.0 );
    
    float camera_distance = distance(camera, vec3(position));
    fog_factor = pow(clamp(camera_distance / fog_distance, 0.0, 1.0), 4.0);
    float dy = position.y - camera.y;
    float dx = distance(position.xz, camera.xz);
    fog_height = (atan(dy, dx) + pi / 2.0) / pi; // it will be used as (1-fog_height) in the frag -> reference is the vertical axis
    fragment_sunlight = sunLight;
}
