// VERTEX SHADER
uniform vec3 camera;
uniform float fog_distance;
uniform vec2 cloud_uv_left; //bottom-left
uniform vec2 cloud_uv_right; //top-right

attribute vec4 position;
attribute vec3 uv;
attribute float sunLight;

uniform float daylight;

varying vec2 fragment_uv;
varying float fragment_light;
varying float fog_factor;
varying float fog_height;

varying float fragment_sunlight; // only the information about sunlight, detect if inside caves or not

const float pi = 3.14159265;

void main() {
    gl_Position = CC_MVPMatrix * position;
    
    if (uv.x >= cloud_uv_left.x &&
        uv.x <= cloud_uv_right.x &&
        uv.y <= cloud_uv_left.y &&
        uv.y >= cloud_uv_right.y) {
        gl_Position = vec4(0,0,0,0);
    }
    
    fragment_uv = uv.xy;
    fragment_light = clamp(uv.z + daylight * 0.75, 0.0, 1.0);
    //fragment_light = clamp( max(uv.z, sunLight * daylight), 0.0, 1.0 ); // change here to be like the block.vert
    
    float camera_distance = distance(camera, vec3(position));
    fog_factor = pow(clamp(camera_distance / fog_distance, 0.0, 1.0), 4.0);
    float dy = position.y - camera.y;
    float dx = distance(position.xz, camera.xz);
    fog_height = (atan(dy, dx) + pi / 2.0) / pi;
    
    fragment_sunlight = sunLight;
}
