precision mediump float;
precision highp int;

uniform sampler2D sampler;
uniform float height;

uniform vec2 backgroundBlockTex;

varying vec4 fragment_color;
varying vec2 fragment_uv;

varying float fragment_light;
varying float diffuse;

varying highp float h;
uniform highp float normalOffset;

const float pi = 3.14159265;

void main() {
    
    vec3 color = vec3(texture2D(sampler, fragment_uv));
    
    float df = 0.25 + diffuse * 0.75;
    
    float alpha = 1.0;
    
    if (h > height + 3.5) discard;
    if (h > height)
    {
        discard;
    }

    if (color == vec3(1.0, 0.0, 1.0)) {
        discard;
    }
    
    vec3 dark = vec3(0.28 + fragment_light * 0.72, 
                     0.23 + fragment_light * 0.77,
                     0.38 + fragment_light * 0.62);
    
    color = color * dark;
    
    vec4 finalColor = vec4( color, alpha ) * fragment_color;
    
    if (normalOffset == 0.0)
    {
        if (abs(height - h) < 0.5)
        {
            float whitefy = (0.5 - abs(height - h)) * 2.0;
            color = color * (1.0 - whitefy) + vec3(1.00, 1.00, 1.00) * whitefy;
        }
        
        gl_FragColor = vec4( color, 1.0) ;
    }
    else
    {
        gl_FragColor = vec4(1.0, 1.0, 1.0, 1.0);
    }
}
