// VERTEX SHADER
uniform mat4 matrix;

attribute vec4 position;
attribute vec3 uv;

varying vec2 fragment_uv;
varying vec4 fragment_color;
varying float fragment_light;
varying float diffuse;

varying float h;

const float pi = 3.14159265;
const vec3 light_direction = normalize(vec3(-0.3, 1.0, 0.6));

void main() {
    
    vec4 color = vec4(0.5, 0.5, 0.5, 0.5);
    
    gl_Position = matrix * position;
    fragment_uv = uv.xy;
    fragment_light = uv.z + 1.0;
    diffuse = dot(vec3(1.0), light_direction);
    
    h = position.y + 0.5;
    fragment_color = color;
}

