uniform sampler2D sampler;
uniform int areaClear;

varying vec4 fragment_color;
varying vec2 fragment_uv;

void main() {
    vec3 color = vec3(texture2D(sampler, fragment_uv));
    float alpha = 1.0;
    if (color == vec3(1.0, 0.0, 1.0)) {
        //discard;
        alpha = 0.0;
    }
    
    vec4 finalColor;
    if (areaClear != 1) {
        finalColor = vec4( color * vec3( 0.9, 0.1, 0.1 ), 0.6 );
    }
    else {
        finalColor = vec4( color, alpha ) * fragment_color;
    }
    
    gl_FragColor = finalColor;
}
