uniform sampler2D sampler;
uniform vec2 subtexture_size;
uniform float anim_timer;
uniform vec2 cam_rotation;

varying vec2 fragment_uv;
varying vec2 subtexture_coord;
varying float anim_speed;

const float pi = 3.14159265358979323846;
const float tau = pi * 2.0;
const float amplitude = 0.02;
const float numberOfWaves = 2.5;

void main() {
    // animation of sinouseidal effect's amplitude
    float animAmplitude = amplitude * sin(anim_speed * anim_timer * tau);
    
    // sinouseidal effect that follows the camera
    vec2 uv = fragment_uv;
    uv.y -= animAmplitude * sin(uv.x * numberOfWaves * tau);
    uv.x += cam_rotation.x / tau * 3.0;
    uv.y -= cam_rotation.y / tau * 3.0;
    uv = subtexture_coord + (fract(uv) + vec2(0.5, -0.5)) * subtexture_size;
    
    vec3 color = vec3(texture2D(sampler, uv));

    // interpolate between original texture and pure white
    // to attenuate multiplicative blending effect
    color = color + (vec3(1.0) - color) * 0.5;
    
    // alpha of pixel only have effect on lava 2d layer
    gl_FragColor = vec4(color, 0.5);
}
