precision highp float;

uniform sampler2D sampler;
uniform sampler2D sky_sampler;
uniform float timer;
uniform float anim_timer;
uniform vec2 subtexture_size;

varying vec2 fragment_uv;
varying float fog_factor;
varying float fog_height;
varying float fragment_light;
varying float fragment_sunlight;
varying vec2 subtexture_coord;
varying float fragment_alpha;
varying float anim_angle;
varying float anim_speed;

void main() {
    float cosx = cos(anim_angle);
    float sinx = sin(anim_angle);
    
    vec2 uv = fragment_uv;
    uv -= vec2(0.5);
    uv = mat2(cosx, -sinx,
              sinx, cosx) * uv;
    uv.x -= anim_speed * anim_timer;
    uv += vec2(0.5);
    uv = subtexture_coord + (fract(uv) + vec2(0.5, -0.5)) * subtexture_size;
    
    vec3 color = vec3(texture2D(sampler, uv));
    
    vec3 dark = vec3(0.13 + fragment_sunlight * 0.15 + fragment_light * 0.72,
                     0.12 + fragment_sunlight * 0.15 + fragment_light * 0.73,
                     0.17 + fragment_sunlight * 0.18 + fragment_light * 0.65);
    
    color = color * dark;
    color.z = clamp(color.z + 0.05 * (1.0-fragment_light), 0.0, 1.0); // shadows and nights a little bit more blue, even more
    
    vec3 sky_color = vec3(texture2D(sky_sampler, vec2(timer, 1.0 - fog_height)));
    color = mix(color, sky_color, fog_factor);
    
    gl_FragColor = vec4(color, fragment_alpha);
}
