// VERTEX SHADER
precision highp float;

uniform vec3 camera;
uniform float fog_distance;
uniform float daylight;
uniform float isUnderwater;

attribute vec4 position;
attribute vec3 uv;
attribute float sunLight;
attribute vec2 subtex_coord;
attribute float insideAlpha;
attribute float outsideAlpha;
attribute float angle;
attribute float speed;

varying vec2 fragment_uv;
varying float fragment_light;
varying float fragment_sunlight;
varying float fog_factor;
varying float fog_height;
varying vec2 subtexture_coord;
varying float fragment_alpha;
varying float anim_angle;
varying float anim_speed;

const float pi = 3.14159265;
const float eps = 1e-4;

void main() {
    fragment_alpha = outsideAlpha + (insideAlpha - outsideAlpha) * isUnderwater;
    
    gl_Position = CC_MVPMatrix * position;
    gl_Position.z -= (1.0 - fragment_alpha) * eps;
    
    fragment_uv = uv.xy;
    fragment_light = clamp(uv.z + sunLight * daylight, 0.0, 1.0);
    fragment_sunlight = sunLight;
    
    float camera_distance = distance(camera, vec3(position));
    fog_factor = pow(clamp(camera_distance / fog_distance, 0.0, 1.0), 4.0);
    float dy = position.y - camera.y;
    float dx = distance(position.xz, camera.xz);
    fog_height = (atan(dy, dx) + pi / 2.0) / pi;
    
    subtexture_coord = subtex_coord;
    anim_angle = angle;
    anim_speed = speed;
}
