precision mediump float;

uniform sampler2D sky_sampler;
uniform float timer;
uniform sampler2D sky_stars;

varying vec2 fragment_uv;
varying vec2 fragment_uvStars;
varying float latitudeMultiplierForStars;

void main() {
    vec2 uv = vec2(timer, fragment_uv.t);
    float starsMultiplier = 4.0 * (timer-0.5) * (timer-0.5); // stars must disappear at midday
    gl_FragColor = texture2D(sky_sampler, uv) + texture2D(sky_stars, fragment_uvStars) * starsMultiplier * latitudeMultiplierForStars;
}
