uniform mat4 matrix;

attribute vec4 position;
attribute vec2 uv;
attribute vec2 uvStars;

varying vec2 fragment_uv;
varying vec2 fragment_uvStars;
varying float latitudeMultiplierForStars;

void main() {
    gl_Position = matrix * position;
    fragment_uv = uv;
    fragment_uvStars = uvStars;
    
    // Regulating the height in which stars must disappear:
    float heightForDisappearingStars = 0.0; // the sky sphere goes from -1.0 to 1.0 in the y axis, and the others too (I used -0.1 previously for example)
    
    latitudeMultiplierForStars = clamp(max(0.0, position.y - heightForDisappearingStars), 0.0, 1.0);
}
