precision mediump float;
precision highp int;

uniform sampler2D sampler;
uniform sampler2D sky_sampler;
uniform float timer;

varying vec2 fragment_uv;

varying float fragment_light;
varying float fog_factor;
varying float fog_height;

void main() {
    vec3 color = vec3(texture2D(sampler, fragment_uv));
    if (color == vec3(1.0, 0.0, 1.0)) {
        discard;
    }
    
    /*
    vec3 dark = vec3(0.28 + fragment_light * 0.72,
                     0.23 + fragment_light * 0.77,
                     0.38 + fragment_light * 0.62);
    */
    
    
    vec3 dark = vec3(0.03 + fragment_light * 0.97,
                     0.02 + fragment_light * 0.98,
                     0.04 + fragment_light * 0.96);
    
    /*
    vec3 dark = vec3(0.06 + fragment_light * 0.94,
                     0.05 + fragment_light * 0.95,
                     0.07 + fragment_light * 0.93); // to be the same as block.vert
    */
    color = color * dark;
    
    vec3 sky_color = vec3(texture2D(sky_sampler, vec2(timer, 1.0 - fog_height)));
    color = mix(color, sky_color, fog_factor);
    
    gl_FragColor = vec4(color, 1.0);
}
